/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.Tool;
import org.locationtech.geowave.adapter.vector.FeatureDataAdapter;
import org.locationtech.geowave.analytic.AnalyticFeature;
import org.locationtech.geowave.analytic.IndependentJobRunner;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.ScopedJobConfiguration;
import org.locationtech.geowave.analytic.mapreduce.MapReduceIntegration;
import org.locationtech.geowave.analytic.mapreduce.MapReduceJobRunner;
import org.locationtech.geowave.analytic.mapreduce.ToolRunnerMapReduceIntegration;
import org.locationtech.geowave.analytic.param.FormatConfiguration;
import org.locationtech.geowave.analytic.param.InputParameters;
import org.locationtech.geowave.analytic.param.OutputParameters;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.locationtech.geowave.analytic.param.StoreParameters;
import org.locationtech.geowave.analytic.store.PersistableStore;
import org.locationtech.geowave.core.geotime.index.SpatialDimensionalityTypeProvider;
import org.locationtech.geowave.core.geotime.index.SpatialOptions;
import org.locationtech.geowave.core.store.adapter.InternalAdapterStore;
import org.locationtech.geowave.core.store.adapter.InternalDataAdapter;
import org.locationtech.geowave.core.store.adapter.PersistentAdapterStore;
import org.locationtech.geowave.core.store.api.DataStore;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.index.CustomNameIndex;
import org.locationtech.geowave.core.store.index.IndexStore;
import org.locationtech.geowave.mapreduce.JobContextAdapterStore;
import org.locationtech.geowave.mapreduce.JobContextIndexStore;
import org.locationtech.geowave.mapreduce.JobContextInternalAdapterStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GeoWaveAnalyticJobRunner
extends Configured
implements Tool,
MapReduceJobRunner,
IndependentJobRunner {
    protected static final Logger LOGGER = LoggerFactory.getLogger(GeoWaveAnalyticJobRunner.class);
    private FormatConfiguration inputFormat = null;
    private FormatConfiguration outputFormat = null;
    private int reducerCount = 1;
    private MapReduceIntegration mapReduceIntegrater = new ToolRunnerMapReduceIntegration();
    private Counters lastCounterSet = null;

    public FormatConfiguration getInputFormatConfiguration() {
        return this.inputFormat;
    }

    public void setInputFormatConfiguration(FormatConfiguration inputFormat) {
        this.inputFormat = inputFormat;
    }

    public FormatConfiguration getOutputFormatConfiguration() {
        return this.outputFormat;
    }

    public void setOutputFormatConfiguration(FormatConfiguration outputFormat) {
        this.outputFormat = outputFormat;
    }

    public MapReduceIntegration getMapReduceIntegrater() {
        return this.mapReduceIntegrater;
    }

    public void setMapReduceIntegrater(MapReduceIntegration mapReduceIntegrater) {
        this.mapReduceIntegrater = mapReduceIntegrater;
    }

    public int getReducerCount() {
        return this.reducerCount;
    }

    public void setReducerCount(int reducerCount) {
        this.reducerCount = reducerCount;
    }

    protected static Logger getLogger() {
        return LOGGER;
    }

    public Class<?> getScope() {
        return this.getClass();
    }

    public DataStore getDataStore(PropertyManagement runTimeProperties) throws Exception {
        PersistableStore store = (PersistableStore)StoreParameters.StoreParam.INPUT_STORE.getHelper().getValue(runTimeProperties);
        return store.getDataStoreOptions().createDataStore();
    }

    public PersistentAdapterStore getAdapterStore(PropertyManagement runTimeProperties) throws Exception {
        PersistableStore store = (PersistableStore)StoreParameters.StoreParam.INPUT_STORE.getHelper().getValue(runTimeProperties);
        return store.getDataStoreOptions().createAdapterStore();
    }

    public InternalAdapterStore getInternalAdapterStore(PropertyManagement runTimeProperties) throws Exception {
        PersistableStore store = (PersistableStore)StoreParameters.StoreParam.INPUT_STORE.getHelper().getValue(runTimeProperties);
        return store.getDataStoreOptions().createInternalAdapterStore();
    }

    public IndexStore getIndexStore(PropertyManagement runTimeProperties) throws Exception {
        PersistableStore store = (PersistableStore)StoreParameters.StoreParam.INPUT_STORE.getHelper().getValue(runTimeProperties);
        return store.getDataStoreOptions().createIndexStore();
    }

    @Override
    public int run(Configuration configuration, PropertyManagement runTimeProperties) throws Exception {
        if (this.inputFormat == null && runTimeProperties.hasProperty((ParameterEnum)InputParameters.Input.INPUT_FORMAT)) {
            this.inputFormat = (FormatConfiguration)runTimeProperties.getClassInstance((ParameterEnum)InputParameters.Input.INPUT_FORMAT, FormatConfiguration.class, null);
        }
        if (this.inputFormat != null) {
            InputParameters.Input.INPUT_FORMAT.getHelper().setValue(configuration, this.getScope(), this.inputFormat.getClass());
            this.inputFormat.setup(runTimeProperties, configuration);
        }
        if (this.outputFormat == null && runTimeProperties.hasProperty((ParameterEnum)OutputParameters.Output.OUTPUT_FORMAT)) {
            this.outputFormat = (FormatConfiguration)runTimeProperties.getClassInstance((ParameterEnum)OutputParameters.Output.OUTPUT_FORMAT, FormatConfiguration.class, null);
        }
        if (this.outputFormat != null) {
            OutputParameters.Output.OUTPUT_FORMAT.getHelper().setValue(configuration, this.getScope(), this.outputFormat.getClass());
            this.outputFormat.setup(runTimeProperties, configuration);
        }
        runTimeProperties.setConfig(new ParameterEnum[]{StoreParameters.StoreParam.INPUT_STORE}, configuration, this.getScope());
        OutputParameters.Output.REDUCER_COUNT.getHelper().setValue(configuration, this.getScope(), (Object)runTimeProperties.getPropertyAsInt((ParameterEnum)OutputParameters.Output.REDUCER_COUNT, this.reducerCount));
        return this.mapReduceIntegrater.submit(configuration, runTimeProperties, this);
    }

    public static void addDataAdapter(Configuration config, InternalDataAdapter<?> adapter) {
        JobContextAdapterStore.addDataAdapter((Configuration)config, (DataTypeAdapter)adapter.getAdapter());
        JobContextInternalAdapterStore.addTypeName((Configuration)config, (String)adapter.getTypeName(), (short)adapter.getAdapterId());
    }

    public static void addIndex(Configuration config, Index index) {
        JobContextIndexStore.addIndex((Configuration)config, (Index)index);
    }

    public int run(String[] args) throws Exception {
        Counters counters;
        FormatConfiguration outputFormat;
        Job job = this.mapReduceIntegrater.getJob(this);
        this.configure(job);
        ScopedJobConfiguration configWrapper = new ScopedJobConfiguration(job.getConfiguration(), this.getScope());
        FormatConfiguration inputFormat = (FormatConfiguration)configWrapper.getInstance((Enum)InputParameters.Input.INPUT_FORMAT, FormatConfiguration.class, null);
        if (inputFormat != null) {
            job.setInputFormatClass(inputFormat.getFormatClass());
        }
        if ((outputFormat = (FormatConfiguration)configWrapper.getInstance((Enum)OutputParameters.Output.OUTPUT_FORMAT, FormatConfiguration.class, null)) != null) {
            job.setOutputFormatClass(outputFormat.getFormatClass());
        }
        job.setNumReduceTasks(configWrapper.getInt((Enum)OutputParameters.Output.REDUCER_COUNT, 1));
        job.setJobName(this.getJobName());
        job.setJarByClass(this.getClass());
        this.lastCounterSet = counters = this.mapReduceIntegrater.waitForCompletion(job);
        return counters == null ? 1 : 0;
    }

    protected abstract String getJobName();

    public long getCounterValue(Enum<?> counterEnum) {
        return this.lastCounterSet != null ? this.lastCounterSet.findCounter(counterEnum).getValue() : 0L;
    }

    public abstract void configure(Job var1) throws Exception;

    public Collection<ParameterEnum<?>> getParameters() {
        ArrayList params = new ArrayList();
        if (this.inputFormat != null) {
            params.addAll(this.inputFormat.getParameters());
        }
        if (this.outputFormat != null) {
            params.addAll(this.outputFormat.getParameters());
        }
        params.addAll(Arrays.asList(StoreParameters.StoreParam.INPUT_STORE, OutputParameters.Output.REDUCER_COUNT, OutputParameters.Output.OUTPUT_FORMAT));
        return params;
    }

    public int run(PropertyManagement runTimeProperties) throws Exception {
        return this.run(this.mapReduceIntegrater.getConfiguration(runTimeProperties), runTimeProperties);
    }

    protected InternalDataAdapter<?> getAdapter(PropertyManagement runTimeProperties, ParameterEnum dataTypeEnum, ParameterEnum dataNameSpaceEnum) throws Exception {
        String projectionDataTypeId = runTimeProperties.storeIfEmpty(dataTypeEnum, (Serializable)((Object)"convex_hull")).toString();
        PersistentAdapterStore adapterStore = this.getAdapterStore(runTimeProperties);
        InternalAdapterStore internalAdapterStore = this.getInternalAdapterStore(runTimeProperties);
        Short convexHullInternalAdapterId = internalAdapterStore.getAdapterId(projectionDataTypeId);
        if (convexHullInternalAdapterId == null) {
            String namespaceURI = runTimeProperties.storeIfEmpty(dataNameSpaceEnum, (Serializable)((Object)"http://www.opengis.net/gml")).toString();
            FeatureDataAdapter adapter = AnalyticFeature.createGeometryFeatureAdapter((String)projectionDataTypeId, (String[])new String[0], (String)namespaceURI, (String)"EPSG:4326");
            short internalAdapterId = internalAdapterStore.addTypeName(adapter.getTypeName());
            InternalDataAdapter internalAdapter = adapter.asInternalAdapter(internalAdapterId);
            adapterStore.addAdapter((DataTypeAdapter)internalAdapter);
            return internalAdapter;
        }
        return (InternalDataAdapter)adapterStore.getAdapter((Object)convexHullInternalAdapterId);
    }

    protected String checkIndex(PropertyManagement runTimeProperties, ParameterEnum indexIdEnum, String defaultIdxName) throws Exception {
        String indexName = runTimeProperties.getPropertyAsString(indexIdEnum, defaultIdxName);
        IndexStore indexStore = this.getIndexStore(runTimeProperties);
        DataStore dataStore = this.getDataStore(runTimeProperties);
        Index index = indexStore.getIndex(indexName);
        if (index == null) {
            Index defaultSpatialIndex = SpatialDimensionalityTypeProvider.createIndexFromOptions((SpatialOptions)new SpatialOptions());
            index = new CustomNameIndex(defaultSpatialIndex.getIndexStrategy(), defaultSpatialIndex.getIndexModel(), indexName);
            dataStore.addIndex(index);
        }
        return indexName;
    }
}

