/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.param.ExtractParameters;
import org.locationtech.geowave.analytic.param.FormatConfiguration;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.locationtech.geowave.analytic.param.StoreParameters;
import org.locationtech.geowave.analytic.store.PersistableStore;
import org.locationtech.geowave.core.store.adapter.InternalAdapterStore;
import org.locationtech.geowave.core.store.adapter.PersistentAdapterStore;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.api.Query;
import org.locationtech.geowave.core.store.cli.store.DataStorePluginOptions;
import org.locationtech.geowave.core.store.index.IndexStore;
import org.locationtech.geowave.core.store.query.constraints.QueryConstraints;
import org.locationtech.geowave.core.store.query.options.CommonQueryOptions;
import org.locationtech.geowave.core.store.query.options.DataTypeQueryOptions;
import org.locationtech.geowave.core.store.query.options.IndexQueryOptions;
import org.locationtech.geowave.mapreduce.input.GeoWaveInputFormat;

public class GeoWaveInputFormatConfiguration
implements FormatConfiguration {
    protected boolean isDataWritable = false;
    protected List<DataTypeAdapter<?>> adapters = new ArrayList();
    protected List<Index> indices = new ArrayList<Index>();

    public void setup(PropertyManagement runTimeProperties, Configuration configuration) throws Exception {
        int maxInputSplits;
        int minInputSplits;
        DataStorePluginOptions dataStoreOptions = ((PersistableStore)runTimeProperties.getProperty((ParameterEnum)StoreParameters.StoreParam.INPUT_STORE)).getDataStoreOptions();
        GeoWaveInputFormat.setStoreOptions((Configuration)configuration, (DataStorePluginOptions)dataStoreOptions);
        Query query = runTimeProperties.getPropertyAsQuery((ParameterEnum)ExtractParameters.Extract.QUERY);
        if (query != null) {
            if (query.getQueryConstraints() != null) {
                GeoWaveInputFormat.setQueryConstraints((Configuration)configuration, (QueryConstraints)query.getQueryConstraints());
            }
            if (query.getCommonQueryOptions() != null) {
                GeoWaveInputFormat.setCommonQueryOptions((Configuration)configuration, (CommonQueryOptions)query.getCommonQueryOptions());
            }
            if (query.getDataTypeQueryOptions() != null) {
                GeoWaveInputFormat.setDataTypeQueryOptions((Configuration)configuration, (DataTypeQueryOptions)query.getDataTypeQueryOptions(), (PersistentAdapterStore)dataStoreOptions.createAdapterStore(), (InternalAdapterStore)dataStoreOptions.createInternalAdapterStore());
            }
            if (query.getIndexQueryOptions() != null) {
                GeoWaveInputFormat.setIndexQueryOptions((Configuration)configuration, (IndexQueryOptions)query.getIndexQueryOptions(), (IndexStore)dataStoreOptions.createIndexStore());
            }
        }
        if ((minInputSplits = runTimeProperties.getPropertyAsInt((ParameterEnum)ExtractParameters.Extract.MIN_INPUT_SPLIT, -1).intValue()) > 0) {
            GeoWaveInputFormat.setMinimumSplitCount((Configuration)configuration, (Integer)minInputSplits);
        }
        if ((maxInputSplits = runTimeProperties.getPropertyAsInt((ParameterEnum)ExtractParameters.Extract.MAX_INPUT_SPLIT, -1).intValue()) > 0) {
            GeoWaveInputFormat.setMaximumSplitCount((Configuration)configuration, (Integer)maxInputSplits);
        }
        GeoWaveInputFormat.setIsOutputWritable((Configuration)configuration, (Boolean)this.isDataWritable);
    }

    public void addDataAdapter(DataTypeAdapter<?> adapter) {
        this.adapters.add(adapter);
    }

    public void addIndex(Index index) {
        this.indices.add(index);
    }

    public Class<?> getFormatClass() {
        return GeoWaveInputFormat.class;
    }

    public boolean isDataWritable() {
        return this.isDataWritable;
    }

    public void setDataIsWritable(boolean isWritable) {
        this.isDataWritable = isWritable;
    }

    public List<ParameterEnum<?>> getParameters() {
        return Arrays.asList(ExtractParameters.Extract.QUERY, ExtractParameters.Extract.MAX_INPUT_SPLIT, ExtractParameters.Extract.MIN_INPUT_SPLIT, StoreParameters.StoreParam.INPUT_STORE);
    }
}

