/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.param.MapReduceParameters;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.locationtech.geowave.mapreduce.GeoWaveConfiguratorBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopOptions {
    private static final Logger LOGGER = LoggerFactory.getLogger(HadoopOptions.class);
    private final String hdfsHostPort;
    private final Path basePath;
    private final String jobTrackerHostPort;
    private final Configuration config = new Configuration();

    public HadoopOptions(PropertyManagement runTimeProperties) throws IOException {
        String hostport;
        boolean setRemoteInvocation = runTimeProperties.hasProperty((ParameterEnum)MapReduceParameters.MRConfig.HDFS_HOST_PORT) || runTimeProperties.hasProperty((ParameterEnum)MapReduceParameters.MRConfig.JOBTRACKER_HOST_PORT);
        this.hdfsHostPort = hostport = runTimeProperties.getPropertyAsString((ParameterEnum)MapReduceParameters.MRConfig.HDFS_HOST_PORT, "localhost:53000");
        this.basePath = new Path(runTimeProperties.getPropertyAsString((ParameterEnum)MapReduceParameters.MRConfig.HDFS_BASE_DIR), "/");
        this.jobTrackerHostPort = runTimeProperties.getPropertyAsString((ParameterEnum)MapReduceParameters.MRConfig.JOBTRACKER_HOST_PORT, runTimeProperties.getPropertyAsString((ParameterEnum)MapReduceParameters.MRConfig.YARN_RESOURCE_MANAGER));
        String name = runTimeProperties.getPropertyAsString((ParameterEnum)MapReduceParameters.MRConfig.CONFIG_FILE);
        if (name != null) {
            try (FileInputStream in = new FileInputStream(name);){
                this.config.addResource((InputStream)in, name);
            }
            catch (IOException ex) {
                LOGGER.error("Configuration file not found", (Throwable)ex);
                throw ex;
            }
        }
        if (setRemoteInvocation) {
            GeoWaveConfiguratorBase.setRemoteInvocationParams((String)this.hdfsHostPort, (String)this.jobTrackerHostPort, (Configuration)this.config);
        } else {
            LOGGER.info("Assuming local job submission");
        }
        FileSystem fs = FileSystem.get((Configuration)this.config);
        if (!fs.exists(this.basePath)) {
            LOGGER.error("HDFS base directory does not exist");
            return;
        }
    }

    public HadoopOptions(String hdfsHostPort, Path basePath, String jobTrackerHostport) {
        this.hdfsHostPort = hdfsHostPort;
        this.basePath = basePath;
        this.jobTrackerHostPort = jobTrackerHostport;
    }

    public String getHdfsHostPort() {
        return this.hdfsHostPort;
    }

    public Path getBasePath() {
        return this.basePath;
    }

    public String getJobTrackerOrResourceManagerHostPort() {
        return this.jobTrackerHostPort;
    }

    public Configuration getConfiguration() {
        return this.config;
    }
}

