/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.locationtech.geowave.analytic.IndependentJobRunner;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.mapreduce.HadoopOptions;
import org.locationtech.geowave.analytic.mapreduce.MapReduceJobRunner;
import org.locationtech.geowave.analytic.param.MapReduceParameters;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapReduceJobController
implements MapReduceJobRunner,
IndependentJobRunner {
    static final Logger LOGGER = LoggerFactory.getLogger(MapReduceJobController.class);
    private MapReduceJobRunner[] runners;
    private PostOperationTask[] runSetUpTasks;
    public static final PostOperationTask DoNothingTask = new PostOperationTask(){

        @Override
        public void runTask(Configuration config, MapReduceJobRunner runner) {
        }
    };

    protected void init(MapReduceJobRunner[] runners, PostOperationTask[] runSetUpTasks) {
        this.runners = runners;
        this.runSetUpTasks = runSetUpTasks;
    }

    public MapReduceJobRunner[] getRunners() {
        return this.runners;
    }

    @Override
    public int run(Configuration config, PropertyManagement runTimeProperties) throws Exception {
        for (int i = 0; i < this.runners.length; ++i) {
            MapReduceJobRunner runner = this.runners[i];
            LOGGER.info("Running " + runner.getClass().toString());
            int status = runner.run(config, runTimeProperties);
            if (status != 0) {
                return status;
            }
            this.runSetUpTasks[i].runTask(config, runner);
        }
        return 0;
    }

    public Collection<ParameterEnum<?>> getParameters() {
        HashSet params = new HashSet();
        params.addAll(MapReduceParameters.getParameters());
        for (int i = 0; i < this.runners.length; ++i) {
            MapReduceJobRunner runner = this.runners[i];
            if (!(runner instanceof IndependentJobRunner)) continue;
            params.addAll(((IndependentJobRunner)runner).getParameters());
        }
        return params;
    }

    public int run(PropertyManagement runTimeProperties) throws Exception {
        return this.run(MapReduceJobController.getConfiguration(runTimeProperties), runTimeProperties);
    }

    public static Configuration getConfiguration(PropertyManagement pm) throws IOException {
        return new HadoopOptions(pm).getConfiguration();
    }

    public static interface PostOperationTask {
        public void runTask(Configuration var1, MapReduceJobRunner var2);
    }
}

