/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce;

import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.param.FormatConfiguration;
import org.locationtech.geowave.analytic.param.InputParameters;
import org.locationtech.geowave.analytic.param.ParameterEnum;

public class SequenceFileInputFormatConfiguration
implements FormatConfiguration {
    final Path inputPath;

    public SequenceFileInputFormatConfiguration() {
        this.inputPath = null;
    }

    public SequenceFileInputFormatConfiguration(Path inputPath) {
        this.inputPath = inputPath;
    }

    public void setup(PropertyManagement runTimeProperties, Configuration configuration) throws Exception {
        Path localInputPath;
        Path path = localInputPath = this.inputPath == null ? runTimeProperties.getPropertyAsPath((ParameterEnum)InputParameters.Input.HDFS_INPUT_PATH) : this.inputPath;
        if (localInputPath != null) {
            configuration.set("mapred.input.dir", localInputPath.toString());
        }
    }

    public Class<?> getFormatClass() {
        return SequenceFileInputFormat.class;
    }

    public boolean isDataWritable() {
        return true;
    }

    public void setDataIsWritable(boolean isWritable) {
    }

    public Collection<ParameterEnum<?>> getParameters() {
        return Arrays.asList(InputParameters.Input.HDFS_INPUT_PATH);
    }
}

