/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce;

import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.param.FormatConfiguration;
import org.locationtech.geowave.analytic.param.OutputParameters;
import org.locationtech.geowave.analytic.param.ParameterEnum;

public class SequenceFileOutputFormatConfiguration
implements FormatConfiguration {
    final Path outputPath;

    public SequenceFileOutputFormatConfiguration() {
        this.outputPath = null;
    }

    public SequenceFileOutputFormatConfiguration(Path outputPath) {
        this.outputPath = outputPath;
    }

    public void setup(PropertyManagement runTimeProperties, Configuration configuration) throws Exception {
        Path localOutputPath;
        Path path = localOutputPath = this.outputPath == null ? runTimeProperties.getPropertyAsPath((ParameterEnum)OutputParameters.Output.HDFS_OUTPUT_PATH) : this.outputPath;
        if (localOutputPath != null) {
            configuration.set("mapred.output.dir", localOutputPath.toString());
        }
    }

    public Class<?> getFormatClass() {
        return SequenceFileOutputFormat.class;
    }

    public boolean isDataWritable() {
        return true;
    }

    public void setDataIsWritable(boolean isWritable) {
    }

    public Collection<ParameterEnum<?>> getParameters() {
        return Arrays.asList(OutputParameters.Output.HDFS_OUTPUT_PATH);
    }
}

