/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.clustering;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.locationtech.geowave.adapter.vector.FeatureDataAdapter;
import org.locationtech.geowave.analytic.AnalyticFeature;
import org.locationtech.geowave.analytic.AnalyticItemWrapper;
import org.locationtech.geowave.analytic.AnalyticItemWrapperFactory;
import org.locationtech.geowave.analytic.Projection;
import org.locationtech.geowave.analytic.ScopedJobConfiguration;
import org.locationtech.geowave.analytic.SimpleFeatureItemWrapperFactory;
import org.locationtech.geowave.analytic.SimpleFeatureProjection;
import org.locationtech.geowave.analytic.clustering.CentroidManager;
import org.locationtech.geowave.analytic.clustering.CentroidManagerGeoWave;
import org.locationtech.geowave.analytic.clustering.NestedGroupCentroidAssignment;
import org.locationtech.geowave.analytic.param.HullParameters;
import org.locationtech.geowave.core.geotime.index.api.SpatialIndexBuilder;
import org.locationtech.geowave.core.index.ByteArray;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.mapreduce.GeoWaveWritableInputMapper;
import org.locationtech.geowave.mapreduce.GeoWaveWritableInputReducer;
import org.locationtech.geowave.mapreduce.input.GeoWaveInputKey;
import org.locationtech.geowave.mapreduce.output.GeoWaveOutputKey;
import org.locationtech.jts.algorithm.ConvexHull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvexHullMapReduce {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ConvexHullMapReduce.class);

    public static class ConvexHullReducer<T>
    extends GeoWaveWritableInputReducer<GeoWaveOutputKey, SimpleFeature> {
        private CentroidManager<T> centroidManager;
        private String[] indexNames;
        private FeatureDataAdapter outputAdapter;
        private Projection<T> projectionFunction;
        private final int pointCloudThreshold = 50000000;
        private final List<Coordinate> batchCoords = new ArrayList<Coordinate>(10000);

        protected void reduceNativeValues(GeoWaveInputKey key, Iterable<Object> values, Reducer.Context context) throws IOException, InterruptedException {
            int batchThreshold = 10000;
            this.batchCoords.clear();
            Geometry currentHull = null;
            String groupID = StringUtils.stringFromBinary((byte[])key.getDataId().getBytes());
            AnalyticItemWrapper centroid = this.centroidManager.getCentroid(groupID);
            for (Object value : values) {
                currentHull = null;
                Geometry geo = this.projectionFunction.getProjection(value);
                Coordinate[] coords = geo.getCoordinates();
                if (coords.length + this.batchCoords.size() > 50000000) break;
                for (Coordinate coordinate : coords) {
                    this.batchCoords.add(coordinate);
                }
                if (coords.length > batchThreshold) {
                    batchThreshold = coords.length;
                }
                if (this.batchCoords.size() <= batchThreshold) continue;
                currentHull = ConvexHullReducer.compress(key, this.batchCoords);
            }
            Geometry geometry = currentHull = currentHull == null ? ConvexHullReducer.compress(key, this.batchCoords) : currentHull;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(centroid.getGroupID() + " contains " + groupID);
            }
            SimpleFeature newPolygonFeature = AnalyticFeature.createGeometryFeature((SimpleFeatureType)this.outputAdapter.getFeatureType(), (String)centroid.getBatchID(), (String)UUID.randomUUID().toString(), (String)centroid.getName(), (String)centroid.getGroupID(), (double)centroid.getCost(), (Geometry)currentHull, (String[])new String[0], (double[])new double[0], (int)centroid.getZoomLevel(), (int)centroid.getIterationID(), (long)centroid.getAssociationCount());
            context.write((Object)new GeoWaveOutputKey(this.outputAdapter.getTypeName(), this.indexNames), (Object)newPolygonFeature);
        }

        private static <T> Geometry compress(GeoWaveInputKey key, List<Coordinate> batchCoords) {
            Coordinate[] actualCoords = batchCoords.toArray(new Coordinate[batchCoords.size()]);
            ConvexHull convexHull = new ConvexHull(actualCoords, new GeometryFactory());
            Geometry hullGeometry = convexHull.getConvexHull();
            Coordinate[] hullCoords = hullGeometry.getCoordinates();
            batchCoords.clear();
            for (Coordinate hullCoord : hullCoords) {
                batchCoords.add(hullCoord);
            }
            return hullGeometry;
        }

        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            ScopedJobConfiguration config = new ScopedJobConfiguration(context.getConfiguration(), ConvexHullMapReduce.class, LOGGER);
            super.setup(context);
            try {
                this.centroidManager = new CentroidManagerGeoWave((JobContext)context, ConvexHullMapReduce.class, LOGGER);
            }
            catch (Exception e) {
                LOGGER.warn("Unable to initialize centroid manager", (Throwable)e);
                throw new IOException("Unable to initialize centroid manager");
            }
            try {
                this.projectionFunction = (Projection)config.getInstance((Enum)HullParameters.Hull.PROJECTION_CLASS, Projection.class, SimpleFeatureProjection.class);
                this.projectionFunction.initialize((JobContext)context, ConvexHullMapReduce.class);
            }
            catch (Exception e1) {
                throw new IOException(e1);
            }
            String polygonDataTypeId = config.getString((Enum)HullParameters.Hull.DATA_TYPE_ID, "convex_hull");
            this.outputAdapter = AnalyticFeature.createGeometryFeatureAdapter((String)polygonDataTypeId, (String[])new String[0], (String)config.getString((Enum)HullParameters.Hull.DATA_NAMESPACE_URI, "http://www.opengis.net/gml"), (String)"EPSG:4326");
            this.indexNames = new String[]{config.getString((Enum)HullParameters.Hull.INDEX_NAME, new SpatialIndexBuilder().createIndex().getName())};
        }
    }

    public static class ConvexHullMap<T>
    extends GeoWaveWritableInputMapper<GeoWaveInputKey, ObjectWritable> {
        protected GeoWaveInputKey outputKey = new GeoWaveInputKey();
        private ObjectWritable currentValue;
        private AnalyticItemWrapperFactory<T> itemWrapperFactory;
        private NestedGroupCentroidAssignment<T> nestedGroupCentroidAssigner;

        protected void mapWritableValue(GeoWaveInputKey key, ObjectWritable value, Mapper.Context context) throws IOException, InterruptedException {
            this.currentValue = value;
            super.mapWritableValue(key, value, context);
        }

        protected void mapNativeValue(GeoWaveInputKey key, Object value, Mapper.Context context) throws IOException, InterruptedException {
            AnalyticItemWrapper wrapper = this.itemWrapperFactory.create(value);
            this.outputKey.setInternalAdapterId(key.getInternalAdapterId());
            this.outputKey.setDataId(new ByteArray(StringUtils.stringToBinary((String)this.nestedGroupCentroidAssigner.getGroupForLevel(wrapper))));
            this.outputKey.setGeoWaveKey(key.getGeoWaveKey());
            context.write((Object)this.outputKey, (Object)this.currentValue);
        }

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            ScopedJobConfiguration config = new ScopedJobConfiguration(context.getConfiguration(), ConvexHullMapReduce.class, LOGGER);
            try {
                this.itemWrapperFactory = (AnalyticItemWrapperFactory)config.getInstance((Enum)HullParameters.Hull.WRAPPER_FACTORY_CLASS, AnalyticItemWrapperFactory.class, SimpleFeatureItemWrapperFactory.class);
                this.itemWrapperFactory.initialize((JobContext)context, ConvexHullMapReduce.class, LOGGER);
            }
            catch (Exception e1) {
                throw new IOException(e1);
            }
            try {
                this.nestedGroupCentroidAssigner = new NestedGroupCentroidAssignment((JobContext)context, ConvexHullMapReduce.class, LOGGER);
            }
            catch (Exception e1) {
                throw new IOException(e1);
            }
        }
    }
}

