/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.clustering;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.locationtech.geowave.analytic.AnalyticItemWrapperFactory;
import org.locationtech.geowave.analytic.ScopedJobConfiguration;
import org.locationtech.geowave.analytic.SimpleFeatureItemWrapperFactory;
import org.locationtech.geowave.analytic.clustering.CentroidPairing;
import org.locationtech.geowave.analytic.clustering.NestedGroupCentroidAssignment;
import org.locationtech.geowave.analytic.extract.CentroidExtractor;
import org.locationtech.geowave.analytic.extract.SimpleFeatureCentroidExtractor;
import org.locationtech.geowave.analytic.kmeans.AssociationNotification;
import org.locationtech.geowave.analytic.mapreduce.GroupIDText;
import org.locationtech.geowave.analytic.param.CentroidParameters;
import org.locationtech.geowave.mapreduce.GeoWaveWritableInputMapper;
import org.locationtech.geowave.mapreduce.input.GeoWaveInputKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupAssignmentMapReduce {
    protected static final Logger LOGGER = LoggerFactory.getLogger(GroupAssignmentMapReduce.class);

    public static class GroupAssignmentMapper
    extends GeoWaveWritableInputMapper<GeoWaveInputKey, ObjectWritable> {
        private NestedGroupCentroidAssignment<Object> nestedGroupCentroidAssigner;
        protected GroupIDText outputKeyWritable = new GroupIDText();
        protected ObjectWritable outputValWritable = new ObjectWritable();
        protected CentroidExtractor<Object> centroidExtractor;
        protected AnalyticItemWrapperFactory<Object> itemWrapperFactory;
        private final Map<String, AtomicInteger> logCounts = new HashMap<String, AtomicInteger>();

        protected void mapNativeValue(final GeoWaveInputKey key, Object value, Mapper.Context context) throws IOException, InterruptedException {
            AssociationNotification<Object> centroidAssociationFn = new AssociationNotification<Object>(){

                public void notify(CentroidPairing<Object> pairing) {
                    pairing.getPairedItem().setGroupID(pairing.getCentroid().getID());
                    pairing.getPairedItem().setZoomLevel(pairing.getCentroid().getZoomLevel() + 1);
                    outputValWritable.set(this.toWritableValue(key, pairing.getPairedItem().getWrappedItem()).get());
                    AtomicInteger ii = (AtomicInteger)logCounts.get(pairing.getCentroid().getID());
                    if (ii == null) {
                        ii = new AtomicInteger(0);
                        logCounts.put(pairing.getCentroid().getID(), ii);
                    }
                    ii.incrementAndGet();
                }
            };
            this.nestedGroupCentroidAssigner.findCentroidForLevel(this.itemWrapperFactory.create(value), (AssociationNotification)centroidAssociationFn);
            context.write((Object)key, (Object)this.outputValWritable);
        }

        protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            for (Map.Entry<String, AtomicInteger> e : this.logCounts.entrySet()) {
                LOGGER.info(e.getKey() + " = " + e.getValue());
            }
            super.cleanup(context);
        }

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            ScopedJobConfiguration config = new ScopedJobConfiguration(context.getConfiguration(), GroupAssignmentMapReduce.class, LOGGER);
            try {
                this.nestedGroupCentroidAssigner = new NestedGroupCentroidAssignment((JobContext)context, GroupAssignmentMapReduce.class, LOGGER);
            }
            catch (Exception e1) {
                throw new IOException(e1);
            }
            try {
                this.centroidExtractor = (CentroidExtractor)config.getInstance((Enum)CentroidParameters.Centroid.EXTRACTOR_CLASS, CentroidExtractor.class, SimpleFeatureCentroidExtractor.class);
            }
            catch (Exception e1) {
                throw new IOException(e1);
            }
            try {
                this.itemWrapperFactory = (AnalyticItemWrapperFactory)config.getInstance((Enum)CentroidParameters.Centroid.WRAPPER_FACTORY_CLASS, AnalyticItemWrapperFactory.class, SimpleFeatureItemWrapperFactory.class);
                this.itemWrapperFactory.initialize((JobContext)context, GroupAssignmentMapReduce.class, LOGGER);
            }
            catch (Exception e1) {
                throw new IOException(e1);
            }
        }
    }
}

