/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.clustering;

import java.io.IOException;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Reducer;
import org.locationtech.geowave.analytic.ScopedJobConfiguration;
import org.locationtech.geowave.analytic.param.OutputParameters;
import org.locationtech.geowave.core.store.adapter.InternalAdapterStore;
import org.locationtech.geowave.mapreduce.GeoWaveWritableInputReducer;
import org.locationtech.geowave.mapreduce.input.GeoWaveInputKey;
import org.locationtech.geowave.mapreduce.output.GeoWaveOutputFormat;
import org.locationtech.geowave.mapreduce.output.GeoWaveOutputKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputToOutputKeyReducer
extends GeoWaveWritableInputReducer<GeoWaveOutputKey, Object> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(InputToOutputKeyReducer.class);
    private GeoWaveOutputKey outputKey;
    private InternalAdapterStore internalAdapterStore;

    protected void reduceNativeValues(GeoWaveInputKey key, Iterable<Object> values, Reducer.Context context) throws IOException, InterruptedException {
        this.outputKey.setTypeName(this.internalAdapterStore.getTypeName(key.getInternalAdapterId()));
        for (Object value : values) {
            context.write((Object)this.outputKey, value);
        }
    }

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.internalAdapterStore = GeoWaveOutputFormat.getJobContextInternalAdapterStore((JobContext)context);
        ScopedJobConfiguration config = new ScopedJobConfiguration(context.getConfiguration(), InputToOutputKeyReducer.class, LOGGER);
        this.outputKey = new GeoWaveOutputKey("na", new String[]{config.getString((Enum)OutputParameters.Output.INDEX_ID, "na")});
    }
}

