/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.clustering;

import java.io.IOException;
import java.util.Iterator;
import java.util.UUID;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.mapreduce.ReduceContext;
import org.apache.hadoop.mapreduce.Reducer;
import org.locationtech.geowave.adapter.vector.FeatureDataAdapter;
import org.locationtech.geowave.analytic.AnalyticFeature;
import org.locationtech.geowave.analytic.ScopedJobConfiguration;
import org.locationtech.geowave.analytic.extract.DimensionExtractor;
import org.locationtech.geowave.analytic.extract.EmptyDimensionExtractor;
import org.locationtech.geowave.analytic.param.ExtractParameters;
import org.locationtech.geowave.analytic.param.GlobalParameters;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.core.store.metadata.InternalAdapterStoreImpl;
import org.locationtech.geowave.mapreduce.GeoWaveConfiguratorBase;
import org.locationtech.geowave.mapreduce.GeoWaveReducer;
import org.locationtech.geowave.mapreduce.input.GeoWaveInputKey;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFeatureOutputReducer
extends GeoWaveReducer {
    protected DimensionExtractor<Object> dimExtractor;
    protected String outputDataTypeID;
    protected String batchID;
    protected String groupID;
    protected FeatureDataAdapter outputAdapter;
    protected static final Logger LOGGER = LoggerFactory.getLogger(SimpleFeatureOutputReducer.class);

    protected void reduceNativeValues(GeoWaveInputKey key, Iterable<Object> values, ReduceContext<GeoWaveInputKey, ObjectWritable, GeoWaveInputKey, Object> context) throws IOException, InterruptedException {
        Iterator<Object> valIt = values.iterator();
        if (valIt.hasNext()) {
            key.setInternalAdapterId(InternalAdapterStoreImpl.getLazyInitialAdapterId((String)this.outputAdapter.getTypeName()));
            SimpleFeature feature = this.getSimpleFeature(key, valIt.next());
            context.write((Object)key, (Object)feature);
        }
    }

    private SimpleFeature getSimpleFeature(GeoWaveInputKey key, Object entry) {
        Geometry geometry = this.dimExtractor.getGeometry(entry);
        double[] extraDims = this.dimExtractor.getDimensions(entry);
        String inputID = StringUtils.stringFromBinary((byte[])key.getDataId().getBytes());
        SimpleFeature pointFeature = AnalyticFeature.createGeometryFeature((SimpleFeatureType)this.outputAdapter.getFeatureType(), (String)this.batchID, (String)inputID, (String)inputID, (String)this.groupID, (double)0.0, (Geometry)geometry, (String[])this.dimExtractor.getDimensionNames(), (double[])extraDims, (int)1, (int)1, (long)0L);
        return pointFeature;
    }

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        ScopedJobConfiguration config = new ScopedJobConfiguration(context.getConfiguration(), SimpleFeatureOutputReducer.class);
        this.outputDataTypeID = config.getString((Enum)ExtractParameters.Extract.OUTPUT_DATA_TYPE_ID, "reduced_features");
        this.batchID = config.getString((Enum)GlobalParameters.Global.BATCH_ID, UUID.randomUUID().toString());
        this.groupID = config.getString((Enum)ExtractParameters.Extract.GROUP_ID, UUID.randomUUID().toString());
        try {
            this.dimExtractor = (DimensionExtractor)config.getInstance((Enum)ExtractParameters.Extract.DIMENSION_EXTRACT_CLASS, DimensionExtractor.class, EmptyDimensionExtractor.class);
        }
        catch (Exception e1) {
            LOGGER.warn("Failed to instantiate " + GeoWaveConfiguratorBase.enumToConfKey(SimpleFeatureOutputReducer.class, (Enum)ExtractParameters.Extract.DIMENSION_EXTRACT_CLASS), (Throwable)e1);
            throw new IOException("Invalid configuration for " + GeoWaveConfiguratorBase.enumToConfKey(SimpleFeatureOutputReducer.class, (Enum)ExtractParameters.Extract.DIMENSION_EXTRACT_CLASS));
        }
        this.outputAdapter = AnalyticFeature.createGeometryFeatureAdapter((String)this.outputDataTypeID, (String[])this.dimExtractor.getDimensionNames(), (String)config.getString((Enum)ExtractParameters.Extract.DATA_NAMESPACE_URI, "http://www.opengis.net/gml"), (String)"EPSG:4326");
    }
}

