/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.clustering.runner;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.mapreduce.Job;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.SimpleFeatureProjection;
import org.locationtech.geowave.analytic.clustering.CentroidManagerGeoWave;
import org.locationtech.geowave.analytic.clustering.NestedGroupCentroidAssignment;
import org.locationtech.geowave.analytic.mapreduce.GeoWaveAnalyticJobRunner;
import org.locationtech.geowave.analytic.mapreduce.GeoWaveOutputFormatConfiguration;
import org.locationtech.geowave.analytic.mapreduce.clustering.ConvexHullMapReduce;
import org.locationtech.geowave.analytic.param.CentroidParameters;
import org.locationtech.geowave.analytic.param.GlobalParameters;
import org.locationtech.geowave.analytic.param.HullParameters;
import org.locationtech.geowave.analytic.param.MapReduceParameters;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.locationtech.geowave.analytic.param.StoreParameters;
import org.locationtech.geowave.core.geotime.index.SpatialDimensionalityTypeProvider;
import org.locationtech.geowave.core.geotime.index.SpatialOptions;
import org.locationtech.geowave.mapreduce.input.GeoWaveInputKey;
import org.locationtech.geowave.mapreduce.output.GeoWaveOutputKey;

public class ConvexHullJobRunner
extends GeoWaveAnalyticJobRunner {
    private int zoomLevel = 1;

    public ConvexHullJobRunner() {
        super.setOutputFormatConfiguration(new GeoWaveOutputFormatConfiguration());
    }

    public void setZoomLevel(int zoomLevel) {
        this.zoomLevel = zoomLevel;
    }

    @Override
    public void configure(Job job) throws Exception {
        job.setMapperClass(ConvexHullMapReduce.ConvexHullMap.class);
        job.setMapOutputKeyClass(GeoWaveInputKey.class);
        job.setMapOutputValueClass(ObjectWritable.class);
        job.setReducerClass(ConvexHullMapReduce.ConvexHullReducer.class);
        job.setReduceSpeculativeExecution(false);
        job.setOutputKeyClass(GeoWaveOutputKey.class);
        job.setOutputValueClass(Object.class);
    }

    @Override
    public Class<?> getScope() {
        return ConvexHullMapReduce.class;
    }

    @Override
    public int run(Configuration config, PropertyManagement runTimeProperties) throws Exception {
        runTimeProperties.storeIfEmpty((ParameterEnum)HullParameters.Hull.PROJECTION_CLASS, SimpleFeatureProjection.class);
        runTimeProperties.setConfig(new ParameterEnum[]{HullParameters.Hull.WRAPPER_FACTORY_CLASS, HullParameters.Hull.PROJECTION_CLASS, HullParameters.Hull.DATA_TYPE_ID, HullParameters.Hull.INDEX_NAME}, config, this.getScope());
        this.setReducerCount(runTimeProperties.getPropertyAsInt((ParameterEnum)HullParameters.Hull.REDUCER_COUNT, 4));
        CentroidManagerGeoWave.setParameters((Configuration)config, this.getScope(), (PropertyManagement)runTimeProperties);
        NestedGroupCentroidAssignment.setParameters((Configuration)config, this.getScope(), (PropertyManagement)runTimeProperties);
        int localZoomLevel = runTimeProperties.getPropertyAsInt((ParameterEnum)CentroidParameters.Centroid.ZOOM_LEVEL, this.zoomLevel);
        NestedGroupCentroidAssignment.setZoomLevel((Configuration)config, this.getScope(), (int)(localZoomLevel + 1));
        ConvexHullJobRunner.addDataAdapter(config, this.getAdapter(runTimeProperties, (ParameterEnum)HullParameters.Hull.DATA_TYPE_ID, (ParameterEnum)HullParameters.Hull.DATA_NAMESPACE_URI));
        this.checkIndex(runTimeProperties, (ParameterEnum)HullParameters.Hull.INDEX_NAME, SpatialDimensionalityTypeProvider.createIndexFromOptions((SpatialOptions)new SpatialOptions()).getName());
        return super.run(config, runTimeProperties);
    }

    @Override
    public Collection<ParameterEnum<?>> getParameters() {
        HashSet params = new HashSet();
        params.addAll(super.getParameters());
        params.addAll(Arrays.asList(StoreParameters.StoreParam.INPUT_STORE, StoreParameters.StoreParam.OUTPUT_STORE, GlobalParameters.Global.BATCH_ID));
        params.addAll(MapReduceParameters.getParameters());
        params.addAll(NestedGroupCentroidAssignment.getParameters());
        params.addAll(Arrays.asList(HullParameters.Hull.WRAPPER_FACTORY_CLASS, HullParameters.Hull.PROJECTION_CLASS, HullParameters.Hull.REDUCER_COUNT, HullParameters.Hull.DATA_TYPE_ID, HullParameters.Hull.DATA_NAMESPACE_URI, HullParameters.Hull.INDEX_NAME));
        return params;
    }

    @Override
    protected String getJobName() {
        return "Convex Hull";
    }
}

