/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.clustering.runner;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.locationtech.geowave.adapter.vector.FeatureDataAdapter;
import org.locationtech.geowave.analytic.AnalyticFeature;
import org.locationtech.geowave.analytic.IndependentJobRunner;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.ScopedJobConfiguration;
import org.locationtech.geowave.analytic.extract.DimensionExtractor;
import org.locationtech.geowave.analytic.extract.SimpleFeatureGeometryExtractor;
import org.locationtech.geowave.analytic.mapreduce.MapReduceJobController;
import org.locationtech.geowave.analytic.mapreduce.MapReduceJobRunner;
import org.locationtech.geowave.analytic.mapreduce.clustering.SimpleFeatureOutputReducer;
import org.locationtech.geowave.analytic.param.ExtractParameters;
import org.locationtech.geowave.analytic.param.GlobalParameters;
import org.locationtech.geowave.analytic.param.MapReduceParameters;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.locationtech.geowave.analytic.param.StoreParameters;
import org.locationtech.geowave.analytic.store.PersistableStore;
import org.locationtech.geowave.core.store.adapter.InternalAdapterStore;
import org.locationtech.geowave.core.store.adapter.PersistentAdapterStore;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.api.Query;
import org.locationtech.geowave.core.store.cli.store.DataStorePluginOptions;
import org.locationtech.geowave.core.store.index.IndexStore;
import org.locationtech.geowave.core.store.query.constraints.QueryConstraints;
import org.locationtech.geowave.core.store.query.options.CommonQueryOptions;
import org.locationtech.geowave.core.store.query.options.DataTypeQueryOptions;
import org.locationtech.geowave.core.store.query.options.IndexQueryOptions;
import org.locationtech.geowave.mapreduce.GeoWaveConfiguratorBase;
import org.locationtech.geowave.mapreduce.dedupe.GeoWaveDedupeJobRunner;
import org.locationtech.geowave.mapreduce.input.GeoWaveInputFormat;
import org.locationtech.geowave.mapreduce.output.GeoWaveOutputFormat;

public class GeoWaveAnalyticExtractJobRunner
extends GeoWaveDedupeJobRunner
implements MapReduceJobRunner,
IndependentJobRunner {
    private String outputBaseDir = "/tmp";
    private int reducerCount = 1;

    public GeoWaveAnalyticExtractJobRunner() {
        super(null);
    }

    protected int getNumReduceTasks() {
        return this.reducerCount;
    }

    protected String getHdfsOutputBase() {
        return this.outputBaseDir;
    }

    protected void configure(Job job) throws Exception {
        ScopedJobConfiguration configWrapper = new ScopedJobConfiguration(job.getConfiguration(), SimpleFeatureOutputReducer.class);
        this.reducerCount = Math.max(configWrapper.getInt((Enum)ExtractParameters.Extract.REDUCER_COUNT, 8), 1);
        this.outputBaseDir = configWrapper.getString((Enum)MapReduceParameters.MRConfig.HDFS_BASE_DIR, "/tmp");
        LOGGER.info("Output base directory " + this.outputBaseDir);
        super.configure(job);
        Class dimensionExtractorClass = job.getConfiguration().getClass(GeoWaveConfiguratorBase.enumToConfKey(SimpleFeatureOutputReducer.class, (Enum)ExtractParameters.Extract.DIMENSION_EXTRACT_CLASS), SimpleFeatureGeometryExtractor.class, DimensionExtractor.class);
        GeoWaveOutputFormat.addDataAdapter((Configuration)job.getConfiguration(), (DataTypeAdapter)this.createAdapter(job.getConfiguration().get(GeoWaveConfiguratorBase.enumToConfKey(SimpleFeatureOutputReducer.class, (Enum)ExtractParameters.Extract.OUTPUT_DATA_TYPE_ID)), job.getConfiguration().get(GeoWaveConfiguratorBase.enumToConfKey(SimpleFeatureOutputReducer.class, (Enum)ExtractParameters.Extract.DATA_NAMESPACE_URI)), dimensionExtractorClass));
        job.setJobName("GeoWave Extract (" + this.dataStoreOptions.getGeoWaveNamespace() + ")");
        job.setReduceSpeculativeExecution(false);
    }

    private FeatureDataAdapter createAdapter(String outputDataTypeID, String namespaceURI, Class<? extends DimensionExtractor> dimensionExtractorClass) throws InstantiationException, IllegalAccessException {
        DimensionExtractor extractor = dimensionExtractorClass.newInstance();
        return AnalyticFeature.createGeometryFeatureAdapter((String)outputDataTypeID, (String[])extractor.getDimensionNames(), (String)namespaceURI, (String)"EPSG:4326");
    }

    public Path getHdfsOutputPath() {
        return new Path(this.getHdfsOutputBase() + "/" + this.dataStoreOptions.getGeoWaveNamespace() + "_dedupe");
    }

    protected Class<? extends Reducer> getReducer() {
        return SimpleFeatureOutputReducer.class;
    }

    @Override
    public int run(Configuration config, PropertyManagement runTimeProperties) throws Exception {
        runTimeProperties.storeIfEmpty((ParameterEnum)ExtractParameters.Extract.OUTPUT_DATA_TYPE_ID, (Serializable)((Object)"centroid"));
        runTimeProperties.setConfig(new ParameterEnum[]{MapReduceParameters.MRConfig.HDFS_BASE_DIR, ExtractParameters.Extract.REDUCER_COUNT, ExtractParameters.Extract.DATA_NAMESPACE_URI, ExtractParameters.Extract.OUTPUT_DATA_TYPE_ID}, config, SimpleFeatureOutputReducer.class);
        config.set(GeoWaveConfiguratorBase.enumToConfKey(SimpleFeatureOutputReducer.class, (Enum)ExtractParameters.Extract.GROUP_ID), runTimeProperties.getPropertyAsString((ParameterEnum)ExtractParameters.Extract.GROUP_ID, UUID.randomUUID().toString()));
        config.set(GeoWaveConfiguratorBase.enumToConfKey(SimpleFeatureOutputReducer.class, (Enum)GlobalParameters.Global.BATCH_ID), runTimeProperties.getPropertyAsString((ParameterEnum)GlobalParameters.Global.BATCH_ID, UUID.randomUUID().toString()));
        Query query = runTimeProperties.getPropertyAsQuery((ParameterEnum)ExtractParameters.Extract.QUERY);
        this.setMinInputSplits(runTimeProperties.getPropertyAsInt((ParameterEnum)ExtractParameters.Extract.MIN_INPUT_SPLIT, 1));
        this.setMaxInputSplits(runTimeProperties.getPropertyAsInt((ParameterEnum)ExtractParameters.Extract.MAX_INPUT_SPLIT, 10000));
        if (query != null) {
            if (query.getQueryConstraints() != null) {
                GeoWaveInputFormat.setQueryConstraints((Configuration)config, (QueryConstraints)query.getQueryConstraints());
                this.setQueryConstraints(query.getQueryConstraints());
            }
            if (query.getCommonQueryOptions() != null) {
                GeoWaveInputFormat.setCommonQueryOptions((Configuration)config, (CommonQueryOptions)query.getCommonQueryOptions());
                this.setCommonQueryOptions(query.getCommonQueryOptions());
            }
            if (query.getDataTypeQueryOptions() != null) {
                GeoWaveInputFormat.setDataTypeQueryOptions((Configuration)config, (DataTypeQueryOptions)query.getDataTypeQueryOptions(), (PersistentAdapterStore)this.dataStoreOptions.createAdapterStore(), (InternalAdapterStore)this.dataStoreOptions.createInternalAdapterStore());
                this.setDataTypeQueryOptions(query.getDataTypeQueryOptions());
            }
            if (query.getIndexQueryOptions() != null) {
                GeoWaveInputFormat.setIndexQueryOptions((Configuration)config, (IndexQueryOptions)query.getIndexQueryOptions(), (IndexStore)this.dataStoreOptions.createIndexStore());
                this.setIndexQueryOptions(query.getIndexQueryOptions());
            }
        }
        if (this.minInputSplits != null) {
            GeoWaveInputFormat.setMinimumSplitCount((Configuration)config, (Integer)this.minInputSplits);
        }
        if (this.maxInputSplits != null) {
            GeoWaveInputFormat.setMaximumSplitCount((Configuration)config, (Integer)this.maxInputSplits);
        }
        this.setConf(config);
        config.setClass(GeoWaveConfiguratorBase.enumToConfKey(SimpleFeatureOutputReducer.class, (Enum)ExtractParameters.Extract.DIMENSION_EXTRACT_CLASS), runTimeProperties.getPropertyAsClass((ParameterEnum)ExtractParameters.Extract.DIMENSION_EXTRACT_CLASS, DimensionExtractor.class, SimpleFeatureGeometryExtractor.class), DimensionExtractor.class);
        PersistableStore store = (PersistableStore)runTimeProperties.getProperty((ParameterEnum)StoreParameters.StoreParam.INPUT_STORE);
        this.dataStoreOptions = store.getDataStoreOptions();
        GeoWaveInputFormat.setStoreOptions((Configuration)config, (DataStorePluginOptions)this.dataStoreOptions);
        GeoWaveOutputFormat.setStoreOptions((Configuration)config, (DataStorePluginOptions)this.dataStoreOptions);
        try (FileSystem fs = FileSystem.get((Configuration)config);){
            if (fs.exists(this.getHdfsOutputPath())) {
                fs.delete(this.getHdfsOutputPath(), true);
            }
            int n = ToolRunner.run((Configuration)config, (Tool)this, (String[])new String[0]);
            return n;
        }
    }

    public Collection<ParameterEnum<?>> getParameters() {
        HashSet params = new HashSet();
        params.addAll(Arrays.asList(ExtractParameters.Extract.REDUCER_COUNT, ExtractParameters.Extract.OUTPUT_DATA_TYPE_ID, ExtractParameters.Extract.DATA_NAMESPACE_URI, ExtractParameters.Extract.DIMENSION_EXTRACT_CLASS, ExtractParameters.Extract.MIN_INPUT_SPLIT, ExtractParameters.Extract.MAX_INPUT_SPLIT, ExtractParameters.Extract.QUERY, StoreParameters.StoreParam.INPUT_STORE, GlobalParameters.Global.BATCH_ID));
        params.addAll(MapReduceParameters.getParameters());
        return params;
    }

    public int run(PropertyManagement runTimeProperties) throws Exception {
        return this.run(MapReduceJobController.getConfiguration(runTimeProperties), runTimeProperties);
    }

    public boolean runOperation(String[] args) throws ParseException {
        try {
            Job job = new Job(super.getConf());
            job.setJarByClass(this.getClass());
            this.configure(job);
            return job.waitForCompletion(true);
        }
        catch (Exception e) {
            LOGGER.error("Unable to run job", (Throwable)e);
            throw new ParseException(e.getMessage());
        }
    }
}

