/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.clustering.runner;

import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.locationtech.geowave.analytic.IndependentJobRunner;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.mapreduce.GeoWaveAnalyticJobRunner;
import org.locationtech.geowave.analytic.mapreduce.GeoWaveInputFormatConfiguration;
import org.locationtech.geowave.analytic.mapreduce.MapReduceJobRunner;
import org.locationtech.geowave.analytic.mapreduce.SequenceFileOutputFormatConfiguration;
import org.locationtech.geowave.analytic.mapreduce.clustering.InputToOutputKeyReducer;
import org.locationtech.geowave.analytic.param.CentroidParameters;
import org.locationtech.geowave.analytic.param.MapReduceParameters;
import org.locationtech.geowave.analytic.param.OutputParameters;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.locationtech.geowave.core.geotime.index.SpatialDimensionalityTypeProvider;
import org.locationtech.geowave.core.geotime.index.SpatialOptions;
import org.locationtech.geowave.mapreduce.input.GeoWaveInputKey;
import org.locationtech.geowave.mapreduce.output.GeoWaveOutputKey;

public class GeoWaveInputLoadJobRunner
extends GeoWaveAnalyticJobRunner
implements MapReduceJobRunner,
IndependentJobRunner {
    public GeoWaveInputLoadJobRunner() {
        super.setInputFormatConfiguration(new GeoWaveInputFormatConfiguration());
        super.setOutputFormatConfiguration(new SequenceFileOutputFormatConfiguration());
    }

    @Override
    public void configure(Job job) throws Exception {
        job.setMapperClass(Mapper.class);
        job.setReducerClass(InputToOutputKeyReducer.class);
        job.setMapOutputKeyClass(GeoWaveInputKey.class);
        job.setMapOutputValueClass(ObjectWritable.class);
        job.setOutputKeyClass(GeoWaveOutputKey.class);
        job.setOutputValueClass(Object.class);
        job.setSpeculativeExecution(false);
        job.setJobName("GeoWave Input to Output");
        job.setReduceSpeculativeExecution(false);
    }

    @Override
    public Class<?> getScope() {
        return InputToOutputKeyReducer.class;
    }

    @Override
    public int run(Configuration config, PropertyManagement runTimeProperties) throws Exception {
        String indexId = this.checkIndex(runTimeProperties, (ParameterEnum)OutputParameters.Output.INDEX_ID, runTimeProperties.getPropertyAsString((ParameterEnum)CentroidParameters.Centroid.INDEX_NAME, SpatialDimensionalityTypeProvider.createIndexFromOptions((SpatialOptions)new SpatialOptions()).getName()));
        OutputParameters.Output.INDEX_ID.getHelper().setValue(config, this.getScope(), (Object)indexId);
        GeoWaveInputLoadJobRunner.addDataAdapter(config, this.getAdapter(runTimeProperties, (ParameterEnum)OutputParameters.Output.DATA_TYPE_ID, (ParameterEnum)OutputParameters.Output.DATA_NAMESPACE_URI));
        runTimeProperties.setConfig(new ParameterEnum[]{OutputParameters.Output.DATA_TYPE_ID, OutputParameters.Output.DATA_NAMESPACE_URI, OutputParameters.Output.INDEX_ID}, config, this.getScope());
        return super.run(config, runTimeProperties);
    }

    @Override
    public Collection<ParameterEnum<?>> getParameters() {
        Collection<ParameterEnum<?>> params = super.getParameters();
        params.addAll(Arrays.asList(OutputParameters.Output.INDEX_ID, OutputParameters.Output.DATA_TYPE_ID, OutputParameters.Output.DATA_NAMESPACE_URI));
        params.addAll(MapReduceParameters.getParameters());
        return params;
    }

    @Override
    protected String getJobName() {
        return "Input Load";
    }
}

