/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.clustering.runner;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Reducer;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.clustering.CentroidManagerGeoWave;
import org.locationtech.geowave.analytic.clustering.NestedGroupCentroidAssignment;
import org.locationtech.geowave.analytic.mapreduce.GeoWaveAnalyticJobRunner;
import org.locationtech.geowave.analytic.mapreduce.clustering.GroupAssignmentMapReduce;
import org.locationtech.geowave.analytic.param.CentroidParameters;
import org.locationtech.geowave.analytic.param.GlobalParameters;
import org.locationtech.geowave.analytic.param.MapReduceParameters;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.locationtech.geowave.analytic.param.StoreParameters;
import org.locationtech.geowave.analytic.store.PersistableStore;
import org.locationtech.geowave.core.store.cli.store.DataStorePluginOptions;
import org.locationtech.geowave.mapreduce.input.GeoWaveInputFormat;
import org.locationtech.geowave.mapreduce.input.GeoWaveInputKey;

public class GroupAssigmentJobRunner
extends GeoWaveAnalyticJobRunner {
    private int zoomLevel = 1;

    public GroupAssigmentJobRunner() {
        super.setReducerCount(8);
    }

    public void setZoomLevel(int zoomLevel) {
        this.zoomLevel = zoomLevel;
    }

    @Override
    public void configure(Job job) throws Exception {
        job.setMapperClass(GroupAssignmentMapReduce.GroupAssignmentMapper.class);
        job.setMapOutputKeyClass(GeoWaveInputKey.class);
        job.setMapOutputValueClass(ObjectWritable.class);
        job.setReducerClass(Reducer.class);
        job.setOutputKeyClass(GeoWaveInputKey.class);
        job.setOutputValueClass(ObjectWritable.class);
    }

    @Override
    public Class<?> getScope() {
        return GroupAssignmentMapReduce.class;
    }

    @Override
    public int run(Configuration config, PropertyManagement runTimeProperties) throws Exception {
        DataStorePluginOptions dataStoreOptions = ((PersistableStore)runTimeProperties.getProperty((ParameterEnum)StoreParameters.StoreParam.INPUT_STORE)).getDataStoreOptions();
        GeoWaveInputFormat.setStoreOptions((Configuration)config, (DataStorePluginOptions)dataStoreOptions);
        runTimeProperties.setConfig(new ParameterEnum[]{CentroidParameters.Centroid.EXTRACTOR_CLASS, CentroidParameters.Centroid.WRAPPER_FACTORY_CLASS}, config, GroupAssignmentMapReduce.class);
        NestedGroupCentroidAssignment.setParameters((Configuration)config, this.getScope(), (PropertyManagement)runTimeProperties);
        CentroidManagerGeoWave.setParameters((Configuration)config, this.getScope(), (PropertyManagement)runTimeProperties);
        NestedGroupCentroidAssignment.setZoomLevel((Configuration)config, this.getScope(), (int)this.zoomLevel);
        return super.run(config, runTimeProperties);
    }

    @Override
    public Collection<ParameterEnum<?>> getParameters() {
        HashSet params = new HashSet();
        params.addAll(super.getParameters());
        params.addAll(Arrays.asList(StoreParameters.StoreParam.INPUT_STORE, GlobalParameters.Global.BATCH_ID));
        params.addAll(CentroidManagerGeoWave.getParameters());
        params.addAll(MapReduceParameters.getParameters());
        params.addAll(NestedGroupCentroidAssignment.getParameters());
        return params;
    }

    @Override
    protected String getJobName() {
        return "Group Assignment";
    }
}

