/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.clustering.runner;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.extract.SimpleFeatureCentroidExtractor;
import org.locationtech.geowave.analytic.extract.SimpleFeatureGeometryExtractor;
import org.locationtech.geowave.analytic.mapreduce.MapReduceJobController;
import org.locationtech.geowave.analytic.mapreduce.MapReduceJobRunner;
import org.locationtech.geowave.analytic.mapreduce.SequenceFileInputFormatConfiguration;
import org.locationtech.geowave.analytic.mapreduce.SequenceFileOutputFormatConfiguration;
import org.locationtech.geowave.analytic.mapreduce.clustering.runner.ClusteringRunner;
import org.locationtech.geowave.analytic.mapreduce.clustering.runner.ConvexHullJobRunner;
import org.locationtech.geowave.analytic.mapreduce.clustering.runner.GeoWaveAnalyticExtractJobRunner;
import org.locationtech.geowave.analytic.mapreduce.clustering.runner.GroupAssigmentJobRunner;
import org.locationtech.geowave.analytic.param.CentroidParameters;
import org.locationtech.geowave.analytic.param.ClusteringParameters;
import org.locationtech.geowave.analytic.param.CommonParameters;
import org.locationtech.geowave.analytic.param.ExtractParameters;
import org.locationtech.geowave.analytic.param.GlobalParameters;
import org.locationtech.geowave.analytic.param.HullParameters;
import org.locationtech.geowave.analytic.param.MapReduceParameters;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.locationtech.geowave.core.geotime.index.SpatialDimensionalityTypeProvider;
import org.locationtech.geowave.core.geotime.index.SpatialOptions;

public abstract class MultiLevelClusteringJobRunner
extends MapReduceJobController
implements MapReduceJobRunner {
    final GroupAssigmentJobRunner groupAssignmentRunner = new GroupAssigmentJobRunner();
    final GeoWaveAnalyticExtractJobRunner jobExtractRunner = new GeoWaveAnalyticExtractJobRunner();
    final ConvexHullJobRunner hullRunner = new ConvexHullJobRunner();

    public MultiLevelClusteringJobRunner() {
        this.init(new MapReduceJobRunner[0], new MapReduceJobController.PostOperationTask[0]);
    }

    protected abstract ClusteringRunner getClusteringRunner();

    @Override
    public Collection<ParameterEnum<?>> getParameters() {
        HashSet params = new HashSet();
        params.addAll(this.jobExtractRunner.getParameters());
        params.addAll(this.hullRunner.getParameters());
        params.addAll(this.getClusteringRunner().getParameters());
        params.addAll(Arrays.asList(ClusteringParameters.Clustering.ZOOM_LEVELS, GlobalParameters.Global.BATCH_ID));
        params.addAll(MapReduceParameters.getParameters());
        params.remove(CentroidParameters.Centroid.DATA_TYPE_ID);
        params.remove(CentroidParameters.Centroid.DATA_NAMESPACE_URI);
        return params;
    }

    @Override
    public int run(Configuration configuration, PropertyManagement propertyManagement) throws Exception {
        return this.runJob(configuration, propertyManagement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runJob(Configuration config, PropertyManagement propertyManagement) throws Exception {
        ClusteringRunner clusteringRunner = this.getClusteringRunner();
        Integer zoomLevels = propertyManagement.getPropertyAsInt((ParameterEnum)ClusteringParameters.Clustering.ZOOM_LEVELS, 1);
        this.jobExtractRunner.setConf(config);
        String dataTypeId = propertyManagement.getPropertyAsString((ParameterEnum)ExtractParameters.Extract.OUTPUT_DATA_TYPE_ID, "centroid");
        String namespaceURI = propertyManagement.getPropertyAsString((ParameterEnum)ExtractParameters.Extract.DATA_NAMESPACE_URI, "http://www.opengis.net/gml");
        propertyManagement.storeIfEmpty((ParameterEnum)ExtractParameters.Extract.DATA_NAMESPACE_URI, (Serializable)((Object)namespaceURI));
        propertyManagement.storeIfEmpty((ParameterEnum)ExtractParameters.Extract.OUTPUT_DATA_TYPE_ID, (Serializable)((Object)dataTypeId));
        propertyManagement.storeIfEmpty((ParameterEnum)CentroidParameters.Centroid.EXTRACTOR_CLASS, SimpleFeatureCentroidExtractor.class);
        propertyManagement.storeIfEmpty((ParameterEnum)CommonParameters.Common.DIMENSION_EXTRACT_CLASS, SimpleFeatureGeometryExtractor.class);
        propertyManagement.store((ParameterEnum)CentroidParameters.Centroid.DATA_TYPE_ID, (Object)dataTypeId);
        propertyManagement.store((ParameterEnum)CentroidParameters.Centroid.DATA_NAMESPACE_URI, (Object)namespaceURI);
        propertyManagement.storeIfEmpty((ParameterEnum)CentroidParameters.Centroid.INDEX_NAME, (Serializable)((Object)SpatialDimensionalityTypeProvider.createIndexFromOptions((SpatialOptions)new SpatialOptions()).getName()));
        propertyManagement.storeIfEmpty((ParameterEnum)HullParameters.Hull.INDEX_NAME, (Serializable)((Object)SpatialDimensionalityTypeProvider.createIndexFromOptions((SpatialOptions)new SpatialOptions()).getName()));
        int status = this.jobExtractRunner.run(config, propertyManagement);
        Path extractPath = this.jobExtractRunner.getHdfsOutputPath();
        this.groupAssignmentRunner.setInputFormatConfiguration(new SequenceFileInputFormatConfiguration(extractPath));
        clusteringRunner.setInputFormatConfiguration(new SequenceFileInputFormatConfiguration(extractPath));
        this.hullRunner.setInputFormatConfiguration(new SequenceFileInputFormatConfiguration(extractPath));
        boolean retainGroupAssigments = propertyManagement.getPropertyAsBoolean((ParameterEnum)ClusteringParameters.Clustering.RETAIN_GROUP_ASSIGNMENTS, Boolean.valueOf(false));
        String outputBaseDir = propertyManagement.getPropertyAsString((ParameterEnum)MapReduceParameters.MRConfig.HDFS_BASE_DIR, "/tmp");
        try (FileSystem fs = null;){
            fs = FileSystem.get((Configuration)config);
            for (int i = 0; status == 0 && i < zoomLevels; ++i) {
                int zoomLevel = i + 1;
                clusteringRunner.setZoomLevel(zoomLevel);
                this.hullRunner.setZoomLevel(zoomLevel);
                propertyManagement.store((ParameterEnum)CentroidParameters.Centroid.ZOOM_LEVEL, (Object)zoomLevel);
                status = clusteringRunner.run(config, propertyManagement);
                if (status != 0) continue;
                Path nextPath = new Path(outputBaseDir + "/level_" + zoomLevel);
                if (fs.exists(nextPath)) {
                    fs.delete(nextPath, true);
                }
                this.groupAssignmentRunner.setOutputFormatConfiguration(new SequenceFileOutputFormatConfiguration(nextPath));
                this.groupAssignmentRunner.setZoomLevel(zoomLevel);
                int n = status = retainGroupAssigments ? this.groupAssignmentRunner.run(config, propertyManagement) : 0;
                if (status == 0) {
                    status = this.hullRunner.run(config, propertyManagement);
                }
                if (!retainGroupAssigments) continue;
                clusteringRunner.setInputFormatConfiguration(new SequenceFileInputFormatConfiguration(nextPath));
                this.hullRunner.setInputFormatConfiguration(new SequenceFileInputFormatConfiguration(nextPath));
                this.groupAssignmentRunner.setInputFormatConfiguration(new SequenceFileInputFormatConfiguration(nextPath));
            }
            int n = status;
            return n;
        }
    }
}

