/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.dbscan;

import org.locationtech.geowave.analytic.distance.CoordinateCircleDistanceFn;
import org.locationtech.geowave.analytic.distance.DistanceFn;
import org.locationtech.geowave.analytic.mapreduce.dbscan.ClusterItem;
import org.locationtech.geowave.analytic.nn.DistanceProfile;
import org.locationtech.geowave.analytic.nn.DistanceProfileGenerateFn;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.operation.distance.DistanceOp;

public class ClusterItemDistanceFn
implements DistanceFn<ClusterItem>,
DistanceProfileGenerateFn<ClusterProfileContext, ClusterItem> {
    private static final long serialVersionUID = 3824608959408031752L;
    private DistanceFn<Coordinate> coordinateDistanceFunction = new CoordinateCircleDistanceFn();
    private static final ThreadLocal<DistanceProfile<ClusterProfileContext>> profile = new ThreadLocal<DistanceProfile<ClusterProfileContext>>(){

        @Override
        protected DistanceProfile<ClusterProfileContext> initialValue() {
            return new DistanceProfile(0.0, (Object)new ClusterProfileContext());
        }
    };

    public ClusterItemDistanceFn() {
    }

    public ClusterItemDistanceFn(DistanceFn<Coordinate> coordinateDistanceFunction) {
        this.coordinateDistanceFunction = coordinateDistanceFunction;
    }

    public DistanceFn<Coordinate> getCoordinateDistanceFunction() {
        return this.coordinateDistanceFunction;
    }

    public void setCoordinateDistanceFunction(DistanceFn<Coordinate> coordinateDistanceFunction) {
        this.coordinateDistanceFunction = coordinateDistanceFunction;
    }

    public double measure(ClusterItem x, ClusterItem y) {
        Geometry gx = x.getGeometry();
        Geometry gy = y.getGeometry();
        if (gx instanceof Point && gy instanceof Point) {
            return this.coordinateDistanceFunction.measure((Object)gx.getCoordinate(), (Object)gy.getCoordinate());
        }
        DistanceOp op = new DistanceOp(gx, gy);
        Coordinate[] points = op.nearestPoints();
        return this.coordinateDistanceFunction.measure((Object)points[0], (Object)points[1]);
    }

    public DistanceProfile<ClusterProfileContext> computeProfile(ClusterItem item1, ClusterItem item2) {
        DistanceProfile<ClusterProfileContext> localProfile = profile.get();
        ClusterProfileContext context = (ClusterProfileContext)localProfile.getContext();
        Geometry gx = item1.getGeometry();
        Geometry gy = item2.getGeometry();
        context.setItem1(item1);
        context.setItem2(item2);
        if (gx instanceof Point && gy instanceof Point) {
            context.setPoint1(gx.getCoordinate());
            context.setPoint2(gy.getCoordinate());
        } else {
            DistanceOp op = new DistanceOp(gx, gy);
            Coordinate[] points = op.nearestPoints();
            context.setPoint1(points[0]);
            context.setPoint2(points[1]);
        }
        localProfile.setDistance(this.coordinateDistanceFunction.measure((Object)context.getPoint1(), (Object)context.getPoint2()));
        return localProfile;
    }

    public static class ClusterProfileContext {
        private Coordinate point1;
        private ClusterItem item1;
        private Coordinate point2;
        private ClusterItem item2;

        public Coordinate getPoint1() {
            return this.point1;
        }

        public void setPoint1(Coordinate point1) {
            this.point1 = point1;
        }

        public ClusterItem getItem1() {
            return this.item1;
        }

        public void setItem1(ClusterItem item1) {
            this.item1 = item1;
        }

        public Coordinate getPoint2() {
            return this.point2;
        }

        public void setPoint2(Coordinate point2) {
            this.point2 = point2;
        }

        public ClusterItem getItem2() {
            return this.item2;
        }

        public void setItem2(ClusterItem item2) {
            this.item2 = item2;
        }
    }
}

