/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.dbscan;

import java.util.Iterator;
import java.util.Map;
import org.locationtech.geowave.analytic.mapreduce.dbscan.Cluster;
import org.locationtech.geowave.analytic.mapreduce.dbscan.ClusterItem;
import org.locationtech.geowave.analytic.nn.DistanceProfile;
import org.locationtech.geowave.analytic.nn.NeighborList;
import org.locationtech.geowave.analytic.nn.NeighborListFactory;
import org.locationtech.geowave.core.index.ByteArray;

public class ClusterNeighborList
implements NeighborList<ClusterItem> {
    private final ByteArray id;
    final Map<ByteArray, Cluster> index;
    final NeighborListFactory<ClusterItem> factory;

    public ClusterNeighborList(ByteArray centerId, ClusterItem center, NeighborListFactory<ClusterItem> factory, Map<ByteArray, Cluster> index) {
        this.index = index;
        this.id = centerId;
        this.factory = factory;
        Cluster cluster = this.getCluster();
        if (cluster == null) {
            cluster = (Cluster)factory.buildNeighborList(this.id, (Object)center);
            index.put(this.id, cluster);
        }
    }

    public Cluster getCluster() {
        return this.index.get(this.id);
    }

    public Iterator<Map.Entry<ByteArray, ClusterItem>> iterator() {
        return this.getCluster().iterator();
    }

    public boolean add(DistanceProfile<?> distanceProfile, ByteArray id, ClusterItem value) {
        Cluster cluster = this.index.get(id);
        if (cluster == null) {
            cluster = (Cluster)this.factory.buildNeighborList(id, (Object)value);
            this.index.put(id, cluster);
        }
        return this.getCluster().add(distanceProfile, id, value);
    }

    public NeighborList.InferType infer(ByteArray id, ClusterItem value) {
        return this.getCluster().infer(id, value);
    }

    public void clear() {
        this.getCluster().clear();
    }

    public int size() {
        return this.getCluster().size();
    }

    public boolean isEmpty() {
        return this.getCluster().isEmpty();
    }

    public static class ClusterNeighborListFactory
    implements NeighborListFactory<ClusterItem> {
        final Map<ByteArray, Cluster> index;
        final NeighborListFactory<ClusterItem> factory;

        public ClusterNeighborListFactory(NeighborListFactory<ClusterItem> factory, Map<ByteArray, Cluster> index) {
            this.index = index;
            this.factory = factory;
        }

        public Map<ByteArray, Cluster> getIndex() {
            return this.index;
        }

        public NeighborList<ClusterItem> buildNeighborList(ByteArray centerId, ClusterItem center) {
            return new ClusterNeighborList(centerId, center, this.factory, this.index);
        }
    }
}

