/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.dbscan;

import java.util.Map;
import org.locationtech.geowave.analytic.mapreduce.dbscan.Cluster;
import org.locationtech.geowave.analytic.mapreduce.dbscan.ClusterItem;
import org.locationtech.geowave.analytic.mapreduce.dbscan.DBScanClusterList;
import org.locationtech.geowave.analytic.nn.DistanceProfile;
import org.locationtech.geowave.analytic.nn.NeighborList;
import org.locationtech.geowave.analytic.nn.NeighborListFactory;
import org.locationtech.geowave.core.index.ByteArray;
import org.locationtech.jts.geom.Geometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterUnionList
extends DBScanClusterList
implements Cluster {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ClusterUnionList.class);

    public ClusterUnionList(ByteArray centerId, ClusterItem center, NeighborListFactory<ClusterItem> factory, Map<ByteArray, Cluster> index) {
        super(center.getGeometry(), (int)center.getCount(), centerId, index);
    }

    @Override
    protected long addAndFetchCount(ByteArray id, ClusterItem newInstance, DistanceProfile<?> distanceProfile) {
        return 0L;
    }

    @Override
    public void merge(Cluster cluster) {
        super.merge(cluster);
        if (cluster != this) {
            this.union(((DBScanClusterList)cluster).clusterGeo);
        }
    }

    @Override
    public boolean isCompressed() {
        return true;
    }

    @Override
    protected Geometry compress() {
        return this.clusterGeo;
    }

    public static class ClusterUnionListFactory
    implements NeighborListFactory<ClusterItem> {
        private final Map<ByteArray, Cluster> index;

        public ClusterUnionListFactory(Map<ByteArray, Cluster> index) {
            this.index = index;
        }

        public NeighborList<ClusterItem> buildNeighborList(ByteArray centerId, ClusterItem center) {
            Cluster list = this.index.get(centerId);
            if (list == null) {
                list = new ClusterUnionList(centerId, center, this, this.index);
            }
            return list;
        }
    }
}

