/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.dbscan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.locationtech.geowave.analytic.GeometryHullTool;
import org.locationtech.geowave.analytic.mapreduce.dbscan.Cluster;
import org.locationtech.geowave.analytic.mapreduce.dbscan.ClusterItem;
import org.locationtech.geowave.analytic.nn.DistanceProfile;
import org.locationtech.geowave.analytic.nn.NeighborList;
import org.locationtech.geowave.core.index.ByteArray;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.TopologyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DBScanClusterList
implements Cluster {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DBScanClusterList.class);
    protected Geometry clusterGeo = null;
    protected int itemCount = 1;
    private Set<ByteArray> linkedClusters = null;
    private List<ByteArray> ids = null;
    private final ByteArray id;
    private static GeometryHullTool connectGeometryTool = new GeometryHullTool();
    private static int mergeSize = 0;
    protected final Map<ByteArray, Cluster> index;

    public static GeometryHullTool getHullTool() {
        return connectGeometryTool;
    }

    public static void setMergeSize(int size) {
        mergeSize = size;
    }

    public DBScanClusterList(Geometry clusterGeo, int itemCount, ByteArray centerId, Map<ByteArray, Cluster> index) {
        this.clusterGeo = clusterGeo;
        this.itemCount = itemCount;
        this.index = index;
        this.id = centerId;
    }

    protected abstract long addAndFetchCount(ByteArray var1, ClusterItem var2, DistanceProfile<?> var3);

    public final boolean add(DistanceProfile<?> distanceProfile, ByteArray newId, ClusterItem newInstance) {
        LOGGER.trace("link {} to {}", (Object)newId, (Object)this.id);
        if (!this.getLinkedClusters(true).add(newId)) {
            return false;
        }
        Cluster cluster = this.index.get(newId);
        if (cluster == this) {
            return false;
        }
        this.incrementItemCount(this.addAndFetchCount(newId, newInstance, distanceProfile));
        return true;
    }

    protected List<ByteArray> getIds(boolean allowUpdates) {
        if (this.ids == null || this.ids == Collections.emptyList()) {
            this.ids = allowUpdates ? new ArrayList(4) : Collections.emptyList();
        }
        return this.ids;
    }

    protected Set<ByteArray> getLinkedClusters(boolean allowUpdates) {
        if (this.linkedClusters == null || this.linkedClusters == Collections.emptySet()) {
            this.linkedClusters = allowUpdates ? new HashSet() : Collections.emptySet();
        }
        return this.linkedClusters;
    }

    protected void incrementItemCount(long amount) {
        int c = this.itemCount;
        this.itemCount = (int)((long)this.itemCount + amount);
        assert (c <= this.itemCount);
    }

    public void clear() {
        this.linkedClusters = null;
        this.clusterGeo = null;
    }

    @Override
    public void invalidate() {
        for (ByteArray linkedId : this.getLinkedClusters(true)) {
            Cluster linkedCluster = this.index.get(linkedId);
            if (linkedCluster == null || linkedCluster == this || !(linkedCluster instanceof DBScanClusterList)) continue;
            ((DBScanClusterList)linkedCluster).getLinkedClusters(false).remove(this.id);
        }
        LOGGER.trace("Invalidate " + this.id);
        this.index.remove(this.id);
        this.linkedClusters = null;
        this.clusterGeo = null;
        this.itemCount = -1;
    }

    public NeighborList.InferType infer(ByteArray id, ClusterItem value) {
        Cluster cluster = this.index.get(id);
        if (cluster == this || this.getLinkedClusters(false).contains(id)) {
            return NeighborList.InferType.SKIP;
        }
        return NeighborList.InferType.NONE;
    }

    public Iterator<Map.Entry<ByteArray, ClusterItem>> iterator() {
        return Collections.emptyList().iterator();
    }

    @Override
    public int currentLinkSetSize() {
        return this.getLinkedClusters(false).size();
    }

    @Override
    public void finish() {
        this.mergeLinks(true);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DBScanClusterList other = (DBScanClusterList)obj;
        return !(this.id == null ? other.id != null : !this.id.equals((Object)other.id));
    }

    public int size() {
        return this.itemCount;
    }

    public boolean isEmpty() {
        return this.size() <= 0;
    }

    @Override
    public Geometry getGeometry() {
        return this.compress();
    }

    @Override
    public abstract boolean isCompressed();

    @Override
    public void merge(Cluster cluster) {
        boolean removedLinked = this.getLinkedClusters(true).remove(cluster.getId());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Merging {} into {}", (Object)cluster.getId(), (Object)this.id);
        }
        if (cluster != this) {
            this.getIds(true).add(cluster.getId());
            this.index.put(cluster.getId(), this);
            if (cluster instanceof DBScanClusterList) {
                for (ByteArray id : ((DBScanClusterList)cluster).getIds(false)) {
                    this.index.put(id, this);
                    this.ids.add(id);
                }
                this.getLinkedClusters(true).addAll(((DBScanClusterList)cluster).getLinkedClusters(false));
            }
            if (this.isCompressed() && ((DBScanClusterList)cluster).isCompressed()) {
                this.incrementItemCount((long)(this.interpolateFactor(((DBScanClusterList)cluster).clusterGeo) * (double)((DBScanClusterList)cluster).itemCount));
            } else if (!removedLinked) {
                this.incrementItemCount(1L);
            }
        }
    }

    protected double interpolateFactor(Geometry areaBeingMerged) {
        try {
            if (this.clusterGeo == null) {
                return 1.0;
            }
            Geometry intersection = areaBeingMerged.intersection(this.clusterGeo);
            double geo2Area = areaBeingMerged.getArea();
            if (intersection != null) {
                if (intersection instanceof Point && areaBeingMerged instanceof Point) {
                    return 0.0;
                }
                if (intersection.isEmpty()) {
                    return 1.0;
                }
                if (geo2Area > 0.0) {
                    return 1.0 - intersection.getArea() / geo2Area;
                }
                return 0.0;
            }
            return 1.0;
        }
        catch (Exception ex) {
            LOGGER.warn("Cannot calculate difference of geometries to interpolate size ", (Throwable)ex);
            return 0.0;
        }
    }

    @Override
    public ByteArray getId() {
        return this.id;
    }

    protected abstract Geometry compress();

    @Override
    public Set<ByteArray> getLinkedClusters() {
        return this.getLinkedClusters(false);
    }

    protected void union(Geometry otherGeo) {
        if (otherGeo == null) {
            return;
        }
        try {
            this.clusterGeo = this.clusterGeo == null ? otherGeo : (this.clusterGeo instanceof Point ? connectGeometryTool.connect(otherGeo, this.clusterGeo) : connectGeometryTool.connect(this.clusterGeo, otherGeo));
        }
        catch (TopologyException ex) {
            LOGGER.error("Union failed due to non-simple geometries", (Throwable)ex);
            this.clusterGeo = connectGeometryTool.createHullFromGeometry(this.clusterGeo, Arrays.asList(otherGeo.getCoordinates()), false);
        }
    }

    protected void mergeLinks(boolean deleteNonLinks) {
        if (this.getLinkedClusters(false).size() == 0) {
            return;
        }
        HashSet<Cluster> readyClusters = new HashSet<Cluster>();
        readyClusters.add(this);
        this.buildClusterLists(readyClusters, this, deleteNonLinks);
        readyClusters.remove(this);
        Iterator finishedIt = readyClusters.iterator();
        DBScanClusterList top = this;
        while (finishedIt.hasNext()) {
            top.merge((Cluster)finishedIt.next());
        }
    }

    private void buildClusterLists(Set<Cluster> readyClusters, DBScanClusterList cluster, boolean deleteNonLinks) {
        for (ByteArray linkedClusterId : cluster.getLinkedClusters()) {
            Cluster linkedCluster = this.index.get(linkedClusterId);
            if (!readyClusters.add(linkedCluster) || linkedCluster.size() < mergeSize) continue;
            this.buildClusterLists(readyClusters, (DBScanClusterList)linkedCluster, false);
        }
    }

    public String toString() {
        return "DBScanClusterList [clusterGeo=" + (this.clusterGeo == null ? "null" : this.clusterGeo.toString()) + ", id=" + this.id + "]";
    }
}

