/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.dbscan;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskCounter;
import org.locationtech.geowave.analytic.IndependentJobRunner;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.mapreduce.GeoWaveInputFormatConfiguration;
import org.locationtech.geowave.analytic.mapreduce.GeoWaveOutputFormatConfiguration;
import org.locationtech.geowave.analytic.mapreduce.MapReduceJobController;
import org.locationtech.geowave.analytic.mapreduce.MapReduceJobRunner;
import org.locationtech.geowave.analytic.mapreduce.SequenceFileInputFormatConfiguration;
import org.locationtech.geowave.analytic.mapreduce.SequenceFileOutputFormatConfiguration;
import org.locationtech.geowave.analytic.mapreduce.clustering.runner.GeoWaveInputLoadJobRunner;
import org.locationtech.geowave.analytic.mapreduce.dbscan.DBScanJobRunner;
import org.locationtech.geowave.analytic.mapreduce.nn.NNMapReduce;
import org.locationtech.geowave.analytic.param.ClusteringParameters;
import org.locationtech.geowave.analytic.param.FormatConfiguration;
import org.locationtech.geowave.analytic.param.GlobalParameters;
import org.locationtech.geowave.analytic.param.HullParameters;
import org.locationtech.geowave.analytic.param.MapReduceParameters;
import org.locationtech.geowave.analytic.param.OutputParameters;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.locationtech.geowave.analytic.param.PartitionParameters;
import org.locationtech.geowave.analytic.partitioner.OrthodromicDistancePartitioner;
import org.locationtech.geowave.analytic.partitioner.Partitioner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBScanIterationsJobRunner
implements MapReduceJobRunner,
IndependentJobRunner {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DBScanIterationsJobRunner.class);
    DBScanJobRunner jobRunner = new DBScanJobRunner();
    GeoWaveInputLoadJobRunner inputLoadRunner = new GeoWaveInputLoadJobRunner();
    protected FormatConfiguration inputFormatConfiguration = new GeoWaveInputFormatConfiguration();
    protected int zoomLevel = 1;

    public DBScanIterationsJobRunner() {
        this.jobRunner.setInputFormatConfiguration(this.inputFormatConfiguration);
        this.inputLoadRunner.setOutputFormatConfiguration(new GeoWaveOutputFormatConfiguration());
    }

    public void setInputFormatConfiguration(FormatConfiguration inputFormatConfiguration) {
        this.inputFormatConfiguration = inputFormatConfiguration;
    }

    public void setReducerCount(int reducerCount) {
        this.jobRunner.setReducerCount(reducerCount);
    }

    protected void setZoomLevel(int zoomLevel) {
        this.zoomLevel = zoomLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(Configuration config, PropertyManagement runTimeProperties) throws Exception {
        runTimeProperties.storeIfEmpty((ParameterEnum)GlobalParameters.Global.BATCH_ID, (Serializable)((Object)UUID.randomUUID().toString()));
        try (FileSystem fs = null;){
            fs = FileSystem.get((Configuration)config);
            String outputBaseDir = runTimeProperties.getPropertyAsString((ParameterEnum)MapReduceParameters.MRConfig.HDFS_BASE_DIR, "/tmp");
            Path startPath = new Path(outputBaseDir + "/level_0");
            if (fs.exists(startPath)) {
                fs.delete(startPath, true);
            }
            runTimeProperties.storeIfEmpty((ParameterEnum)PartitionParameters.Partition.PARTITIONER_CLASS, OrthodromicDistancePartitioner.class);
            double maxDistance = runTimeProperties.getPropertyAsDouble((ParameterEnum)PartitionParameters.Partition.MAX_DISTANCE, 10.0);
            double precisionDecreaseRate = runTimeProperties.getPropertyAsDouble((ParameterEnum)PartitionParameters.Partition.PARTITION_DECREASE_RATE, 0.15);
            double precisionFactor = runTimeProperties.getPropertyAsDouble((ParameterEnum)PartitionParameters.Partition.PARTITION_PRECISION, 1.0);
            runTimeProperties.storeIfEmpty((ParameterEnum)PartitionParameters.Partition.DISTANCE_THRESHOLDS, (Serializable)((Object)Double.toString(maxDistance)));
            boolean overrideSecondary = runTimeProperties.hasProperty((ParameterEnum)PartitionParameters.Partition.SECONDARY_PARTITIONER_CLASS);
            if (!overrideSecondary) {
                Serializable distances = runTimeProperties.get((ParameterEnum)PartitionParameters.Partition.DISTANCE_THRESHOLDS);
                String dstStr = distances == null ? "0.000001" : distances.toString();
                String[] distancesArray = dstStr.split(",");
                double[] distancePerDimension = new double[distancesArray.length];
                int i = 0;
                for (String eachDistance : distancesArray) {
                    distancePerDimension[i++] = Double.valueOf(eachDistance);
                }
                boolean secondary = precisionFactor < 1.0;
                double total = 1.0;
                for (double dist : distancePerDimension) {
                    total *= dist;
                }
                if (secondary |= total >= Math.pow(maxDistance, distancePerDimension.length) * 2.0) {
                    runTimeProperties.copy((ParameterEnum)PartitionParameters.Partition.PARTITIONER_CLASS, (ParameterEnum)PartitionParameters.Partition.SECONDARY_PARTITIONER_CLASS);
                }
            }
            this.jobRunner.setInputFormatConfiguration(this.inputFormatConfiguration);
            this.jobRunner.setOutputFormatConfiguration(new SequenceFileOutputFormatConfiguration(startPath));
            LOGGER.info("Running with partition distance {}", (Object)maxDistance);
            int initialStatus = this.jobRunner.run(config, runTimeProperties);
            if (initialStatus != 0) {
                int dstStr = initialStatus;
                return dstStr;
            }
            precisionFactor -= precisionDecreaseRate;
            int maxIterationCount = runTimeProperties.getPropertyAsInt((ParameterEnum)ClusteringParameters.Clustering.MAX_ITERATIONS, 15);
            int iteration = 2;
            long lastRecordCount = 0L;
            while (maxIterationCount > 0 && precisionFactor > 0.0) {
                try {
                    Partitioner partitioner = (Partitioner)runTimeProperties.getClassInstance((ParameterEnum)PartitionParameters.Partition.PARTITIONER_CLASS, Partitioner.class, OrthodromicDistancePartitioner.class);
                    partitioner.initialize((JobContext)Job.getInstance((Configuration)config), partitioner.getClass());
                }
                catch (IllegalArgumentException argEx) {
                    LOGGER.info("Distance is invalid", (Throwable)argEx);
                    break;
                }
                catch (Exception e1) {
                    throw new IOException(e1);
                }
                PropertyManagement localScopeProperties = new PropertyManagement(runTimeProperties);
                if (precisionFactor <= 0.9 && !overrideSecondary) {
                    localScopeProperties.store((ParameterEnum)PartitionParameters.Partition.SECONDARY_PARTITIONER_CLASS, NNMapReduce.PassthruPartitioner.class);
                }
                localScopeProperties.store((ParameterEnum)PartitionParameters.Partition.PARTITION_PRECISION, (Object)precisionFactor);
                this.jobRunner.setInputFormatConfiguration(new SequenceFileInputFormatConfiguration(startPath));
                this.jobRunner.setFirstIteration(false);
                localScopeProperties.store((ParameterEnum)HullParameters.Hull.ZOOM_LEVEL, (Object)this.zoomLevel);
                localScopeProperties.store((ParameterEnum)HullParameters.Hull.ITERATION, (Object)iteration);
                localScopeProperties.storeIfEmpty((ParameterEnum)OutputParameters.Output.DATA_TYPE_ID, (Serializable)((Object)localScopeProperties.getPropertyAsString((ParameterEnum)HullParameters.Hull.DATA_TYPE_ID, "concave_hull")));
                localScopeProperties.store((ParameterEnum)ClusteringParameters.Clustering.MINIMUM_SIZE, (Object)0);
                Path nextPath = new Path(outputBaseDir + "/level_" + iteration);
                if (fs.exists(nextPath)) {
                    fs.delete(nextPath, true);
                }
                this.jobRunner.setOutputFormatConfiguration(new SequenceFileOutputFormatConfiguration(nextPath));
                int status = this.jobRunner.run(config, localScopeProperties);
                if (status != 0) {
                    int eachDistance = status;
                    return eachDistance;
                }
                long currentOutputCount = this.jobRunner.getCounterValue((Enum<?>)TaskCounter.REDUCE_OUTPUT_RECORDS);
                if (currentOutputCount == lastRecordCount) {
                    maxIterationCount = 0;
                }
                lastRecordCount = currentOutputCount;
                startPath = nextPath;
                --maxIterationCount;
                precisionFactor -= precisionDecreaseRate;
                ++iteration;
            }
            PropertyManagement localScopeProperties = new PropertyManagement(runTimeProperties);
            localScopeProperties.storeIfEmpty((ParameterEnum)OutputParameters.Output.DATA_TYPE_ID, (Serializable)((Object)localScopeProperties.getPropertyAsString((ParameterEnum)HullParameters.Hull.DATA_TYPE_ID, "concave_hull")));
            localScopeProperties.storeIfEmpty((ParameterEnum)OutputParameters.Output.DATA_NAMESPACE_URI, (Serializable)((Object)localScopeProperties.getPropertyAsString((ParameterEnum)HullParameters.Hull.DATA_NAMESPACE_URI, "http://www.opengis.net/gml")));
            localScopeProperties.storeIfEmpty((ParameterEnum)OutputParameters.Output.INDEX_ID, localScopeProperties.get((ParameterEnum)HullParameters.Hull.INDEX_NAME));
            this.inputLoadRunner.setInputFormatConfiguration(new SequenceFileInputFormatConfiguration(startPath));
            this.inputLoadRunner.run(config, runTimeProperties);
        }
        return 0;
    }

    public Collection<ParameterEnum<?>> getParameters() {
        HashSet params = new HashSet();
        params.addAll(this.jobRunner.getParameters());
        params.addAll(this.inputLoadRunner.getParameters());
        params.add((ParameterEnum<?>)ClusteringParameters.Clustering.MAX_ITERATIONS);
        params.add((ParameterEnum<?>)PartitionParameters.Partition.PARTITION_DECREASE_RATE);
        params.add((ParameterEnum<?>)PartitionParameters.Partition.PARTITION_PRECISION);
        return params;
    }

    public int run(PropertyManagement runTimeProperties) throws Exception {
        return this.run(MapReduceJobController.getConfiguration(runTimeProperties), runTimeProperties);
    }
}

