/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.dbscan;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapreduce.Job;
import org.locationtech.geowave.analytic.AdapterWithObjectWritable;
import org.locationtech.geowave.analytic.AnalyticFeature;
import org.locationtech.geowave.analytic.Projection;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.SimpleFeatureProjection;
import org.locationtech.geowave.analytic.mapreduce.dbscan.DBScanMapReduce;
import org.locationtech.geowave.analytic.mapreduce.nn.NNJobRunner;
import org.locationtech.geowave.analytic.mapreduce.nn.NNMapReduce;
import org.locationtech.geowave.analytic.param.ClusteringParameters;
import org.locationtech.geowave.analytic.param.GlobalParameters;
import org.locationtech.geowave.analytic.param.HullParameters;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.locationtech.geowave.analytic.param.PartitionParameters;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.metadata.InternalAdapterStoreImpl;
import org.locationtech.geowave.mapreduce.JobContextAdapterStore;
import org.locationtech.geowave.mapreduce.JobContextInternalAdapterStore;
import org.locationtech.geowave.mapreduce.input.GeoWaveInputKey;

public class DBScanJobRunner
extends NNJobRunner {
    private static final String[] CodecsRank = new String[]{"BZip2", "Lz4", "Snappy", "Lzo"};
    private boolean firstIteration = true;
    private long memInMB = 4096L;

    @Override
    public void configure(Job job) throws Exception {
        super.configure(job);
        job.setMapperClass(NNMapReduce.NNMapper.class);
        job.setReducerClass(DBScanMapReduce.DBScanMapHullReducer.class);
        job.setMapOutputKeyClass(NNMapReduce.PartitionDataWritable.class);
        job.setMapOutputValueClass(AdapterWithObjectWritable.class);
        job.setOutputKeyClass(GeoWaveInputKey.class);
        job.setOutputValueClass(ObjectWritable.class);
        job.setSpeculativeExecution(false);
        Configuration conf = job.getConfiguration();
        conf.set("mapreduce.map.java.opts", "-Xmx" + this.memInMB + "m");
        conf.set("mapreduce.reduce.java.opts", "-Xmx" + this.memInMB + "m");
        conf.setLong("mapred.task.timeout", 2000000L);
        conf.setInt("mapreduce.task.io.sort.mb", 250);
        job.getConfiguration().setBoolean("mapreduce.reduce.speculative", false);
        Class bestCodecClass = DefaultCodec.class;
        int rank = 0;
        for (Class codecClass : CompressionCodecFactory.getCodecClasses((Configuration)conf)) {
            int r = 1;
            for (String codecs : CodecsRank) {
                if (codecClass.getName().contains(codecs)) break;
                ++r;
            }
            if (rank >= r || r > CodecsRank.length) continue;
            try {
                CompressionCodec codec = (CompressionCodec)codecClass.newInstance();
                if (Configurable.class.isAssignableFrom(codecClass)) {
                    ((Configurable)codec).setConf(conf);
                }
                CodecPool.getCompressor((CompressionCodec)codec);
                bestCodecClass = codecClass;
                rank = r;
            }
            catch (Throwable ex) {
                LOGGER.info("Not configuable in this context", ex);
            }
        }
        LOGGER.warn("Compression with " + bestCodecClass.toString());
        conf.setClass("mapreduce.map.output.compress.codec", bestCodecClass, CompressionCodec.class);
        conf.setBoolean("mapreduce.map.output.compress", true);
        conf.setBooleanIfUnset("first.iteration", this.firstIteration);
    }

    public void setMemoryInMB(long memInMB) {
        this.memInMB = memInMB;
    }

    protected void setFirstIteration(boolean firstIteration) {
        this.firstIteration = firstIteration;
    }

    @Override
    public int run(Configuration config, PropertyManagement runTimeProperties) throws Exception {
        runTimeProperties.storeIfEmpty((ParameterEnum)HullParameters.Hull.DATA_TYPE_ID, (Serializable)((Object)"concave_hull"));
        String adapterID = runTimeProperties.getPropertyAsString((ParameterEnum)HullParameters.Hull.DATA_TYPE_ID, "concave_hull");
        String namespaceURI = runTimeProperties.storeIfEmpty((ParameterEnum)HullParameters.Hull.DATA_NAMESPACE_URI, (Serializable)((Object)"http://www.opengis.net/gml")).toString();
        JobContextAdapterStore.addDataAdapter((Configuration)config, (DataTypeAdapter)AnalyticFeature.createGeometryFeatureAdapter((String)adapterID, (String[])new String[0], (String)namespaceURI, (String)"EPSG:4326"));
        JobContextInternalAdapterStore.addTypeName((Configuration)config, (String)adapterID, (short)InternalAdapterStoreImpl.getLazyInitialAdapterId((String)adapterID));
        Projection projectionFunction = (Projection)runTimeProperties.getClassInstance((ParameterEnum)HullParameters.Hull.PROJECTION_CLASS, Projection.class, SimpleFeatureProjection.class);
        projectionFunction.setup(runTimeProperties, this.getScope(), config);
        runTimeProperties.setConfig(new ParameterEnum[]{HullParameters.Hull.PROJECTION_CLASS, GlobalParameters.Global.BATCH_ID, HullParameters.Hull.ZOOM_LEVEL, HullParameters.Hull.ITERATION, HullParameters.Hull.DATA_TYPE_ID, HullParameters.Hull.DATA_NAMESPACE_URI, ClusteringParameters.Clustering.MINIMUM_SIZE, PartitionParameters.Partition.GEOMETRIC_DISTANCE_UNIT, PartitionParameters.Partition.DISTANCE_THRESHOLDS, PartitionParameters.Partition.MAX_MEMBER_SELECTION}, config, this.getScope());
        return super.run(config, runTimeProperties);
    }

    @Override
    public Collection<ParameterEnum<?>> getParameters() {
        Collection<ParameterEnum<?>> params = super.getParameters();
        params.addAll(Arrays.asList(PartitionParameters.Partition.PARTITIONER_CLASS, PartitionParameters.Partition.MAX_DISTANCE, PartitionParameters.Partition.MAX_MEMBER_SELECTION, GlobalParameters.Global.BATCH_ID, HullParameters.Hull.DATA_TYPE_ID, HullParameters.Hull.PROJECTION_CLASS, ClusteringParameters.Clustering.MINIMUM_SIZE, PartitionParameters.Partition.GEOMETRIC_DISTANCE_UNIT, PartitionParameters.Partition.DISTANCE_THRESHOLDS));
        return params;
    }
}

