/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.dbscan;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.mapreduce.Reducer;
import org.locationtech.geowave.adapter.vector.FeatureDataAdapter;
import org.locationtech.geowave.analytic.AnalyticFeature;
import org.locationtech.geowave.analytic.Projection;
import org.locationtech.geowave.analytic.ScopedJobConfiguration;
import org.locationtech.geowave.analytic.SimpleFeatureProjection;
import org.locationtech.geowave.analytic.distance.CoordinateCircleDistanceFn;
import org.locationtech.geowave.analytic.distance.DistanceFn;
import org.locationtech.geowave.analytic.mapreduce.dbscan.Cluster;
import org.locationtech.geowave.analytic.mapreduce.dbscan.ClusterItem;
import org.locationtech.geowave.analytic.mapreduce.dbscan.ClusterItemDistanceFn;
import org.locationtech.geowave.analytic.mapreduce.dbscan.ClusterNeighborList;
import org.locationtech.geowave.analytic.mapreduce.dbscan.ClusterUnionList;
import org.locationtech.geowave.analytic.mapreduce.dbscan.DBScanClusterList;
import org.locationtech.geowave.analytic.mapreduce.dbscan.PreProcessSingleItemClusterList;
import org.locationtech.geowave.analytic.mapreduce.dbscan.SingleItemClusterList;
import org.locationtech.geowave.analytic.mapreduce.nn.NNMapReduce;
import org.locationtech.geowave.analytic.nn.NNProcessor;
import org.locationtech.geowave.analytic.nn.NeighborList;
import org.locationtech.geowave.analytic.nn.NeighborListFactory;
import org.locationtech.geowave.analytic.nn.TypeConverter;
import org.locationtech.geowave.analytic.param.ClusteringParameters;
import org.locationtech.geowave.analytic.param.GlobalParameters;
import org.locationtech.geowave.analytic.param.HullParameters;
import org.locationtech.geowave.analytic.partitioner.Partitioner;
import org.locationtech.geowave.core.index.ByteArray;
import org.locationtech.geowave.core.store.metadata.InternalAdapterStoreImpl;
import org.locationtech.geowave.mapreduce.HadoopWritableSerializer;
import org.locationtech.geowave.mapreduce.input.GeoWaveInputKey;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBScanMapReduce {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DBScanMapReduce.class);

    public static class DBScanMapHullReducer
    extends DBScanMapReducer<GeoWaveInputKey, ObjectWritable> {
        private String batchID;
        private int zoomLevel = 1;
        private int iteration = 1;
        private FeatureDataAdapter outputAdapter;
        private final ObjectWritable output = new ObjectWritable();
        private boolean firstIteration = true;

        protected int calculateCondensingMinimum() {
            return Math.min(Math.max(this.minOwners, 200), this.minOwners * 10);
        }

        protected int calculateTossMinimum() {
            return this.minOwners - 2;
        }

        @Override
        protected void preprocess(final Reducer.Context context, final NNProcessor<Object, ClusterItem> processor, Map<ByteArray, Cluster> index) throws IOException, InterruptedException {
            if (!this.firstIteration) {
                return;
            }
            processor.trimSmallPartitions(this.calculateTossMinimum());
            if ((double)processor.size() < (double)this.calculateCondensingMinimum() * 2.0) {
                return;
            }
            processor.process((NeighborListFactory)new ClusterNeighborList.ClusterNeighborListFactory(new PreProcessSingleItemClusterList.PreProcessSingleItemClusterListFactory(index), index), (NNProcessor.CompleteNotifier)new NNProcessor.CompleteNotifier<ClusterItem>(){
                final int condenseSize;
                final int tossSize;
                {
                    this.condenseSize = this.calculateCondensingMinimum();
                    this.tossSize = this.calculateTossMinimum();
                }

                public void complete(ByteArray id, ClusterItem value, NeighborList<ClusterItem> list) {
                    Cluster cluster = ((ClusterNeighborList)list).getCluster();
                    if (cluster.size() < this.tossSize) {
                        processor.remove(id);
                    } else if (cluster.size() > this.condenseSize) {
                        cluster.finish();
                        value.setGeometry(cluster.getGeometry());
                        value.setCount(list.size());
                        value.setCompressed();
                        Iterator<ByteArray> it = cluster.getLinkedClusters().iterator();
                        while (it.hasNext()) {
                            ByteArray idToRemove = it.next();
                            processor.remove(idToRemove);
                            it.remove();
                        }
                    } else {
                        cluster.clear();
                    }
                    context.progress();
                }
            });
            index.clear();
        }

        @Override
        protected void processSummary(Partitioner.PartitionData partitionData, Map<ByteArray, Cluster> summary, Reducer.Context context) throws IOException, InterruptedException {
            HadoopWritableSerializer serializer = this.outputAdapter.createWritableSerializer();
            HashSet<Cluster> processed = new HashSet<Cluster>();
            Iterator<Map.Entry<ByteArray, Cluster>> clusterIt = summary.entrySet().iterator();
            while (clusterIt.hasNext()) {
                Cluster cluster = clusterIt.next().getValue();
                clusterIt.remove();
                if (!cluster.isCompressed() || processed.contains(cluster)) continue;
                processed.add(cluster);
                SimpleFeature newPolygonFeature = AnalyticFeature.createGeometryFeature((SimpleFeatureType)this.outputAdapter.getFeatureType(), (String)this.batchID, (String)UUID.randomUUID().toString(), (String)cluster.getId().getString(), (String)(partitionData.getGroupId() != null ? partitionData.getGroupId().toString() : cluster.getId().getString()), (double)0.0, (Geometry)cluster.getGeometry(), (String[])new String[0], (double[])new double[0], (int)this.zoomLevel, (int)this.iteration, (long)cluster.size());
                this.output.set((Object)serializer.toWritable((Object)newPolygonFeature));
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Generating {}", (Object)newPolygonFeature.toString());
                }
                context.write((Object)new GeoWaveInputKey(InternalAdapterStoreImpl.getLazyInitialAdapterId((String)this.outputAdapter.getTypeName()), new ByteArray(newPolygonFeature.getID())), (Object)this.output);
            }
        }

        @Override
        public NeighborListFactory<ClusterItem> createNeighborsListFactory(Map<ByteArray, Cluster> summary) {
            return new ClusterNeighborList.ClusterNeighborListFactory((NeighborListFactory<ClusterItem>)(this.firstIteration ? new SingleItemClusterList.SingleItemClusterListFactory(summary) : new ClusterUnionList.ClusterUnionListFactory(summary)), summary);
        }

        @Override
        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            Projection projectionFunction;
            ScopedJobConfiguration config = new ScopedJobConfiguration(context.getConfiguration(), NNMapReduce.class);
            super.setup(context);
            DBScanClusterList.getHullTool().setDistanceFnForCoordinate((DistanceFn)new CoordinateCircleDistanceFn());
            DBScanClusterList.setMergeSize(this.minOwners);
            this.batchID = config.getString((Enum)GlobalParameters.Global.BATCH_ID, UUID.randomUUID().toString());
            this.zoomLevel = config.getInt((Enum)HullParameters.Hull.ZOOM_LEVEL, 1);
            this.iteration = config.getInt((Enum)HullParameters.Hull.ITERATION, 1);
            this.firstIteration = context.getConfiguration().getBoolean("first.iteration", true);
            String polygonDataTypeId = config.getString((Enum)HullParameters.Hull.DATA_TYPE_ID, "concave_hull");
            this.outputAdapter = AnalyticFeature.createGeometryFeatureAdapter((String)polygonDataTypeId, (String[])new String[0], (String)config.getString((Enum)HullParameters.Hull.DATA_NAMESPACE_URI, "http://www.opengis.net/gml"), (String)"EPSG:4326");
            try {
                projectionFunction = (Projection)config.getInstance((Enum)HullParameters.Hull.PROJECTION_CLASS, Projection.class, SimpleFeatureProjection.class);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IOException(e);
            }
            this.typeConverter = new SimpleFeatureToClusterItemConverter((Projection<SimpleFeature>)projectionFunction);
            this.distanceProfileFn = new ClusterItemDistanceFn();
            this.distanceFn = new ClusterItemDistanceFn();
        }
    }

    public static class SimpleFeatureToClusterItemConverter
    implements TypeConverter<ClusterItem> {
        final Projection<SimpleFeature> projection;

        public SimpleFeatureToClusterItemConverter(Projection<SimpleFeature> projection) {
            this.projection = projection;
        }

        public ClusterItem convert(ByteArray id, Object o) {
            SimpleFeature feature = (SimpleFeature)o;
            Long count = (Long)feature.getAttribute(AnalyticFeature.ClusterFeatureAttribute.COUNT.attrName());
            return new ClusterItem(feature.getID(), this.projection.getProjection((Object)feature), count == null ? 1L : count, false);
        }
    }

    public static abstract class DBScanMapReducer<KEYOUT, VALUEOUT>
    extends NNMapReduce.NNReducer<ClusterItem, KEYOUT, VALUEOUT, Map<ByteArray, Cluster>> {
        protected int minOwners = 0;

        @Override
        protected Map<ByteArray, Cluster> createSummary() {
            return new HashMap<ByteArray, Cluster>();
        }

        @Override
        protected void processNeighbors(Partitioner.PartitionData partitionData, ByteArray primaryId, ClusterItem primary, NeighborList<ClusterItem> neighbors, Reducer.Context context, Map<ByteArray, Cluster> index) throws IOException, InterruptedException {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Finish {} ", (Object)primaryId);
            }
            if (neighbors == null) {
                return;
            }
            Cluster cluster = ((ClusterNeighborList)neighbors).getCluster();
            if (cluster == null) {
                return;
            }
            if (cluster.size() < this.minOwners) {
                LOGGER.trace("Invalidate {} ", (Object)primaryId);
                cluster.invalidate();
                return;
            }
            cluster.finish();
        }

        @Override
        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            super.setup(context);
            ScopedJobConfiguration config = new ScopedJobConfiguration(context.getConfiguration(), NNMapReduce.class);
            this.minOwners = config.getInt((Enum)ClusteringParameters.Clustering.MINIMUM_SIZE, 2);
            LOGGER.info("Minumum owners = {}", (Object)this.minOwners);
        }
    }
}

