/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.dbscan;

import java.util.Arrays;
import java.util.Map;
import org.locationtech.geowave.analytic.mapreduce.dbscan.Cluster;
import org.locationtech.geowave.analytic.mapreduce.dbscan.ClusterItem;
import org.locationtech.geowave.analytic.mapreduce.dbscan.SingleItemClusterList;
import org.locationtech.geowave.analytic.nn.NeighborList;
import org.locationtech.geowave.analytic.nn.NeighborListFactory;
import org.locationtech.geowave.core.index.ByteArray;

public class PreProcessSingleItemClusterList
extends SingleItemClusterList
implements Cluster {
    public PreProcessSingleItemClusterList(ByteArray centerId, ClusterItem center, NeighborListFactory<ClusterItem> factory, Map<ByteArray, Cluster> index) {
        super(centerId, center, factory, index);
    }

    @Override
    protected void mergeLinks(boolean deleteNonLinks) {
        for (ByteArray id : this.getLinkedClusters()) {
            PreProcessSingleItemClusterList other = (PreProcessSingleItemClusterList)this.index.get(id);
            long snapShot = this.getClusterPoints(false).size();
            if (other.clusterGeo != null) {
                this.getClusterPoints(true).addAll(Arrays.asList(other.clusterGeo.getCoordinates()));
            }
            this.getClusterPoints(true).addAll(other.getClusterPoints(false));
            this.incrementItemCount((long)this.getClusterPoints(true).size() - snapShot);
        }
    }

    public static class PreProcessSingleItemClusterListFactory
    implements NeighborListFactory<ClusterItem> {
        private final Map<ByteArray, Cluster> index;

        public PreProcessSingleItemClusterListFactory(Map<ByteArray, Cluster> index) {
            this.index = index;
        }

        public NeighborList<ClusterItem> buildNeighborList(ByteArray centerId, ClusterItem center) {
            Cluster list = this.index.get(centerId);
            if (list == null) {
                list = new PreProcessSingleItemClusterList(centerId, center, this, this.index);
            }
            return list;
        }
    }
}

