/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.dbscan;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.locationtech.geowave.analytic.mapreduce.dbscan.Cluster;
import org.locationtech.geowave.analytic.mapreduce.dbscan.ClusterItem;
import org.locationtech.geowave.analytic.mapreduce.dbscan.ClusterItemDistanceFn;
import org.locationtech.geowave.analytic.mapreduce.dbscan.DBScanClusterList;
import org.locationtech.geowave.analytic.nn.DistanceProfile;
import org.locationtech.geowave.analytic.nn.NeighborList;
import org.locationtech.geowave.analytic.nn.NeighborListFactory;
import org.locationtech.geowave.core.index.ByteArray;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class SingleItemClusterList
extends DBScanClusterList
implements Cluster {
    private boolean compressed = false;
    private Set<Coordinate> clusterPoints = null;

    public SingleItemClusterList(ByteArray centerId, ClusterItem center, NeighborListFactory<ClusterItem> factory, Map<ByteArray, Cluster> index) {
        super((Geometry)(center.getGeometry() instanceof Point || center.isCompressed() ? center.getGeometry() : null), (int)center.getCount(), centerId, index);
        Geometry clusterGeo = center.getGeometry();
        this.compressed = center.isCompressed();
        if (this.compressed) {
            this.getClusterPoints(true).add(clusterGeo.getCentroid().getCoordinate());
        }
    }

    protected Set<Coordinate> getClusterPoints(boolean allowUpdates) {
        if (this.clusterPoints == null || this.clusterPoints == Collections.emptySet()) {
            this.clusterPoints = allowUpdates ? new HashSet() : Collections.emptySet();
        }
        return this.clusterPoints;
    }

    @Override
    public void clear() {
        super.clear();
        this.clusterPoints = null;
    }

    @Override
    protected long addAndFetchCount(ByteArray id, ClusterItem newInstance, DistanceProfile<?> distanceProfile) {
        ClusterItemDistanceFn.ClusterProfileContext context = (ClusterItemDistanceFn.ClusterProfileContext)distanceProfile.getContext();
        boolean checkForCompress = false;
        Coordinate centerCoordinate = context.getItem1() == newInstance ? context.getPoint2() : context.getPoint1();
        Geometry thisGeo = this.getGeometry();
        if (thisGeo == null || !(thisGeo instanceof Point)) {
            checkForCompress = this.getClusterPoints(true).add(centerCoordinate);
        }
        if (!(newInstance.getGeometry() instanceof Point)) {
            Coordinate newInstanceCoordinate = context.getItem2() == newInstance ? context.getPoint2() : context.getPoint1();
            checkForCompress = this.getClusterPoints(true).add(newInstanceCoordinate);
        }
        if (checkForCompress) {
            this.checkForCompression();
        }
        return 1L;
    }

    @Override
    public void merge(Cluster cluster) {
        Set<Coordinate> otherPoints;
        if (this == cluster) {
            return;
        }
        SingleItemClusterList singleItemCluster = (SingleItemClusterList)cluster;
        super.merge(cluster);
        if (singleItemCluster.clusterGeo != null) {
            this.getClusterPoints(true).addAll(Arrays.asList(singleItemCluster.clusterGeo.getCoordinates()));
        }
        if ((otherPoints = singleItemCluster.getClusterPoints(false)).size() > 0) {
            this.getClusterPoints(true).addAll(otherPoints);
        }
        this.checkForCompression();
    }

    @Override
    public boolean isCompressed() {
        return this.compressed;
    }

    @Override
    public void finish() {
        super.finish();
        this.compressAndUpdate();
    }

    private void checkForCompression() {
        if (this.getClusterPoints(false).size() > 50) {
            this.compressAndUpdate();
        }
    }

    private void compressAndUpdate() {
        this.clusterGeo = this.compress();
        this.clusterPoints = null;
        this.compressed = true;
    }

    @Override
    protected Geometry compress() {
        if (this.getClusterPoints(false).size() > 0) {
            return DBScanClusterList.getHullTool().createHullFromGeometry(this.clusterGeo, this.clusterPoints, true);
        }
        return this.clusterGeo;
    }

    public static class SingleItemClusterListFactory
    implements NeighborListFactory<ClusterItem> {
        private final Map<ByteArray, Cluster> index;

        public SingleItemClusterListFactory(Map<ByteArray, Cluster> index) {
            this.index = index;
        }

        public NeighborList<ClusterItem> buildNeighborList(ByteArray centerId, ClusterItem center) {
            Cluster list = this.index.get(centerId);
            if (list == null) {
                list = new SingleItemClusterList(centerId, center, this, this.index);
            }
            return list;
        }
    }
}

