/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.kde;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Reducer;

public class CellSummationReducer
extends Reducer<LongWritable, DoubleWritable, DoubleWritable, LongWritable> {
    private final Map<Long, Double> maxPerLevel = new HashMap<Long, Double>();
    protected int minLevel;
    protected int maxLevel;
    protected int numLevels;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        this.minLevel = context.getConfiguration().getInt("MIN_LEVEL", 1);
        this.maxLevel = context.getConfiguration().getInt("MAX_LEVEL", 25);
        this.numLevels = this.maxLevel - this.minLevel + 1;
        super.setup(context);
    }

    public void reduce(LongWritable key, Iterable<DoubleWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        double sum = 0.0;
        for (DoubleWritable value : values) {
            sum += value.get();
        }
        context.write((Object)new DoubleWritable(sum), (Object)key);
        this.collectStats(key, sum, context);
    }

    protected void collectStats(LongWritable key, double sum, Reducer.Context context) {
        long level = key.get() % (long)this.numLevels + (long)this.minLevel;
        Double max = this.maxPerLevel.get(level);
        if (max == null || sum > max) {
            max = sum;
            this.maxPerLevel.put(level, max);
        }
        context.getCounter("Entries per level", "level " + Long.toString(level)).increment(1L);
    }

    protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
        for (Map.Entry<Long, Double> e : this.maxPerLevel.entrySet()) {
            context.write((Object)new DoubleWritable(-e.getValue().doubleValue()), (Object)new LongWritable(e.getKey() - (long)this.minLevel));
        }
        super.cleanup(context);
    }
}

