/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.kde;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.geowave.analytic.mapreduce.kde.CellCounter;
import org.locationtech.geowave.analytic.mapreduce.kde.GaussianFilter;
import org.locationtech.geowave.analytic.mapreduce.kde.KDEJobRunner;
import org.locationtech.geowave.analytic.mapreduce.kde.MapContextCellCounter;
import org.locationtech.geowave.mapreduce.input.GeoWaveInputKey;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GaussianCellMapper
extends Mapper<GeoWaveInputKey, SimpleFeature, LongWritable, DoubleWritable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GaussianCellMapper.class);
    protected static final String CQL_FILTER_KEY = "CQL_FILTER";
    protected int minLevel;
    protected int maxLevel;
    protected Filter filter;
    protected Map<Integer, LevelStore> levelStoreMap;
    protected GaussianFilter.ValueRange[] valueRangePerDimension;
    protected String inputCrsCode;
    protected String outputCrsCode;
    protected MathTransform transform;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.minLevel = context.getConfiguration().getInt("MIN_LEVEL", 1);
        this.maxLevel = context.getConfiguration().getInt("MAX_LEVEL", 25);
        this.valueRangePerDimension = new GaussianFilter.ValueRange[]{new GaussianFilter.ValueRange(context.getConfiguration().getDouble("X_MIN", -180.0), context.getConfiguration().getDouble("X_MAX", 180.0)), new GaussianFilter.ValueRange(context.getConfiguration().getDouble("Y_MIN", -90.0), context.getConfiguration().getDouble("Y_MAX", 90.0))};
        this.inputCrsCode = context.getConfiguration().get("INPUT_CRS");
        this.outputCrsCode = context.getConfiguration().get("OUTPUT_CRS");
        String cql = context.getConfiguration().get(CQL_FILTER_KEY);
        if (cql != null && !cql.isEmpty()) {
            try {
                this.filter = ECQL.toFilter((String)cql);
            }
            catch (CQLException e) {
                LOGGER.warn("Unable to parse CQL filter", (Throwable)e);
            }
        }
        this.levelStoreMap = new HashMap<Integer, LevelStore>();
        for (int level = this.maxLevel; level >= this.minLevel; --level) {
            int numXPosts = (int)Math.pow(2.0, level + 1) * KDEJobRunner.TILE_SIZE;
            int numYPosts = (int)Math.pow(2.0, level) * KDEJobRunner.TILE_SIZE;
            this.populateLevelStore(context, numXPosts, numYPosts, level);
        }
    }

    protected void populateLevelStore(Mapper.Context context, int numXPosts, int numYPosts, int level) {
        this.levelStoreMap.put(level, new LevelStore(numXPosts, numYPosts, new MapContextCellCounter(context, level, this.minLevel, this.maxLevel)));
    }

    protected void map(GeoWaveInputKey key, SimpleFeature value, Mapper.Context context) throws IOException, InterruptedException {
        Point pt = null;
        if (value != null) {
            if (this.filter != null && !this.filter.evaluate((Object)value)) {
                return;
            }
            Object geomObj = value.getDefaultGeometry();
            if (geomObj != null && geomObj instanceof Geometry) {
                if (this.inputCrsCode.equals(this.outputCrsCode)) {
                    pt = ((Geometry)geomObj).getCentroid();
                } else {
                    if (this.transform == null) {
                        try {
                            this.transform = CRS.findMathTransform((CoordinateReferenceSystem)CRS.decode((String)this.inputCrsCode, (boolean)true), (CoordinateReferenceSystem)CRS.decode((String)this.outputCrsCode, (boolean)true), (boolean)true);
                        }
                        catch (FactoryException e) {
                            LOGGER.error("Unable to decode " + this.inputCrsCode + " CRS", (Throwable)e);
                            throw new RuntimeException("Unable to initialize " + this.inputCrsCode + " object", e);
                        }
                    }
                    try {
                        Geometry transformedGeometry = JTS.transform((Geometry)((Geometry)geomObj), (MathTransform)this.transform);
                        pt = transformedGeometry.getCentroid();
                    }
                    catch (MismatchedDimensionException | TransformException e) {
                        LOGGER.warn("Unable to perform transform to specified CRS of the index, the feature geometry will remain in its original CRS", e);
                    }
                }
            }
        }
        if (pt == null || pt.isEmpty()) {
            return;
        }
        for (int level = this.maxLevel; level >= this.minLevel; --level) {
            this.incrementLevelStore(level, pt, value, this.valueRangePerDimension);
        }
    }

    protected void incrementLevelStore(int level, Point pt, SimpleFeature feature, GaussianFilter.ValueRange[] valueRangePerDimension) {
        LevelStore levelStore = this.levelStoreMap.get(level);
        GaussianFilter.incrementPt(pt.getY(), pt.getX(), levelStore.counter, levelStore.numXPosts, levelStore.numYPosts, valueRangePerDimension);
    }

    public static class LevelStore {
        public final int numXPosts;
        public final int numYPosts;
        public final CellCounter counter;

        public LevelStore(int numXPosts, int numYPosts, CellCounter counter) {
            this.numXPosts = numXPosts;
            this.numYPosts = numYPosts;
            this.counter = counter;
        }
    }
}

