/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.kde;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.locationtech.geowave.analytic.mapreduce.kde.CellCounter;

public class GaussianFilter {
    private static final double SQRT_2_PI = Math.sqrt(Math.PI * 2);
    private static double[] intermediateSmoothingGaussianKernel = new double[]{0.006, 0.061, 0.242, 0.383, 0.242, 0.061, 0.006};
    private static Map<Integer, List<int[]>> offsetsCache = new HashMap<Integer, List<int[]>>();
    private static List<int[]> TYPICAL_2D_OFFSET;
    private static double[] TYPICAL_2D_OFFSET_BLURS;
    private static final ValueRange[] valueRangePerDimension;

    public static void incrementPt(double lat, double lon, CellCounter results, int numXPosts, int numYPosts, ValueRange[] valueRangePerDimension) {
        GaussianFilter.incrementBBox(lon, lon, lat, lat, results, numXPosts, numYPosts, 1.0, valueRangePerDimension);
    }

    public static void incrementPt(double lat, double lon, CellCounter results, int numXPosts, int numYPosts, double contributionScaleFactor, ValueRange[] valueRangePerDimension) {
        GaussianFilter.incrementBBox(lon, lon, lat, lat, results, numXPosts, numYPosts, contributionScaleFactor, valueRangePerDimension);
    }

    public static void incrementPtFast(double[] binLocationPerDimension, int[] binsPerDimension, CellCounter results) {
        int numDimensions = 2;
        double[] gaussianKernel = GaussianFilter.getGaussianKernel(1.0, 3);
        int maxOffset = gaussianKernel.length / 2;
        List<int[]> offsets = GaussianFilter.getOffsets(2, 0, new int[2], gaussianKernel, maxOffset);
        for (int i = 0; i < offsets.size(); ++i) {
            int[] offset = offsets.get(i);
            double blur = GaussianFilter.getBlurFromOffset(i, 2, offset, gaussianKernel, maxOffset);
            List<BinPositionAndContribution> positionsAndContributions = GaussianFilter.getPositionsAndContributionPt(2, 0, binLocationPerDimension, blur, new int[2], binsPerDimension, offset);
            for (BinPositionAndContribution positionAndContribution : positionsAndContributions) {
                results.increment(positionAndContribution.position, positionAndContribution.contribution);
            }
        }
    }

    public static void incrementPtFast(double lat, double lon, CellCounter results, int numXPosts, int numYPosts) {
        int numDimensions = 2;
        double[] binLocationPerDimension = new double[2];
        int[] binsPerDimension = new int[]{numXPosts, numYPosts};
        double[] valsPerDimension = new double[]{lon, lat};
        for (int d = 0; d < 2; ++d) {
            ValueRange valueRange = valueRangePerDimension[d];
            double span = valueRange.getMax() - valueRange.getMin();
            binLocationPerDimension[d] = (valsPerDimension[d] - valueRange.getMin()) / span * (double)binsPerDimension[d];
        }
        double[] gaussianKernel = GaussianFilter.getGaussianKernel(1.0, 3);
        int maxOffset = gaussianKernel.length / 2;
        List<int[]> offsets = GaussianFilter.getOffsets(2, 0, new int[2], gaussianKernel, maxOffset);
        for (int i = 0; i < offsets.size(); ++i) {
            int[] offset = offsets.get(i);
            double blur = GaussianFilter.getBlurFromOffset(i, 2, offset, gaussianKernel, maxOffset);
            List<BinPositionAndContribution> positionsAndContributions = GaussianFilter.getPositionsAndContributionPt(2, 0, binLocationPerDimension, blur, new int[2], binsPerDimension, offset);
            for (BinPositionAndContribution positionAndContribution : positionsAndContributions) {
                results.increment(positionAndContribution.position, positionAndContribution.contribution);
            }
        }
    }

    public static void incrementPtFast(double x, double y, double minX, double maxX, double minY, double maxY, CellCounter results, int numXPosts, int numYPosts) {
        int numDimensions = 2;
        double[] binLocationPerDimension = new double[2];
        int[] binsPerDimension = new int[]{numXPosts, numYPosts};
        double spanX = maxX - minX;
        double spanY = maxY - minY;
        binLocationPerDimension[0] = (x - minX) / spanX * (double)binsPerDimension[0];
        binLocationPerDimension[1] = (y - minY) / spanY * (double)binsPerDimension[1];
        double[] gaussianKernel = GaussianFilter.getGaussianKernel(1.0, 3);
        int maxOffset = gaussianKernel.length / 2;
        List<int[]> offsets = GaussianFilter.getOffsets(2, 0, new int[2], gaussianKernel, maxOffset);
        for (int i = 0; i < offsets.size(); ++i) {
            int[] offset = offsets.get(i);
            double blur = GaussianFilter.getBlurFromOffset(i, 2, offset, gaussianKernel, maxOffset);
            List<BinPositionAndContribution> positionsAndContributions = GaussianFilter.getPositionsAndContributionPt(2, 0, binLocationPerDimension, blur, new int[2], binsPerDimension, offset);
            for (BinPositionAndContribution positionAndContribution : positionsAndContributions) {
                results.increment(positionAndContribution.position, positionAndContribution.contribution);
            }
        }
    }

    public static void incrementBBox(double minX, double maxX, double minY, double maxY, CellCounter results, int numXPosts, int numYPosts, double contributionScaleFactor, ValueRange[] valueRangePerDimension) {
        int numDimensions = 2;
        double[] minBinLocationPerDimension = new double[2];
        double[] maxBinLocationPerDimension = new double[2];
        int[] binsPerDimension = new int[]{numXPosts, numYPosts};
        double[] minsPerDimension = new double[]{minX, minY};
        double[] maxesPerDimension = new double[]{maxX, maxY};
        for (int d = 0; d < 2; ++d) {
            ValueRange valueRange = valueRangePerDimension[d];
            double span = valueRange.getMax() - valueRange.getMin();
            minBinLocationPerDimension[d] = (minsPerDimension[d] - valueRange.getMin()) / span * (double)binsPerDimension[d];
            maxBinLocationPerDimension[d] = (maxesPerDimension[d] - valueRange.getMin()) / span * (double)binsPerDimension[d];
            if (maxBinLocationPerDimension[d] < -1.0 || minBinLocationPerDimension[d] > (double)binsPerDimension[d]) {
                return;
            }
            minBinLocationPerDimension[d] = Math.max(minBinLocationPerDimension[d], -1.0);
            maxBinLocationPerDimension[d] = Math.min(maxBinLocationPerDimension[d], (double)binsPerDimension[d]);
        }
        double[] gaussianKernel = GaussianFilter.getGaussianKernel(1.0, 3);
        int maxOffset = gaussianKernel.length / 2;
        List<int[]> offsets = GaussianFilter.getOffsets(2, 0, new int[2], gaussianKernel, maxOffset);
        for (int i = 0; i < offsets.size(); ++i) {
            int[] offset = offsets.get(i);
            double blur = GaussianFilter.getBlurFromOffset(i, 2, offset, gaussianKernel, maxOffset);
            List<BinPositionAndContribution> positionsAndContributions = GaussianFilter.getPositionsAndContribution(2, 0, minBinLocationPerDimension, maxBinLocationPerDimension, blur, new int[2], binsPerDimension, offset);
            for (BinPositionAndContribution positionAndContribution : positionsAndContributions) {
                results.increment(positionAndContribution.position, positionAndContribution.contribution * contributionScaleFactor);
            }
        }
    }

    protected static double getSigma(int radius, int order) {
        return ((double)radius * 2.0 + 1.0) / (5.0 + 0.8 * (double)order);
    }

    protected static double[] getGaussianKernel(double sigma, int radius) {
        return intermediateSmoothingGaussianKernel;
    }

    protected static double[] calculateGaussianKernel(double sigma, int radius) {
        double[] kernel = new double[radius * 2 + 1];
        int index = 0;
        for (int i = radius; i >= -radius; --i) {
            kernel[index++] = GaussianFilter.computePDF(0.0, sigma, i);
        }
        return GaussianFilter.normalizeSumToOne(kernel);
    }

    protected static double computePDF(double mean, double sigma, double sample) {
        double delta = sample - mean;
        return Math.exp(-delta * delta / (2.0 * sigma * sigma)) / (sigma * SQRT_2_PI);
    }

    protected static double[] normalizeSumToOne(double[] kernel) {
        double[] retVal = new double[kernel.length];
        double total = 0.0;
        for (double element : kernel) {
            total += element;
        }
        for (int i = 0; i < kernel.length; ++i) {
            retVal[i] = kernel[i] / total;
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<int[]> getOffsets(int numDimensions, int currentDimension, int[] currentOffsetsPerDimension, double[] gaussianKernel, int maxOffset) {
        if (numDimensions == 2 && TYPICAL_2D_OFFSET != null) {
            return TYPICAL_2D_OFFSET;
        }
        List<int[]> offsets = offsetsCache.get(numDimensions);
        if (offsets == null) {
            Map<Integer, List<int[]>> map = offsetsCache;
            synchronized (map) {
                offsets = GaussianFilter.calculateOffsets(numDimensions, currentDimension, currentOffsetsPerDimension, gaussianKernel, maxOffset);
                offsetsCache.put(numDimensions, offsets);
                if (numDimensions == 2) {
                    TYPICAL_2D_OFFSET = offsets;
                    TYPICAL_2D_OFFSET_BLURS = IntStream.range(0, TYPICAL_2D_OFFSET.size()).mapToDouble(i -> GaussianFilter.calculateBlurFromOffset(TYPICAL_2D_OFFSET.get(i), gaussianKernel, maxOffset)).toArray();
                }
            }
        }
        return offsets;
    }

    private static List<int[]> calculateOffsets(int numDimensions, int currentDimension, int[] currentOffsetsPerDimension, double[] gaussianKernel, int maxOffset) {
        ArrayList<int[]> offsets = new ArrayList<int[]>();
        if (currentDimension == numDimensions) {
            offsets.add((int[])currentOffsetsPerDimension.clone());
        } else {
            int i = -maxOffset;
            while (i < gaussianKernel.length - maxOffset) {
                currentOffsetsPerDimension[currentDimension] = i++;
                offsets.addAll(GaussianFilter.calculateOffsets(numDimensions, currentDimension + 1, currentOffsetsPerDimension, gaussianKernel, maxOffset));
            }
        }
        return offsets;
    }

    private static double getBlurFromOffset(int index, int numDimensions, int[] indexIntoGaussianPerDimension, double[] gaussianKernel, int maxOffset) {
        if (numDimensions == 2) {
            return TYPICAL_2D_OFFSET_BLURS[index];
        }
        return GaussianFilter.calculateBlurFromOffset(indexIntoGaussianPerDimension, gaussianKernel, maxOffset);
    }

    private static double calculateBlurFromOffset(int[] indexIntoGaussianPerDimension, double[] gaussianKernel, int maxOffset) {
        double blurFactor = 1.0;
        for (int index : indexIntoGaussianPerDimension) {
            blurFactor *= gaussianKernel[index + maxOffset];
        }
        return blurFactor;
    }

    private static List<BinPositionAndContribution> getPositionsAndContributionPt(int numDimensions, int currentDimension, double[] locationPerDimension, double currentContribution, int[] finalIndexPerDimension, int[] binsPerDimension, int[] offset) {
        ArrayList<BinPositionAndContribution> positions = new ArrayList<BinPositionAndContribution>();
        if (currentDimension == numDimensions) {
            positions.add(new BinPositionAndContribution(GaussianFilter.getPosition(finalIndexPerDimension, binsPerDimension), currentContribution));
        } else {
            int floorOfLocation = (int)locationPerDimension[currentDimension];
            int[] floorLocation = finalIndexPerDimension;
            floorLocation[currentDimension] = floorOfLocation + offset[currentDimension];
            if (floorLocation[currentDimension] >= 0 && floorLocation[currentDimension] < binsPerDimension[currentDimension]) {
                positions.addAll(GaussianFilter.getPositionsAndContributionPt(numDimensions, currentDimension + 1, locationPerDimension, currentContribution, floorLocation, binsPerDimension, offset));
            }
        }
        return positions;
    }

    private static List<BinPositionAndContribution> getPositionsAndContribution(int numDimensions, int currentDimension, double[] minLocationPerDimension, double[] maxLocationPerDimension, double currentContribution, int[] finalIndexPerDimension, int[] binsPerDimension, int[] offset) {
        ArrayList<BinPositionAndContribution> positions = new ArrayList<BinPositionAndContribution>();
        if (currentDimension == numDimensions) {
            positions.add(new BinPositionAndContribution(GaussianFilter.getPosition(finalIndexPerDimension, binsPerDimension), currentContribution));
        } else {
            int stopLocation;
            int floorOfLocation = (int)minLocationPerDimension[currentDimension];
            int[] floorLocation = (int[])finalIndexPerDimension.clone();
            floorLocation[currentDimension] = floorOfLocation + offset[currentDimension];
            if (floorLocation[currentDimension] >= 0 && floorLocation[currentDimension] < binsPerDimension[currentDimension]) {
                positions.addAll(GaussianFilter.getPositionsAndContribution(numDimensions, currentDimension + 1, minLocationPerDimension, maxLocationPerDimension, currentContribution, floorLocation, binsPerDimension, offset));
            }
            int ceilOfLocation = (int)Math.ceil(maxLocationPerDimension[currentDimension]);
            int startLocation = Math.max(floorOfLocation + offset[currentDimension] + 1, 0);
            if (startLocation < (stopLocation = Math.min(ceilOfLocation + offset[currentDimension], binsPerDimension[currentDimension]))) {
                int location = startLocation;
                while (location < stopLocation) {
                    int[] middleLocation = (int[])finalIndexPerDimension.clone();
                    middleLocation[currentDimension] = location++;
                    positions.addAll(GaussianFilter.getPositionsAndContribution(numDimensions, currentDimension + 1, minLocationPerDimension, maxLocationPerDimension, currentContribution, middleLocation, binsPerDimension, offset));
                }
            }
        }
        return positions;
    }

    private static long getPosition(int[] positionPerDimension, int[] binsPerDimension) {
        long retVal = 0L;
        double multiplier = 1.0;
        for (int d = positionPerDimension.length - 1; d >= 0; --d) {
            retVal = (long)((double)retVal + (double)positionPerDimension[d] * multiplier);
            multiplier *= (double)binsPerDimension[d];
        }
        return retVal;
    }

    static {
        valueRangePerDimension = new ValueRange[]{new ValueRange(-180.0, 180.0), new ValueRange(-90.0, 90.0)};
    }

    private static class BinPositionAndContribution {
        private final long position;
        private final double contribution;

        private BinPositionAndContribution(long position, double contribution) {
            this.position = position;
            this.contribution = contribution;
        }
    }

    public static class ValueRange {
        private final double min;
        private final double max;

        public ValueRange(double min, double max) {
            this.min = min;
            this.max = max;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }
    }
}

