/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.kde;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geowave.adapter.raster.RasterUtils;
import org.locationtech.geowave.adapter.raster.adapter.RasterDataAdapter;
import org.locationtech.geowave.adapter.raster.operations.ResizeMRCommand;
import org.locationtech.geowave.analytic.mapreduce.kde.CellSummationCombiner;
import org.locationtech.geowave.analytic.mapreduce.kde.CellSummationReducer;
import org.locationtech.geowave.analytic.mapreduce.kde.DoubleLevelPartitioner;
import org.locationtech.geowave.analytic.mapreduce.kde.GaussianCellMapper;
import org.locationtech.geowave.analytic.mapreduce.kde.IdentityMapper;
import org.locationtech.geowave.analytic.mapreduce.kde.KDECommandLineOptions;
import org.locationtech.geowave.analytic.mapreduce.kde.KDEReducer;
import org.locationtech.geowave.analytic.mapreduce.operations.KdeCommand;
import org.locationtech.geowave.core.cli.api.Operation;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.core.cli.operations.config.options.ConfigOptions;
import org.locationtech.geowave.core.cli.parser.CommandLineOperationParams;
import org.locationtech.geowave.core.cli.parser.ManualOperationParams;
import org.locationtech.geowave.core.cli.parser.OperationParser;
import org.locationtech.geowave.core.geotime.index.SpatialDimensionalityTypeProvider;
import org.locationtech.geowave.core.geotime.index.SpatialOptions;
import org.locationtech.geowave.core.geotime.store.GeotoolsFeatureDataAdapter;
import org.locationtech.geowave.core.geotime.store.query.api.VectorQueryBuilder;
import org.locationtech.geowave.core.geotime.util.ExtractGeometryFilterVisitor;
import org.locationtech.geowave.core.geotime.util.ExtractGeometryFilterVisitorResult;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.store.StoreFactoryOptions;
import org.locationtech.geowave.core.store.adapter.InternalAdapterStore;
import org.locationtech.geowave.core.store.adapter.InternalDataAdapter;
import org.locationtech.geowave.core.store.adapter.PersistentAdapterStore;
import org.locationtech.geowave.core.store.api.DataStore;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.api.Query;
import org.locationtech.geowave.core.store.api.Writer;
import org.locationtech.geowave.core.store.cli.store.AddStoreCommand;
import org.locationtech.geowave.core.store.cli.store.ClearStoreCommand;
import org.locationtech.geowave.core.store.cli.store.DataStorePluginOptions;
import org.locationtech.geowave.core.store.config.ConfigUtils;
import org.locationtech.geowave.core.store.index.IndexStore;
import org.locationtech.geowave.mapreduce.GeoWaveConfiguratorBase;
import org.locationtech.geowave.mapreduce.input.GeoWaveInputFormat;
import org.locationtech.geowave.mapreduce.operations.ConfigHDFSCommand;
import org.locationtech.geowave.mapreduce.output.GeoWaveOutputFormat;
import org.locationtech.geowave.mapreduce.output.GeoWaveOutputKey;
import org.locationtech.jts.geom.Geometry;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KDEJobRunner
extends Configured
implements Tool {
    private static final Logger LOGGER = LoggerFactory.getLogger(KDEJobRunner.class);
    public static final String GEOWAVE_CLASSPATH_JARS = "geowave.classpath.jars";
    private static final String TMP_COVERAGE_SUFFIX = "_tMp_CoVeRaGe";
    protected static int TILE_SIZE = 1;
    public static final String MAX_LEVEL_KEY = "MAX_LEVEL";
    public static final String MIN_LEVEL_KEY = "MIN_LEVEL";
    public static final String COVERAGE_NAME_KEY = "COVERAGE_NAME";
    protected KDECommandLineOptions kdeCommandLineOptions;
    protected DataStorePluginOptions inputDataStoreOptions;
    protected DataStorePluginOptions outputDataStoreOptions;
    protected File configFile;
    protected Index outputIndex;
    public static final String X_MIN_KEY = "X_MIN";
    public static final String X_MAX_KEY = "X_MAX";
    public static final String Y_MIN_KEY = "Y_MIN";
    public static final String Y_MAX_KEY = "Y_MAX";
    public static final String INPUT_CRSCODE_KEY = "INPUT_CRS";
    public static final String OUTPUT_CRSCODE_KEY = "OUTPUT_CRS";

    public KDEJobRunner(KDECommandLineOptions kdeCommandLineOptions, DataStorePluginOptions inputDataStoreOptions, DataStorePluginOptions outputDataStoreOptions, File configFile, Index outputIndex) {
        this.kdeCommandLineOptions = kdeCommandLineOptions;
        this.inputDataStoreOptions = inputDataStoreOptions;
        this.outputDataStoreOptions = outputDataStoreOptions;
        this.configFile = configFile;
        this.outputIndex = outputIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runJob() throws Exception {
        String kdeCoverageName;
        DataStorePluginOptions rasterResizeOutputDataStoreOptions;
        Index[] idxArray;
        Configuration conf = super.getConf();
        if (conf == null) {
            conf = new Configuration();
            this.setConf(conf);
        }
        Index inputPrimaryIndex = null;
        for (Index idx : idxArray = this.inputDataStoreOptions.createDataStore().getIndices()) {
            if (idx == null || this.kdeCommandLineOptions.getIndexName() != null && !this.kdeCommandLineOptions.getIndexName().equals(idx.getName())) continue;
            inputPrimaryIndex = idx;
            break;
        }
        CoordinateReferenceSystem inputIndexCrs = GeometryUtils.getIndexCrs(inputPrimaryIndex);
        String inputCrsCode = GeometryUtils.getCrsCode((CoordinateReferenceSystem)inputIndexCrs);
        Index outputPrimaryIndex = this.outputIndex;
        CoordinateReferenceSystem outputIndexCrs = null;
        String outputCrsCode = null;
        if (outputPrimaryIndex != null) {
            outputIndexCrs = GeometryUtils.getIndexCrs((Index)outputPrimaryIndex);
            outputCrsCode = GeometryUtils.getCrsCode((CoordinateReferenceSystem)outputIndexCrs);
        } else {
            SpatialDimensionalityTypeProvider sdp = new SpatialDimensionalityTypeProvider();
            SpatialOptions so = sdp.createOptions();
            so.setCrs(inputCrsCode);
            outputPrimaryIndex = SpatialDimensionalityTypeProvider.createIndexFromOptions((SpatialOptions)so);
            outputIndexCrs = inputIndexCrs;
            outputCrsCode = inputCrsCode;
        }
        CoordinateSystem cs = outputIndexCrs.getCoordinateSystem();
        CoordinateSystemAxis csx = cs.getAxis(0);
        CoordinateSystemAxis csy = cs.getAxis(1);
        double xMax = csx.getMaximumValue();
        double xMin = csx.getMinimumValue();
        double yMax = csy.getMaximumValue();
        double yMin = csy.getMinimumValue();
        if (xMax == Double.POSITIVE_INFINITY || xMin == Double.NEGATIVE_INFINITY || yMax == Double.POSITIVE_INFINITY || yMin == Double.NEGATIVE_INFINITY) {
            LOGGER.error("Raster KDE resize with raster primary index CRS dimensions min/max equal to positive infinity or negative infinity is not supported");
            throw new RuntimeException("Raster KDE resize with raster primary index CRS dimensions min/max equal to positive infinity or negative infinity is not supported");
        }
        if (this.kdeCommandLineOptions.getTileSize() > 1) {
            rasterResizeOutputDataStoreOptions = this.outputDataStoreOptions;
            Map configOptions = this.outputDataStoreOptions.getOptionsAsMap();
            StoreFactoryOptions options = ConfigUtils.populateOptionsFromList((StoreFactoryOptions)this.outputDataStoreOptions.getFactoryFamily().getDataStoreFactory().createOptionsInstance(), (Map)configOptions);
            options.setGeoWaveNamespace(this.outputDataStoreOptions.getGeoWaveNamespace() + "_tmp");
            this.outputDataStoreOptions = new DataStorePluginOptions(options);
            kdeCoverageName = this.kdeCommandLineOptions.getCoverageName() + TMP_COVERAGE_SUFFIX;
        } else {
            rasterResizeOutputDataStoreOptions = null;
            kdeCoverageName = this.kdeCommandLineOptions.getCoverageName();
        }
        if (this.kdeCommandLineOptions.getHdfsHostPort() == null) {
            Properties configProperties = ConfigOptions.loadProperties((File)this.configFile);
            String hdfsFSUrl = ConfigHDFSCommand.getHdfsUrl((Properties)configProperties);
            this.kdeCommandLineOptions.setHdfsHostPort(hdfsFSUrl);
        }
        GeoWaveConfiguratorBase.setRemoteInvocationParams((String)this.kdeCommandLineOptions.getHdfsHostPort(), (String)this.kdeCommandLineOptions.getJobTrackerOrResourceManHostPort(), (Configuration)conf);
        conf.setInt(MAX_LEVEL_KEY, this.kdeCommandLineOptions.getMaxLevel().intValue());
        conf.setInt(MIN_LEVEL_KEY, this.kdeCommandLineOptions.getMinLevel().intValue());
        conf.set(COVERAGE_NAME_KEY, kdeCoverageName);
        if (this.kdeCommandLineOptions.getCqlFilter() != null) {
            conf.set("CQL_FILTER", this.kdeCommandLineOptions.getCqlFilter());
        }
        conf.setDouble(X_MIN_KEY, xMin);
        conf.setDouble(X_MAX_KEY, xMax);
        conf.setDouble(Y_MIN_KEY, yMin);
        conf.setDouble(Y_MAX_KEY, yMax);
        conf.set(INPUT_CRSCODE_KEY, inputCrsCode);
        conf.set(OUTPUT_CRSCODE_KEY, outputCrsCode);
        this.preJob1Setup(conf);
        Job job = new Job(conf);
        job.setJarByClass(((Object)((Object)this)).getClass());
        this.addJobClasspathDependencies(job, conf);
        job.setJobName(this.getJob1Name());
        job.setMapperClass(this.getJob1Mapper());
        job.setCombinerClass(CellSummationCombiner.class);
        job.setReducerClass(this.getJob1Reducer());
        job.setMapOutputKeyClass(LongWritable.class);
        job.setMapOutputValueClass(DoubleWritable.class);
        job.setOutputKeyClass(DoubleWritable.class);
        job.setOutputValueClass(LongWritable.class);
        job.setInputFormatClass(GeoWaveInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setNumReduceTasks(8);
        job.setSpeculativeExecution(false);
        PersistentAdapterStore adapterStore = this.inputDataStoreOptions.createAdapterStore();
        IndexStore indexStore = this.inputDataStoreOptions.createIndexStore();
        InternalAdapterStore internalAdapterStore = this.inputDataStoreOptions.createInternalAdapterStore();
        short internalAdapterId = internalAdapterStore.getAdapterId(this.kdeCommandLineOptions.getFeatureType());
        DataTypeAdapter adapter = ((InternalDataAdapter)adapterStore.getAdapter((Object)internalAdapterId)).getAdapter();
        VectorQueryBuilder bldr = (VectorQueryBuilder)VectorQueryBuilder.newBuilder().addTypeName(adapter.getTypeName());
        if (this.kdeCommandLineOptions.getIndexName() != null) {
            bldr = (VectorQueryBuilder)bldr.indexName(this.kdeCommandLineOptions.getIndexName());
        }
        GeoWaveInputFormat.setMinimumSplitCount((Configuration)job.getConfiguration(), (Integer)this.kdeCommandLineOptions.getMinSplits());
        GeoWaveInputFormat.setMaximumSplitCount((Configuration)job.getConfiguration(), (Integer)this.kdeCommandLineOptions.getMaxSplits());
        GeoWaveInputFormat.setStoreOptions((Configuration)job.getConfiguration(), (DataStorePluginOptions)this.inputDataStoreOptions);
        if (this.kdeCommandLineOptions.getCqlFilter() != null) {
            Geometry bbox = null;
            if (adapter instanceof GeotoolsFeatureDataAdapter) {
                String geometryAttribute = ((GeotoolsFeatureDataAdapter)adapter).getFeatureType().getGeometryDescriptor().getLocalName();
                Filter filter = ECQL.toFilter((String)this.kdeCommandLineOptions.getCqlFilter());
                ExtractGeometryFilterVisitorResult geoAndCompareOpData = (ExtractGeometryFilterVisitorResult)filter.accept((FilterVisitor)new ExtractGeometryFilterVisitor(GeometryUtils.getDefaultCRS(), geometryAttribute), null);
                bbox = geoAndCompareOpData.getGeometry();
            }
            if (bbox != null && !bbox.equals(GeometryUtils.infinity())) {
                bldr = (VectorQueryBuilder)bldr.constraints(bldr.constraintsFactory().spatialTemporalConstraints().spatialConstraints(bbox).build());
            }
        }
        GeoWaveInputFormat.setQuery((Configuration)conf, (Query)((Query)bldr.build()), (PersistentAdapterStore)adapterStore, (InternalAdapterStore)internalAdapterStore, (IndexStore)indexStore);
        FileSystem fs = null;
        try {
            fs = FileSystem.get((Configuration)conf);
            fs.delete(new Path("/tmp/" + this.inputDataStoreOptions.getGeoWaveNamespace() + "_stats_" + this.kdeCommandLineOptions.getMinLevel() + "_" + this.kdeCommandLineOptions.getMaxLevel() + "_" + this.kdeCommandLineOptions.getCoverageName()), true);
            FileOutputFormat.setOutputPath((Job)job, (Path)new Path("/tmp/" + this.inputDataStoreOptions.getGeoWaveNamespace() + "_stats_" + this.kdeCommandLineOptions.getMinLevel() + "_" + this.kdeCommandLineOptions.getMaxLevel() + "_" + this.kdeCommandLineOptions.getCoverageName() + "/basic"));
            boolean job1Success = job.waitForCompletion(true);
            boolean job2Success = false;
            boolean postJob2Success = false;
            if (job1Success) {
                this.setupEntriesPerLevel(job, conf);
                Job statsReducer = new Job(conf);
                statsReducer.setJarByClass(((Object)((Object)this)).getClass());
                this.addJobClasspathDependencies(statsReducer, conf);
                statsReducer.setJobName(this.getJob2Name());
                statsReducer.setMapperClass(IdentityMapper.class);
                statsReducer.setPartitionerClass(this.getJob2Partitioner());
                statsReducer.setReducerClass(this.getJob2Reducer());
                statsReducer.setNumReduceTasks(this.getJob2NumReducers(this.kdeCommandLineOptions.getMaxLevel() - this.kdeCommandLineOptions.getMinLevel() + 1));
                statsReducer.setMapOutputKeyClass(DoubleWritable.class);
                statsReducer.setMapOutputValueClass(LongWritable.class);
                statsReducer.setOutputKeyClass(this.getJob2OutputKeyClass());
                statsReducer.setOutputValueClass(this.getJob2OutputValueClass());
                statsReducer.setInputFormatClass(SequenceFileInputFormat.class);
                statsReducer.setOutputFormatClass(this.getJob2OutputFormatClass());
                FileInputFormat.setInputPaths((Job)statsReducer, (Path[])new Path[]{new Path("/tmp/" + this.inputDataStoreOptions.getGeoWaveNamespace() + "_stats_" + this.kdeCommandLineOptions.getMinLevel() + "_" + this.kdeCommandLineOptions.getMaxLevel() + "_" + this.kdeCommandLineOptions.getCoverageName() + "/basic")});
                this.setupJob2Output(conf, statsReducer, this.outputDataStoreOptions.getGeoWaveNamespace(), kdeCoverageName, outputPrimaryIndex);
                job2Success = statsReducer.waitForCompletion(true);
                if (job2Success) {
                    postJob2Success = this.postJob2Actions(conf, this.outputDataStoreOptions.getGeoWaveNamespace(), kdeCoverageName);
                }
            } else {
                job2Success = false;
            }
            if (rasterResizeOutputDataStoreOptions != null) {
                ResizeMRCommand resizeCommand = new ResizeMRCommand();
                File configFile = File.createTempFile("temp-config", null);
                ManualOperationParams params = new ManualOperationParams();
                params.getContext().put("properties-file", configFile);
                AddStoreCommand addStore = new AddStoreCommand();
                addStore.setParameters("temp-out");
                addStore.setPluginOptions(this.outputDataStoreOptions);
                addStore.execute((OperationParams)params);
                addStore.setParameters("temp-raster-out");
                addStore.setPluginOptions(rasterResizeOutputDataStoreOptions);
                addStore.execute((OperationParams)params);
                resizeCommand.setParameters("temp-out", "temp-raster-out");
                resizeCommand.getOptions().setInputCoverageName(kdeCoverageName);
                resizeCommand.getOptions().setMinSplits(this.kdeCommandLineOptions.getMinSplits());
                resizeCommand.getOptions().setMaxSplits(this.kdeCommandLineOptions.getMaxSplits());
                resizeCommand.setHdfsHostPort(this.kdeCommandLineOptions.getHdfsHostPort());
                resizeCommand.setJobTrackerOrResourceManHostPort(this.kdeCommandLineOptions.getJobTrackerOrResourceManHostPort());
                resizeCommand.getOptions().setOutputCoverageName(this.kdeCommandLineOptions.getCoverageName());
                resizeCommand.getOptions().setOutputTileSize(this.kdeCommandLineOptions.getTileSize());
                int resizeStatus = ToolRunner.run((Tool)resizeCommand.createRunner((OperationParams)params), (String[])new String[0]);
                if (resizeStatus == 0) {
                    ClearStoreCommand clearCommand = new ClearStoreCommand();
                    clearCommand.setParameters("temp-out");
                    clearCommand.execute((OperationParams)params);
                } else {
                    LOGGER.warn("Resize command error code '" + resizeStatus + "'.  Retaining temporary namespace '" + this.outputDataStoreOptions.getGeoWaveNamespace() + "' with tile size of 1.");
                }
            }
            fs.delete(new Path("/tmp/" + this.inputDataStoreOptions.getGeoWaveNamespace() + "_stats_" + this.kdeCommandLineOptions.getMinLevel() + "_" + this.kdeCommandLineOptions.getMaxLevel() + "_" + this.kdeCommandLineOptions.getCoverageName()), true);
            int n = job1Success && job2Success && postJob2Success ? 0 : 1;
            return n;
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (IOException e) {
                    LOGGER.info(e.getMessage());
                }
            }
        }
    }

    protected void setupEntriesPerLevel(Job job1, Configuration conf) throws IOException {
        for (int l = this.kdeCommandLineOptions.getMinLevel().intValue(); l <= this.kdeCommandLineOptions.getMaxLevel(); ++l) {
            conf.setLong("Entries per level.level" + l, ((CounterGroup)job1.getCounters().getGroup("Entries per level")).findCounter("level " + Long.valueOf(l)).getValue());
        }
    }

    protected void preJob1Setup(Configuration conf) {
    }

    protected boolean postJob2Actions(Configuration conf, String statsNamespace, String coverageName) throws Exception {
        return true;
    }

    protected Class<? extends OutputFormat<?, ?>> getJob2OutputFormatClass() {
        return GeoWaveOutputFormat.class;
    }

    protected Class<?> getJob2OutputKeyClass() {
        return GeoWaveOutputKey.class;
    }

    protected Class<?> getJob2OutputValueClass() {
        return GridCoverage.class;
    }

    protected Class<? extends Reducer<?, ?, ?, ?>> getJob2Reducer() {
        return KDEReducer.class;
    }

    protected Class<? extends Partitioner<?, ?>> getJob2Partitioner() {
        return DoubleLevelPartitioner.class;
    }

    protected int getJob2NumReducers(int numLevels) {
        return numLevels;
    }

    protected Class<? extends Mapper<?, ?, ?, ?>> getJob1Mapper() {
        return GaussianCellMapper.class;
    }

    protected Class<? extends Reducer<?, ?, ?, ?>> getJob1Reducer() {
        return CellSummationReducer.class;
    }

    protected String getJob2Name() {
        return this.inputDataStoreOptions.getGeoWaveNamespace() + "(" + this.kdeCommandLineOptions.getCoverageName() + ") levels " + this.kdeCommandLineOptions.getMinLevel() + "-" + this.kdeCommandLineOptions.getMaxLevel() + " Ingest";
    }

    protected String getJob1Name() {
        return this.inputDataStoreOptions.getGeoWaveNamespace() + "(" + this.kdeCommandLineOptions.getCoverageName() + ") levels " + this.kdeCommandLineOptions.getMinLevel() + "-" + this.kdeCommandLineOptions.getMaxLevel() + " Calculation";
    }

    protected void setupJob2Output(Configuration conf, Job statsReducer, String statsNamespace, String coverageName, Index index) throws Exception {
        RasterDataAdapter adapter = RasterUtils.createDataAdapterTypeDouble((String)coverageName, (int)3, (int)TILE_SIZE, (double[])KDEReducer.MINS_PER_BAND, (double[])KDEReducer.MAXES_PER_BAND, (String[])KDEReducer.NAME_PER_BAND, null);
        this.setup(statsReducer, statsNamespace, (DataTypeAdapter<?>)adapter, index);
    }

    protected void setup(Job job, String namespace, DataTypeAdapter<?> adapter, Index index) throws IOException {
        GeoWaveOutputFormat.setStoreOptions((Configuration)job.getConfiguration(), (DataStorePluginOptions)this.outputDataStoreOptions);
        GeoWaveOutputFormat.addDataAdapter((Configuration)job.getConfiguration(), adapter);
        GeoWaveOutputFormat.addIndex((Configuration)job.getConfiguration(), (Index)index);
        DataStore dataStore = this.outputDataStoreOptions.createDataStore();
        dataStore.addType(adapter, new Index[]{index});
        Writer writer = dataStore.createWriter(adapter.getTypeName());
        writer.close();
    }

    public static void main(String[] args) throws Exception {
        ConfigOptions opts = new ConfigOptions();
        OperationParser parser = new OperationParser();
        parser.addAdditionalObject((Object)opts);
        KdeCommand command = new KdeCommand();
        CommandLineOperationParams params = parser.parse((Operation)command, args);
        opts.prepare((OperationParams)params);
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)command.createRunner((OperationParams)params), (String[])args);
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        return this.runJob();
    }

    protected void addJobClasspathDependencies(Job job, Configuration conf) throws IOException, URISyntaxException {
        String[] jars = conf.getTrimmedStrings(GEOWAVE_CLASSPATH_JARS);
        if (jars != null) {
            for (String jarPath : jars) {
                job.addArchiveToClassPath(new Path(new URI(jarPath)));
            }
        }
    }
}

