/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.kde;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Reducer;
import org.locationtech.geowave.adapter.raster.RasterUtils;
import org.locationtech.geowave.analytic.mapreduce.kde.GaussianFilter;
import org.locationtech.geowave.analytic.mapreduce.kde.KDEJobRunner;
import org.locationtech.geowave.core.geotime.index.api.SpatialIndexBuilder;
import org.locationtech.geowave.core.index.FloatCompareUtils;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.mapreduce.JobContextIndexStore;
import org.locationtech.geowave.mapreduce.output.GeoWaveOutputKey;
import org.opengis.coverage.grid.GridCoverage;

public class KDEReducer
extends Reducer<DoubleWritable, LongWritable, GeoWaveOutputKey, GridCoverage> {
    private static final double WEIGHT_EPSILON = 2.22E-14;
    public static final int NUM_BANDS = 3;
    protected static final String[] NAME_PER_BAND = new String[]{"Weight", "Normalized", "Percentile"};
    protected static final double[] MINS_PER_BAND = new double[]{0.0, 0.0, 0.0};
    protected static final double[] MAXES_PER_BAND = new double[]{Double.MAX_VALUE, 1.0, 1.0};
    private double max = -1.7976931348623157E308;
    private long currentKey = 0L;
    private long totalKeys;
    private int minLevels;
    private int maxLevels;
    private int numLevels;
    private int level;
    private int numYPosts;
    private int numXTiles;
    private int numYTiles;
    private String coverageName;
    protected List<String> indexList;
    protected GaussianFilter.ValueRange[] valueRangePerDimension;
    protected String crsCode;
    protected double prevValue = -1.0;
    protected double prevPct = 0.0;

    protected void reduce(DoubleWritable key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        if (key.get() < 0.0) {
            double prevMax = -key.get();
            if (prevMax > this.max) {
                this.max = prevMax;
            }
        } else {
            double percentile;
            double value = key.get();
            double normalizedValue = value / this.max;
            if (FloatCompareUtils.checkDoublesEqual((double)this.prevValue, (double)value, (double)2.22E-14)) {
                percentile = this.prevPct;
            } else {
                this.prevPct = percentile = ((double)this.currentKey + 1.0) / (double)this.totalKeys;
                this.prevValue = value;
            }
            for (LongWritable v : values) {
                long cellIndex = v.get() / (long)this.numLevels;
                TileInfo tileInfo = this.fromCellIndexToTileInfo(cellIndex);
                WritableRaster raster = RasterUtils.createRasterTypeDouble((int)3, (int)KDEJobRunner.TILE_SIZE);
                raster.setSample(tileInfo.x, tileInfo.y, 0, key.get());
                raster.setSample(tileInfo.x, tileInfo.y, 1, normalizedValue);
                raster.setSample(tileInfo.x, tileInfo.y, 2, percentile);
                context.write((Object)new GeoWaveOutputKey(this.coverageName, this.indexList.toArray(new String[0])), (Object)RasterUtils.createCoverageTypeDouble((String)this.coverageName, (double)tileInfo.tileWestLon, (double)tileInfo.tileEastLon, (double)tileInfo.tileSouthLat, (double)tileInfo.tileNorthLat, (double[])MINS_PER_BAND, (double[])MAXES_PER_BAND, (String[])NAME_PER_BAND, (WritableRaster)raster, (String)this.crsCode));
                ++this.currentKey;
            }
        }
    }

    @SuppressFBWarnings(value={"INT_BAD_REM_BY_1"}, justification="The calculation is appropriate if we ever want to vary to tile size.")
    private TileInfo fromCellIndexToTileInfo(long index) {
        int xPost = (int)(index / (long)this.numYPosts);
        int yPost = (int)(index % (long)this.numYPosts);
        int xTile = xPost / KDEJobRunner.TILE_SIZE;
        int yTile = yPost / KDEJobRunner.TILE_SIZE;
        int x = xPost % KDEJobRunner.TILE_SIZE;
        int y = yPost % KDEJobRunner.TILE_SIZE;
        double xMin = this.valueRangePerDimension[0].getMin();
        double xMax = this.valueRangePerDimension[0].getMax();
        double yMin = this.valueRangePerDimension[1].getMin();
        double yMax = this.valueRangePerDimension[1].getMax();
        double crsWidth = xMax - xMin;
        double crsHeight = yMax - yMin;
        double tileWestLon = (double)xTile * crsWidth / (double)this.numXTiles + xMin;
        double tileSouthLat = (double)yTile * crsHeight / (double)this.numYTiles + yMin;
        double tileEastLon = tileWestLon + crsWidth / (double)this.numXTiles;
        double tileNorthLat = tileSouthLat + crsHeight / (double)this.numYTiles;
        return new TileInfo(tileWestLon, tileEastLon, tileSouthLat, tileNorthLat, x, KDEJobRunner.TILE_SIZE - y - 1);
    }

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.minLevels = context.getConfiguration().getInt("MIN_LEVEL", 1);
        this.maxLevels = context.getConfiguration().getInt("MAX_LEVEL", 25);
        this.coverageName = context.getConfiguration().get("COVERAGE_NAME", "");
        this.valueRangePerDimension = new GaussianFilter.ValueRange[]{new GaussianFilter.ValueRange(context.getConfiguration().getDouble("X_MIN", -180.0), context.getConfiguration().getDouble("X_MAX", 180.0)), new GaussianFilter.ValueRange(context.getConfiguration().getDouble("Y_MIN", -90.0), context.getConfiguration().getDouble("Y_MAX", 90.0))};
        this.crsCode = context.getConfiguration().get("OUTPUT_CRS");
        this.numLevels = this.maxLevels - this.minLevels + 1;
        this.level = context.getConfiguration().getInt("mapred.task.partition", 0) + this.minLevels;
        this.numXTiles = (int)Math.pow(2.0, this.level + 1);
        this.numYTiles = (int)Math.pow(2.0, this.level);
        this.numYPosts = this.numYTiles * KDEJobRunner.TILE_SIZE;
        this.totalKeys = context.getConfiguration().getLong("Entries per level.level" + this.level, 10L);
        Index[] indices = JobContextIndexStore.getIndices((JobContext)context);
        this.indexList = new ArrayList<String>();
        if (indices != null && indices.length > 0) {
            for (Index index : indices) {
                this.indexList.add(index.getName());
            }
        } else {
            this.indexList.add(new SpatialIndexBuilder().createIndex().getName());
        }
    }

    private static final class TileInfo {
        private final double tileWestLon;
        private final double tileEastLon;
        private final double tileSouthLat;
        private final double tileNorthLat;
        private final int x;
        private final int y;

        public TileInfo(double tileWestLon, double tileEastLon, double tileSouthLat, double tileNorthLat, int x, int y) {
            this.tileWestLon = tileWestLon;
            this.tileEastLon = tileEastLon;
            this.tileSouthLat = tileSouthLat;
            this.tileNorthLat = tileNorthLat;
            this.x = x;
            this.y = y;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            long temp = Double.doubleToLongBits(this.tileEastLon);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.tileNorthLat);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.tileSouthLat);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.tileWestLon);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TileInfo other = (TileInfo)obj;
            if (Double.doubleToLongBits(this.tileEastLon) != Double.doubleToLongBits(other.tileEastLon)) {
                return false;
            }
            if (Double.doubleToLongBits(this.tileNorthLat) != Double.doubleToLongBits(other.tileNorthLat)) {
                return false;
            }
            if (Double.doubleToLongBits(this.tileSouthLat) != Double.doubleToLongBits(other.tileSouthLat)) {
                return false;
            }
            return Double.doubleToLongBits(this.tileWestLon) == Double.doubleToLongBits(other.tileWestLon);
        }
    }
}

