/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.kde;

import java.io.IOException;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.locationtech.geowave.analytic.mapreduce.kde.CellCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapContextCellCounter
implements CellCounter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapContextCellCounter.class);
    private final Mapper.Context context;
    private final long minLevel;
    private final long maxLevel;
    private final long numLevels;
    private final long level;

    public MapContextCellCounter(Mapper.Context context, long level, long minLevel, long maxLevel) {
        this.context = context;
        this.level = level;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
        this.numLevels = maxLevel - minLevel + 1L;
    }

    @Override
    public void increment(long cellId, double weight) {
        if (weight > 0.0) {
            try {
                this.context.write((Object)new LongWritable(this.getCellId(cellId)), (Object)new DoubleWritable(weight));
            }
            catch (IOException | InterruptedException e) {
                LOGGER.error("Unable to write", (Throwable)e);
            }
        }
    }

    protected long getCellId(long cellId) {
        return cellId * this.numLevels + (this.level - this.minLevel);
    }
}

