/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.kde.compare;

import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Arrays;
import javax.vecmath.Point2d;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Reducer;
import org.locationtech.geowave.adapter.raster.RasterUtils;
import org.locationtech.geowave.analytic.mapreduce.kde.compare.ComparisonCellData;
import org.locationtech.geowave.core.geotime.index.api.SpatialIndexBuilder;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.mapreduce.JobContextIndexStore;
import org.locationtech.geowave.mapreduce.output.GeoWaveOutputKey;
import org.opengis.coverage.grid.GridCoverage;

public class ComparisonAccumuloStatsReducer
extends Reducer<ComparisonCellData, LongWritable, GeoWaveOutputKey, GridCoverage> {
    public static final int NUM_BANDS = 4;
    protected static final String[] NAME_PER_BAND = new String[]{"Summer", "Winter", "Combined", "Combined Percentile"};
    protected static final double[] MINS_PER_BAND = new double[]{0.0, 0.0, -1.0, 0.0};
    protected static final double[] MAXES_PER_BAND = new double[]{1.0, 1.0, 1.0, 1.0};
    private static final int TILE_SIZE = 1;
    private long totalKeys = 0L;
    private long currentKey;
    private int minLevels;
    private int maxLevels;
    private int numLevels;
    private int level;
    private int numXPosts;
    private int numYPosts;
    private String coverageName;
    protected String[] indexNames;

    protected void reduce(ComparisonCellData key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        double percentile = ((double)this.currentKey + 1.0) / (double)this.totalKeys;
        for (LongWritable v : values) {
            long cellIndex = v.get() / (long)this.numLevels;
            Point2d[] bbox = this.fromIndexToLL_UR(cellIndex);
            WritableRaster raster = RasterUtils.createRasterTypeDouble((int)4, (int)1);
            raster.setSample(0, 0, 0, key.getSummerPercentile());
            raster.setSample(0, 0, 1, key.getWinterPercentile());
            raster.setSample(0, 0, 2, key.getCombinedPercentile());
            raster.setSample(0, 0, 3, percentile);
            context.write((Object)new GeoWaveOutputKey(this.coverageName, this.indexNames), (Object)RasterUtils.createCoverageTypeDouble((String)this.coverageName, (double)bbox[0].x, (double)bbox[1].x, (double)bbox[0].y, (double)bbox[1].y, (double[])MINS_PER_BAND, (double[])MAXES_PER_BAND, (String[])NAME_PER_BAND, (WritableRaster)raster));
            ++this.currentKey;
        }
    }

    private Point2d[] fromIndexToLL_UR(long index) {
        double llLon = Math.floor((double)index / (double)this.numYPosts) * 360.0 / (double)this.numXPosts - 180.0;
        double llLat = (double)(index % (long)this.numYPosts) * 180.0 / (double)this.numYPosts - 90.0;
        double urLon = llLon + 360.0 / (double)this.numXPosts;
        double urLat = llLat + 180.0 / (double)this.numYPosts;
        return new Point2d[]{new Point2d(llLon, llLat), new Point2d(urLon, urLat)};
    }

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.minLevels = context.getConfiguration().getInt("MIN_LEVEL", 1);
        this.maxLevels = context.getConfiguration().getInt("MAX_LEVEL", 25);
        this.coverageName = context.getConfiguration().get("COVERAGE_NAME", "");
        this.numLevels = this.maxLevels - this.minLevels + 1;
        this.level = context.getConfiguration().getInt("mapred.task.partition", 0) + this.minLevels;
        this.numXPosts = (int)Math.pow(2.0, this.level + 1);
        this.numYPosts = (int)Math.pow(2.0, this.level);
        this.totalKeys = context.getConfiguration().getLong("Entries per level.level" + this.level, 10L);
        Index[] indices = JobContextIndexStore.getIndices((JobContext)context);
        this.indexNames = indices != null && indices.length > 0 ? (String[])Arrays.stream(indices).map(i -> i.getName()).toArray(String[]::new) : new String[]{new SpatialIndexBuilder().createIndex().getName()};
    }
}

