/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.kde.compare;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.io.WritableComparable;

public class ComparisonCellData
implements WritableComparable<ComparisonCellData> {
    private double summerPercentile;
    private double winterPercentile;

    public ComparisonCellData() {
    }

    public ComparisonCellData(double summerPercentile, double winterPercentile) {
        this.summerPercentile = summerPercentile;
        this.winterPercentile = winterPercentile;
    }

    public void readFields(DataInput input) throws IOException {
        this.summerPercentile = input.readDouble();
        this.winterPercentile = input.readDouble();
    }

    public void write(DataOutput output) throws IOException {
        output.writeDouble(this.summerPercentile);
        output.writeDouble(this.winterPercentile);
    }

    public double getSummerPercentile() {
        return this.summerPercentile;
    }

    public double getWinterPercentile() {
        return this.winterPercentile;
    }

    public double getCombinedPercentile() {
        return ComparisonCellData.applyCombinationFunction(this.summerPercentile, this.winterPercentile);
    }

    public int compareTo(ComparisonCellData other) {
        double combined = this.getCombinedPercentile();
        return Double.compare(combined, other.getCombinedPercentile());
    }

    public boolean equals(Object val) {
        if (!(val instanceof ComparisonCellData)) {
            return false;
        }
        if (val == this) {
            return true;
        }
        return this.compareTo((ComparisonCellData)val) == 0;
    }

    public int hashCode() {
        return new HashCodeBuilder(2003, 6373).append(this.summerPercentile).append(this.winterPercentile).toHashCode();
    }

    private static double applyCombinationFunction(double summerPercentile, double winterPercentile) {
        return summerPercentile - winterPercentile;
    }
}

