/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.kde.compare;

import java.io.IOException;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Reducer;

public class ComparisonCellDataReducer
extends Reducer<DoubleWritable, LongWritable, LongWritable, DoubleWritable> {
    private long totalKeys = 0L;
    private long currentKey = 0L;
    private int level;

    protected void reduce(DoubleWritable key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        double percentile = ((double)this.currentKey + 1.0) / (double)this.totalKeys;
        for (LongWritable v : values) {
            context.write((Object)v, (Object)new DoubleWritable(percentile));
            ++this.currentKey;
        }
    }

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        int minLevel = context.getConfiguration().getInt("MIN_LEVEL", 1);
        int maxLevel = context.getConfiguration().getInt("MAX_LEVEL", 25);
        this.level = context.getConfiguration().getInt("mapred.task.partition", 0) + minLevel;
        boolean isWinter = false;
        if (this.level > maxLevel) {
            this.level -= maxLevel - minLevel + 1;
            isWinter = true;
        }
        this.totalKeys = context.getConfiguration().getLong("Entries per level (" + (isWinter ? "winter" : "summer") + ", " + this.level + ")", 10L);
    }
}

