/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.kde.compare;

import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Reducer;
import org.locationtech.geowave.analytic.mapreduce.kde.CellSummationReducer;

public class ComparisonCellSummationReducer
extends CellSummationReducer {
    @Override
    protected void collectStats(LongWritable key, double sum, Reducer.Context context) {
        long positiveKey = key.get();
        boolean isWinter = false;
        if (positiveKey < 0L) {
            positiveKey = -positiveKey - 1L;
            isWinter = true;
        }
        long level = positiveKey % (long)this.numLevels + (long)this.minLevel;
        context.getCounter("Entries per level (" + (isWinter ? "winter" : "summer") + ")", "level " + Long.toString(level)).increment(1L);
    }
}

