/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.kde.compare;

import java.io.IOException;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Reducer;
import org.locationtech.geowave.analytic.mapreduce.kde.compare.ComparisonCellData;

public class ComparisonCombiningStatsReducer
extends Reducer<LongWritable, DoubleWritable, ComparisonCellData, LongWritable> {
    protected int minLevel;
    protected int maxLevel;
    protected int numLevels;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        this.minLevel = context.getConfiguration().getInt("MIN_LEVEL", 1);
        this.maxLevel = context.getConfiguration().getInt("MAX_LEVEL", 25);
        this.numLevels = this.maxLevel - this.minLevel + 1;
        super.setup(context);
    }

    public void reduce(LongWritable key, Iterable<DoubleWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        double summer = 0.0;
        double winter = 0.0;
        for (DoubleWritable v : values) {
            if (v.get() < 0.0) {
                winter = -v.get();
                continue;
            }
            summer = v.get();
        }
        context.write((Object)new ComparisonCellData(summer, winter), (Object)key);
        this.collectStats(key.get(), context);
    }

    protected void collectStats(long key, Reducer.Context context) {
        long level = key % (long)this.numLevels + (long)this.minLevel;
        context.getCounter("Entries per level", "level " + Long.toString(level)).increment(1L);
    }
}

