/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.kde.compare;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.mapreduce.Mapper;
import org.locationtech.geowave.analytic.mapreduce.kde.GaussianCellMapper;
import org.locationtech.geowave.analytic.mapreduce.kde.GaussianFilter;
import org.locationtech.geowave.analytic.mapreduce.kde.compare.NegativeCellIdCounter;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;

public class ComparisonGaussianCellMapper
extends GaussianCellMapper {
    protected static final String TIME_ATTRIBUTE_KEY = "TIME_ATTRIBUTE";
    private String timeAttribute;
    private final Map<Integer, GaussianCellMapper.LevelStore> winterLevelStoreMap = new HashMap<Integer, GaussianCellMapper.LevelStore>();

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.timeAttribute = context.getConfiguration().get(TIME_ATTRIBUTE_KEY);
    }

    @Override
    protected void populateLevelStore(Mapper.Context context, int numXPosts, int numYPosts, int level) {
        super.populateLevelStore(context, numXPosts, numYPosts, level);
        this.winterLevelStoreMap.put(level, new GaussianCellMapper.LevelStore(numXPosts, numYPosts, new NegativeCellIdCounter(context, level, this.minLevel, this.maxLevel)));
    }

    @Override
    protected void incrementLevelStore(int level, Point pt, SimpleFeature feature, GaussianFilter.ValueRange[] valueRangePerDimension) {
        Object obj = feature.getAttribute(this.timeAttribute);
        if (obj != null && obj instanceof Date) {
            double contribution = 0.0;
            GaussianCellMapper.LevelStore levelStore = null;
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)obj);
            int featureMonth = cal.get(2);
            if (featureMonth < 3) {
                Calendar baseDate = Calendar.getInstance();
                baseDate.set(cal.get(1), 0, 0, 0, 0, 0);
                double deltaTime = cal.getTime().getTime() - baseDate.getTime().getTime();
                Calendar maxDate = Calendar.getInstance();
                maxDate.set(cal.get(1), 3, 0, 0, 0, 0);
                double normalizedTime = deltaTime * 3.0 / (double)(maxDate.getTimeInMillis() - baseDate.getTimeInMillis());
                contribution = Math.pow(Math.E, -(normalizedTime * normalizedTime));
                levelStore = this.winterLevelStoreMap.get(level);
            } else if (featureMonth > 8) {
                Calendar baseDate = Calendar.getInstance();
                baseDate.set(cal.get(1) + 1, 0, 0, 0, 0, 0);
                double deltaTime = baseDate.getTime().getTime() - cal.getTime().getTime();
                Calendar minDate = Calendar.getInstance();
                minDate.set(cal.get(1), 9, 0, 0, 0, 0);
                double normalizedTime = deltaTime * 3.0 / (double)(baseDate.getTimeInMillis() - minDate.getTimeInMillis());
                contribution = Math.pow(Math.E, -(normalizedTime * normalizedTime));
                levelStore = this.winterLevelStoreMap.get(level);
            } else if (featureMonth == 3 || featureMonth == 8) {
                Calendar maxDate = Calendar.getInstance();
                maxDate.set(cal.get(1), featureMonth + 1, 0, 0, 0, 0);
                Calendar minDate = Calendar.getInstance();
                minDate.set(cal.get(1), featureMonth, 0, 0, 0, 0);
                double deltaTime = featureMonth == 3 ? (double)(maxDate.getTime().getTime() - cal.getTime().getTime()) : (double)(cal.getTime().getTime() - minDate.getTime().getTime());
                double normalizedTime = deltaTime * 3.0 / (double)(maxDate.getTimeInMillis() - minDate.getTimeInMillis());
                contribution = Math.pow(Math.E, -(normalizedTime * normalizedTime));
                levelStore = (GaussianCellMapper.LevelStore)this.levelStoreMap.get(level);
            } else {
                contribution = 1.0;
                levelStore = (GaussianCellMapper.LevelStore)this.levelStoreMap.get(level);
            }
            GaussianFilter.incrementPt(pt.getY(), pt.getX(), levelStore.counter, levelStore.numXPosts, levelStore.numYPosts, contribution, valueRangePerDimension);
        }
    }
}

