/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.kde.compare;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.locationtech.geowave.adapter.raster.RasterUtils;
import org.locationtech.geowave.analytic.mapreduce.kde.KDECommandLineOptions;
import org.locationtech.geowave.analytic.mapreduce.kde.KDEJobRunner;
import org.locationtech.geowave.analytic.mapreduce.kde.compare.ComparisonAccumuloStatsReducer;
import org.locationtech.geowave.analytic.mapreduce.kde.compare.ComparisonCellData;
import org.locationtech.geowave.analytic.mapreduce.kde.compare.ComparisonCellDataReducer;
import org.locationtech.geowave.analytic.mapreduce.kde.compare.ComparisonCellLevelPartitioner;
import org.locationtech.geowave.analytic.mapreduce.kde.compare.ComparisonCellSummationReducer;
import org.locationtech.geowave.analytic.mapreduce.kde.compare.ComparisonCombiningStatsMapper;
import org.locationtech.geowave.analytic.mapreduce.kde.compare.ComparisonCombiningStatsReducer;
import org.locationtech.geowave.analytic.mapreduce.kde.compare.ComparisonCommandLineOptions;
import org.locationtech.geowave.analytic.mapreduce.kde.compare.ComparisonDoubleLevelPartitioner;
import org.locationtech.geowave.analytic.mapreduce.kde.compare.ComparisonGaussianCellMapper;
import org.locationtech.geowave.analytic.mapreduce.kde.compare.ComparisonIdentityMapper;
import org.locationtech.geowave.analytic.mapreduce.operations.KdeCommand;
import org.locationtech.geowave.core.cli.api.Operation;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.core.cli.operations.config.options.ConfigOptions;
import org.locationtech.geowave.core.cli.parser.CommandLineOperationParams;
import org.locationtech.geowave.core.cli.parser.OperationParser;
import org.locationtech.geowave.core.geotime.index.SpatialDimensionalityTypeProvider;
import org.locationtech.geowave.core.geotime.index.SpatialOptions;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.cli.store.DataStorePluginOptions;
import org.locationtech.geowave.mapreduce.output.GeoWaveOutputFormat;
import org.locationtech.geowave.mapreduce.output.GeoWaveOutputKey;
import org.opengis.feature.simple.SimpleFeature;

public class ComparisonStatsJobRunner
extends KDEJobRunner {
    private final String timeAttribute;

    public ComparisonStatsJobRunner(ComparisonCommandLineOptions inputOptions, KDECommandLineOptions kdeCommandLineOptions, DataStorePluginOptions inputDataStoreOptions, DataStorePluginOptions outputDataStoreOptions, File configFile, Index outputIndex) {
        super(kdeCommandLineOptions, inputDataStoreOptions, outputDataStoreOptions, configFile, outputIndex);
        this.timeAttribute = inputOptions.getTimeAttribute();
    }

    public static void main(String[] args) throws Exception {
        ConfigOptions opts = new ConfigOptions();
        ComparisonCommandLineOptions comparisonOptions = new ComparisonCommandLineOptions();
        OperationParser parser = new OperationParser();
        parser.addAdditionalObject((Object)opts);
        parser.addAdditionalObject((Object)comparisonOptions);
        KdeCommand kdeCommand = new KdeCommand();
        CommandLineOperationParams params = parser.parse((Operation)kdeCommand, args);
        opts.prepare((OperationParams)params);
        File configFile = (File)params.getContext().get("properties-file");
        kdeCommand.createRunner((OperationParams)params);
        ComparisonStatsJobRunner runner = new ComparisonStatsJobRunner(comparisonOptions, kdeCommand.getKdeOptions(), kdeCommand.getInputStoreOptions(), kdeCommand.getOutputStoreOptions(), configFile, null);
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)runner, (String[])args);
        System.exit(res);
    }

    @Override
    protected void preJob1Setup(Configuration conf) {
        super.preJob1Setup(conf);
        conf.set("TIME_ATTRIBUTE", this.timeAttribute);
    }

    @Override
    protected boolean postJob2Actions(Configuration conf, String statsNamespace, String coverageName) throws Exception {
        try (FileSystem fs = FileSystem.get((Configuration)conf);){
            fs.delete(new Path("/tmp/" + this.inputDataStoreOptions.getGeoWaveNamespace() + "_stats_" + this.kdeCommandLineOptions.getMinLevel() + "_" + this.kdeCommandLineOptions.getMaxLevel() + "_" + this.kdeCommandLineOptions.getCoverageName() + "/basic"), true);
            Job combiner = new Job(conf);
            combiner.setJarByClass(((Object)((Object)this)).getClass());
            combiner.setJobName(this.inputDataStoreOptions.getGeoWaveNamespace() + "(" + this.kdeCommandLineOptions.getCoverageName() + ") levels " + this.kdeCommandLineOptions.getMinLevel() + "-" + this.kdeCommandLineOptions.getMaxLevel() + " combining seasons");
            combiner.setMapperClass(ComparisonCombiningStatsMapper.class);
            combiner.setReducerClass(ComparisonCombiningStatsReducer.class);
            combiner.setMapOutputKeyClass(LongWritable.class);
            combiner.setMapOutputValueClass(DoubleWritable.class);
            combiner.setOutputKeyClass(ComparisonCellData.class);
            combiner.setOutputValueClass(LongWritable.class);
            combiner.setInputFormatClass(SequenceFileInputFormat.class);
            combiner.setOutputFormatClass(SequenceFileOutputFormat.class);
            FileOutputFormat.setOutputPath((Job)combiner, (Path)new Path("/tmp/" + this.inputDataStoreOptions.getGeoWaveNamespace() + "_stats_" + this.kdeCommandLineOptions.getMinLevel() + "_" + this.kdeCommandLineOptions.getMaxLevel() + "_" + this.kdeCommandLineOptions.getCoverageName() + "/combined_pct"));
            FileInputFormat.setInputPaths((Job)combiner, (Path[])new Path[]{new Path("/tmp/" + this.inputDataStoreOptions.getGeoWaveNamespace() + "_stats_" + this.kdeCommandLineOptions.getMinLevel() + "_" + this.kdeCommandLineOptions.getMaxLevel() + "_" + this.kdeCommandLineOptions.getCoverageName() + "/percentiles")});
            if (combiner.waitForCompletion(true)) {
                fs.delete(new Path("/tmp/" + this.inputDataStoreOptions.getGeoWaveNamespace() + "_stats_" + this.kdeCommandLineOptions.getMinLevel() + "_" + this.kdeCommandLineOptions.getMaxLevel() + "_" + this.kdeCommandLineOptions.getCoverageName() + "/percentiles"), true);
                for (int l = this.kdeCommandLineOptions.getMinLevel().intValue(); l <= this.kdeCommandLineOptions.getMaxLevel(); ++l) {
                    conf.setLong("Entries per level.level" + l, ((CounterGroup)combiner.getCounters().getGroup("Entries per level")).findCounter("level " + Long.valueOf(l)).getValue());
                }
                Job ingester = new Job(conf);
                ingester.setJarByClass(((Object)((Object)this)).getClass());
                ingester.setJobName(this.inputDataStoreOptions.getGeoWaveNamespace() + "(" + this.kdeCommandLineOptions.getCoverageName() + ") levels " + this.kdeCommandLineOptions.getMinLevel() + "-" + this.kdeCommandLineOptions + " Ingest");
                ingester.setMapperClass(ComparisonIdentityMapper.class);
                ingester.setPartitionerClass(ComparisonCellLevelPartitioner.class);
                ingester.setReducerClass(ComparisonAccumuloStatsReducer.class);
                ingester.setNumReduceTasks(this.kdeCommandLineOptions.getMaxLevel() - this.kdeCommandLineOptions.getMinLevel() + 1);
                ingester.setMapOutputKeyClass(ComparisonCellData.class);
                ingester.setMapOutputValueClass(LongWritable.class);
                ingester.setOutputKeyClass(GeoWaveOutputKey.class);
                ingester.setOutputValueClass(SimpleFeature.class);
                ingester.setInputFormatClass(SequenceFileInputFormat.class);
                ingester.setOutputFormatClass(GeoWaveOutputFormat.class);
                FileInputFormat.setInputPaths((Job)ingester, (Path[])new Path[]{new Path("/tmp/" + this.inputDataStoreOptions.getGeoWaveNamespace() + "_stats_" + this.kdeCommandLineOptions.getMinLevel() + "_" + this.kdeCommandLineOptions.getMaxLevel() + "_" + this.kdeCommandLineOptions.getCoverageName() + "/combined_pct")});
                GeoWaveOutputFormat.setStoreOptions((Configuration)conf, (DataStorePluginOptions)this.outputDataStoreOptions);
                this.setup(ingester, statsNamespace, (DataTypeAdapter<?>)RasterUtils.createDataAdapterTypeDouble((String)coverageName, (int)4, (int)1, (double[])ComparisonAccumuloStatsReducer.MINS_PER_BAND, (double[])ComparisonAccumuloStatsReducer.MAXES_PER_BAND, (String[])ComparisonAccumuloStatsReducer.NAME_PER_BAND, null), SpatialDimensionalityTypeProvider.createIndexFromOptions((SpatialOptions)new SpatialOptions()));
                boolean bl = ingester.waitForCompletion(true);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    protected Class getJob2OutputFormatClass() {
        return SequenceFileOutputFormat.class;
    }

    protected Class getJob2OutputKeyClass() {
        return LongWritable.class;
    }

    protected Class getJob2OutputValueClass() {
        return DoubleWritable.class;
    }

    protected Class getJob2Reducer() {
        return ComparisonCellDataReducer.class;
    }

    @Override
    protected int getJob2NumReducers(int numLevels) {
        return super.getJob2NumReducers(numLevels) * 2;
    }

    protected Class getJob1Mapper() {
        return ComparisonGaussianCellMapper.class;
    }

    protected Class getJob1Reducer() {
        return ComparisonCellSummationReducer.class;
    }

    protected Class getJob2Partitioner() {
        return ComparisonDoubleLevelPartitioner.class;
    }

    @Override
    protected String getJob2Name() {
        return this.inputDataStoreOptions.getGeoWaveNamespace() + "(" + this.kdeCommandLineOptions.getCoverageName() + ") levels " + this.kdeCommandLineOptions.getMinLevel() + "-" + this.kdeCommandLineOptions.getMaxLevel() + " Percentile Calculation by season";
    }

    @Override
    protected String getJob1Name() {
        return super.getJob1Name() + " initial calculation by season";
    }

    @Override
    protected void setupEntriesPerLevel(Job job1, Configuration conf) throws IOException {
        for (int l = this.kdeCommandLineOptions.getMinLevel().intValue(); l <= this.kdeCommandLineOptions.getMaxLevel(); ++l) {
            conf.setLong("Entries per level (winter, " + l + ")", ((CounterGroup)job1.getCounters().getGroup("Entries per level (winter)")).findCounter("level " + Long.valueOf(l)).getValue());
            conf.setLong("Entries per level (summer, " + l + ")", ((CounterGroup)job1.getCounters().getGroup("Entries per level (summer)")).findCounter("level " + Long.valueOf(l)).getValue());
        }
    }

    @Override
    protected void setupJob2Output(Configuration conf, Job statsReducer, String statsNamespace, String coverageName, Index index) throws Exception {
        FileOutputFormat.setOutputPath((Job)statsReducer, (Path)new Path("/tmp/" + this.inputDataStoreOptions.getGeoWaveNamespace() + "_stats_" + this.kdeCommandLineOptions.getMinLevel() + "_" + this.kdeCommandLineOptions.getMaxLevel() + "_" + this.kdeCommandLineOptions.getCoverageName() + "/percentiles"));
    }
}

