/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.kmeans;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.locationtech.geowave.analytic.AnalyticItemWrapper;
import org.locationtech.geowave.analytic.AnalyticItemWrapperFactory;
import org.locationtech.geowave.analytic.ScopedJobConfiguration;
import org.locationtech.geowave.analytic.SimpleFeatureItemWrapperFactory;
import org.locationtech.geowave.analytic.clustering.CentroidManagerGeoWave;
import org.locationtech.geowave.analytic.clustering.CentroidPairing;
import org.locationtech.geowave.analytic.clustering.DistortionGroupManagement;
import org.locationtech.geowave.analytic.clustering.NestedGroupCentroidAssignment;
import org.locationtech.geowave.analytic.extract.CentroidExtractor;
import org.locationtech.geowave.analytic.extract.SimpleFeatureCentroidExtractor;
import org.locationtech.geowave.analytic.kmeans.AssociationNotification;
import org.locationtech.geowave.analytic.mapreduce.CountofDoubleWritable;
import org.locationtech.geowave.analytic.param.CentroidParameters;
import org.locationtech.geowave.analytic.param.GlobalParameters;
import org.locationtech.geowave.analytic.param.JumpParameters;
import org.locationtech.geowave.mapreduce.GeoWaveWritableInputMapper;
import org.locationtech.geowave.mapreduce.input.GeoWaveInputKey;
import org.locationtech.geowave.mapreduce.output.GeoWaveOutputKey;
import org.locationtech.jts.geom.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMeansDistortionMapReduce {
    protected static final Logger LOGGER = LoggerFactory.getLogger(KMeansDistortionMapReduce.class);

    public static class KMeansDistortionReduce
    extends Reducer<Text, CountofDoubleWritable, GeoWaveOutputKey, DistortionGroupManagement.DistortionEntry> {
        private Integer expectedK = null;
        protected final Text output = new Text("");
        private CentroidManagerGeoWave<Object> centroidManager;
        private String batchId;

        public void reduce(Text key, Iterable<CountofDoubleWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            double expectation = 0.0;
            List centroids = this.centroidManager.getCentroidsForGroup(key.toString());
            Integer kCount = this.expectedK == null ? Integer.valueOf(centroids.size()) : this.expectedK;
            if (centroids.size() == 0) {
                return;
            }
            double numDimesions = 2 + ((AnalyticItemWrapper)centroids.get(0)).getExtraDimensions().length;
            double ptCount = 0.0;
            for (CountofDoubleWritable value : values) {
                expectation += value.getValue();
                ptCount += value.getCount();
            }
            if (ptCount > 0.0) {
                Double distortion = Math.pow((expectation /= ptCount) / numDimesions, -(numDimesions / 2.0));
                DistortionGroupManagement.DistortionEntry entry = new DistortionGroupManagement.DistortionEntry(key.toString(), this.batchId, kCount, distortion);
                context.write((Object)new GeoWaveOutputKey("distortion", DistortionGroupManagement.DISTORTIONS_INDEX_ARRAY), (Object)entry);
            }
        }

        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            super.setup(context);
            ScopedJobConfiguration config = new ScopedJobConfiguration(context.getConfiguration(), KMeansDistortionMapReduce.class, LOGGER);
            int k = config.getInt((Enum)JumpParameters.Jump.COUNT_OF_CENTROIDS, -1);
            if (k > 0) {
                this.expectedK = k;
            }
            try {
                this.centroidManager = new CentroidManagerGeoWave((JobContext)context, KMeansDistortionMapReduce.class, LOGGER);
            }
            catch (Exception e) {
                LOGGER.warn("Unable to initialize centroid manager", (Throwable)e);
                throw new IOException("Unable to initialize centroid manager", e);
            }
            this.batchId = config.getString((Enum)GlobalParameters.Global.PARENT_BATCH_ID, this.centroidManager.getBatchId());
        }
    }

    public static class KMeansDistorationCombiner
    extends Reducer<Text, CountofDoubleWritable, Text, CountofDoubleWritable> {
        final CountofDoubleWritable outputValue = new CountofDoubleWritable();

        public void reduce(Text key, Iterable<CountofDoubleWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            double expectation = 0.0;
            double ptCount = 0.0;
            for (CountofDoubleWritable value : values) {
                expectation += value.getValue();
                ptCount += value.getCount();
            }
            this.outputValue.set(expectation, ptCount);
            context.write((Object)key, (Object)this.outputValue);
        }
    }

    public static class KMeansDistortionMapper
    extends GeoWaveWritableInputMapper<Text, CountofDoubleWritable> {
        private NestedGroupCentroidAssignment<Object> nestedGroupCentroidAssigner;
        private final Text outputKeyWritable = new Text("1");
        private final CountofDoubleWritable outputValWritable = new CountofDoubleWritable();
        private CentroidExtractor<Object> centroidExtractor;
        private AnalyticItemWrapperFactory<Object> itemWrapperFactory;
        AssociationNotification<Object> centroidAssociationFn = new AssociationNotification<Object>(){

            public void notify(CentroidPairing<Object> pairing) {
                outputKeyWritable.set(pairing.getCentroid().getGroupID());
                double[] extraFromItem = pairing.getPairedItem().getDimensionValues();
                double[] extraCentroid = pairing.getCentroid().getDimensionValues();
                Point p = centroidExtractor.getCentroid(pairing.getPairedItem().getWrappedItem());
                Point centroid = centroidExtractor.getCentroid(pairing.getCentroid().getWrappedItem());
                double expectation = 0.0;
                for (int i = 0; i < extraCentroid.length; ++i) {
                    expectation += Math.pow(extraFromItem[i] - extraCentroid[i], 2.0);
                }
                outputValWritable.set(expectation += Math.pow(p.getCoordinate().x - centroid.getCoordinate().x, 2.0) + Math.pow(p.getCoordinate().y - centroid.getCoordinate().y, 2.0), 1.0);
            }
        };

        protected void mapNativeValue(GeoWaveInputKey key, Object value, Mapper.Context context) throws IOException, InterruptedException {
            this.nestedGroupCentroidAssigner.findCentroidForLevel(this.itemWrapperFactory.create(value), this.centroidAssociationFn);
            context.write((Object)this.outputKeyWritable, (Object)this.outputValWritable);
        }

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            ScopedJobConfiguration config = new ScopedJobConfiguration(context.getConfiguration(), KMeansDistortionMapReduce.class, LOGGER);
            try {
                this.nestedGroupCentroidAssigner = new NestedGroupCentroidAssignment((JobContext)context, KMeansDistortionMapReduce.class, LOGGER);
            }
            catch (Exception e1) {
                throw new IOException(e1);
            }
            try {
                this.centroidExtractor = (CentroidExtractor)config.getInstance((Enum)CentroidParameters.Centroid.EXTRACTOR_CLASS, CentroidExtractor.class, SimpleFeatureCentroidExtractor.class);
            }
            catch (Exception e1) {
                throw new IOException(e1);
            }
            try {
                this.itemWrapperFactory = (AnalyticItemWrapperFactory)config.getInstance((Enum)CentroidParameters.Centroid.WRAPPER_FACTORY_CLASS, AnalyticItemWrapperFactory.class, SimpleFeatureItemWrapperFactory.class);
            }
            catch (Exception e1) {
                throw new IOException(e1);
            }
        }
    }
}

