/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.kmeans;

import java.io.IOException;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.locationtech.geowave.analytic.AnalyticItemWrapper;
import org.locationtech.geowave.analytic.AnalyticItemWrapperFactory;
import org.locationtech.geowave.analytic.GeoObjectDimensionValues;
import org.locationtech.geowave.analytic.ScopedJobConfiguration;
import org.locationtech.geowave.analytic.SimpleFeatureItemWrapperFactory;
import org.locationtech.geowave.analytic.clustering.CentroidManager;
import org.locationtech.geowave.analytic.clustering.CentroidManagerGeoWave;
import org.locationtech.geowave.analytic.clustering.CentroidPairing;
import org.locationtech.geowave.analytic.clustering.NestedGroupCentroidAssignment;
import org.locationtech.geowave.analytic.clustering.exception.MatchingCentroidNotFoundException;
import org.locationtech.geowave.analytic.extract.CentroidExtractor;
import org.locationtech.geowave.analytic.extract.SimpleFeatureCentroidExtractor;
import org.locationtech.geowave.analytic.kmeans.AssociationNotification;
import org.locationtech.geowave.analytic.mapreduce.GroupIDText;
import org.locationtech.geowave.analytic.param.CentroidParameters;
import org.locationtech.geowave.mapreduce.GeoWaveWritableInputMapper;
import org.locationtech.geowave.mapreduce.input.GeoWaveInputKey;
import org.locationtech.geowave.mapreduce.output.GeoWaveOutputKey;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMeansMapReduce {
    protected static final Logger LOGGER = LoggerFactory.getLogger(KMeansMapReduce.class);

    public static class KMeansReduce
    extends Reducer<GroupIDText, BytesWritable, GeoWaveOutputKey, Object> {
        protected CentroidManager<Object> centroidManager;
        private final GeoObjectDimensionValues geoObject = new GeoObjectDimensionValues();
        private String[] indexNames;

        public void reduce(GroupIDText key, Iterable<BytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            AnalyticItemWrapper<Object> centroid;
            String centroidID = key.getID();
            String groupID = key.getGroupID();
            GeoObjectDimensionValues totals = new GeoObjectDimensionValues();
            for (BytesWritable value : values) {
                this.geoObject.fromBinary(value.getBytes());
                totals.add(this.geoObject);
            }
            try {
                centroid = this.getFeatureForCentroid(centroidID, groupID);
            }
            catch (MatchingCentroidNotFoundException e) {
                LOGGER.error("Unable to get centroid " + centroidID + " for group " + groupID, (Throwable)e);
                return;
            }
            centroid.resetAssociatonCount();
            centroid.incrementAssociationCount(totals.getCount());
            double ptCount = totals.getCount();
            totals.x /= ptCount;
            totals.y /= ptCount;
            totals.z /= ptCount;
            int s = centroid.getExtraDimensions().length;
            for (int i = 0; i < s; ++i) {
                totals.values[i] = totals.values[i] / ptCount;
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(groupID + " contains " + centroidID);
            }
            AnalyticItemWrapper nextCentroid = this.centroidManager.createNextCentroid(centroid.getWrappedItem(), groupID, new Coordinate(totals.x, totals.y, totals.z), centroid.getExtraDimensions(), totals.values);
            context.write((Object)new GeoWaveOutputKey(this.centroidManager.getDataTypeName(), this.indexNames), nextCentroid.getWrappedItem());
        }

        private AnalyticItemWrapper<Object> getFeatureForCentroid(String id, String groupID) throws IOException, MatchingCentroidNotFoundException {
            return this.centroidManager.getCentroidById(id, groupID);
        }

        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            super.setup(context);
            try {
                this.centroidManager = new CentroidManagerGeoWave((JobContext)context, KMeansMapReduce.class, LOGGER);
                this.indexNames = new String[]{this.centroidManager.getIndexName()};
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    public static class KMeansCombiner
    extends Reducer<GroupIDText, BytesWritable, GroupIDText, BytesWritable> {
        private final GeoObjectDimensionValues geoObject = new GeoObjectDimensionValues();
        private final BytesWritable outputValWritable = new BytesWritable();

        public void reduce(GroupIDText key, Iterable<BytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            GeoObjectDimensionValues totals = new GeoObjectDimensionValues();
            for (BytesWritable value : values) {
                this.geoObject.fromBinary(value.getBytes());
                totals.add(this.geoObject);
            }
            byte[] outData = totals.toBinary();
            this.outputValWritable.set(outData, 0, outData.length);
            context.write((Object)key, (Object)this.outputValWritable);
        }
    }

    public static class KMeansMapper
    extends GeoWaveWritableInputMapper<GroupIDText, BytesWritable> {
        private NestedGroupCentroidAssignment<Object> nestedGroupCentroidAssigner;
        private final GroupIDText outputKeyWritable = new GroupIDText();
        private final BytesWritable outputValWritable = new BytesWritable();
        private final GeoObjectDimensionValues association = new GeoObjectDimensionValues();
        protected CentroidExtractor<Object> centroidExtractor;
        protected AnalyticItemWrapperFactory<Object> itemWrapperFactory;
        AssociationNotification<Object> centroidAssociationFn = new AssociationNotification<Object>(){

            public void notify(CentroidPairing<Object> pairing) {
                outputKeyWritable.set(pairing.getCentroid().getGroupID(), pairing.getCentroid().getID());
                double[] extra = pairing.getPairedItem().getDimensionValues();
                Point p = centroidExtractor.getCentroid(pairing.getPairedItem().getWrappedItem());
                association.set(p.getCoordinate().x, p.getCoordinate().y, p.getCoordinate().z, extra, pairing.getDistance());
            }
        };

        protected void mapNativeValue(GeoWaveInputKey key, Object value, Mapper.Context context) throws IOException, InterruptedException {
            AnalyticItemWrapper item = this.itemWrapperFactory.create(value);
            this.nestedGroupCentroidAssigner.findCentroidForLevel(item, this.centroidAssociationFn);
            byte[] outData = this.association.toBinary();
            this.outputValWritable.set(outData, 0, outData.length);
            context.write((Object)this.outputKeyWritable, (Object)this.outputValWritable);
        }

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            ScopedJobConfiguration config = new ScopedJobConfiguration(context.getConfiguration(), KMeansMapReduce.class, LOGGER);
            try {
                this.nestedGroupCentroidAssigner = new NestedGroupCentroidAssignment((JobContext)context, KMeansMapReduce.class, LOGGER);
            }
            catch (Exception e1) {
                throw new IOException(e1);
            }
            try {
                this.centroidExtractor = (CentroidExtractor)config.getInstance((Enum)CentroidParameters.Centroid.EXTRACTOR_CLASS, CentroidExtractor.class, SimpleFeatureCentroidExtractor.class);
            }
            catch (Exception e1) {
                throw new IOException(e1);
            }
            try {
                this.itemWrapperFactory = (AnalyticItemWrapperFactory)config.getInstance((Enum)CentroidParameters.Centroid.WRAPPER_FACTORY_CLASS, AnalyticItemWrapperFactory.class, SimpleFeatureItemWrapperFactory.class);
                this.itemWrapperFactory.initialize((JobContext)context, KMeansMapReduce.class, LOGGER);
            }
            catch (Exception e1) {
                throw new IOException(e1);
            }
        }
    }
}

