/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.kmeans;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.Reducer;
import org.locationtech.geowave.analytic.AnalyticItemWrapper;
import org.locationtech.geowave.analytic.AnalyticItemWrapperFactory;
import org.locationtech.geowave.analytic.ScopedJobConfiguration;
import org.locationtech.geowave.analytic.SimpleFeatureItemWrapperFactory;
import org.locationtech.geowave.analytic.clustering.NestedGroupCentroidAssignment;
import org.locationtech.geowave.analytic.extract.CentroidExtractor;
import org.locationtech.geowave.analytic.extract.SimpleFeatureCentroidExtractor;
import org.locationtech.geowave.analytic.param.CentroidParameters;
import org.locationtech.geowave.analytic.param.GlobalParameters;
import org.locationtech.geowave.analytic.param.SampleParameters;
import org.locationtech.geowave.analytic.sample.function.RandomSamplingRankFunction;
import org.locationtech.geowave.analytic.sample.function.SamplingRankFunction;
import org.locationtech.geowave.core.geotime.index.SpatialDimensionalityTypeProvider;
import org.locationtech.geowave.core.geotime.index.SpatialOptions;
import org.locationtech.geowave.core.index.ByteArray;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.mapreduce.GeoWaveWritableInputMapper;
import org.locationtech.geowave.mapreduce.GeoWaveWritableInputReducer;
import org.locationtech.geowave.mapreduce.input.GeoWaveInputKey;
import org.locationtech.geowave.mapreduce.output.GeoWaveOutputKey;
import org.locationtech.jts.geom.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KSamplerMapReduce {
    protected static final Logger LOGGER = LoggerFactory.getLogger(KSamplerMapReduce.class);

    private static class KeyManager {
        private ByteBuffer keyBuffer = ByteBuffer.allocate(64);

        private KeyManager() {
        }

        private static String getGroupAsString(byte[] data) {
            return new String(KeyManager.getGroup(data), StringUtils.getGeoWaveCharset());
        }

        private static byte[] getGroup(byte[] data) {
            ByteBuffer buffer = ByteBuffer.wrap(data);
            buffer.getDouble();
            int len = buffer.getInt();
            return Arrays.copyOfRange(data, buffer.position(), buffer.position() + len);
        }

        private byte[] putData(String groupID, double weight, byte[] dataIdBytes) {
            this.keyBuffer.rewind();
            byte[] groupIDBytes = groupID.getBytes(StringUtils.getGeoWaveCharset());
            int size = dataIdBytes.length + 16 + groupIDBytes.length;
            if (this.keyBuffer.capacity() < size) {
                this.keyBuffer = ByteBuffer.allocate(size);
            }
            this.keyBuffer.putDouble(weight);
            this.keyBuffer.putInt(groupIDBytes.length);
            this.keyBuffer.put(groupIDBytes);
            this.keyBuffer.putInt(dataIdBytes.length);
            this.keyBuffer.put(dataIdBytes);
            return this.keyBuffer.array();
        }
    }

    public static class SampleKeyPartitioner
    extends Partitioner<GeoWaveInputKey, ObjectWritable> {
        public int getPartition(GeoWaveInputKey key, ObjectWritable val, int numPartitions) {
            byte[] grpIDInBytes = KeyManager.getGroup(key.getDataId().getBytes());
            int partition = this.hash(grpIDInBytes) % numPartitions;
            return partition;
        }

        private int hash(byte[] data) {
            int code = 1;
            int i = 0;
            for (byte b : data) {
                code = (int)((double)code + (double)b * Math.pow(31.0, data.length - 1 - i++));
            }
            return code;
        }
    }

    public static class SampleReducer<T>
    extends GeoWaveWritableInputReducer<GeoWaveOutputKey, T> {
        private int maxCount = 1;
        private CentroidExtractor<T> centroidExtractor;
        private AnalyticItemWrapperFactory<T> itemWrapperFactory;
        private String sampleDataTypeName = null;
        private String[] indexNames;
        private int zoomLevel = 1;
        private String batchID;
        private final Map<String, Integer> outputCounts = new HashMap<String, Integer>();

        protected void reduceNativeValues(GeoWaveInputKey key, Iterable<Object> values, Reducer.Context context) throws IOException, InterruptedException {
            String groupID = KeyManager.getGroupAsString(key.getDataId().getBytes());
            for (Object value : values) {
                AnalyticItemWrapper<T> centroid;
                AnalyticItemWrapper sampleItem = this.itemWrapperFactory.create(value);
                Integer outputCount = this.outputCounts.get(groupID);
                Integer n = outputCount = outputCount == null ? Integer.valueOf(0) : outputCount;
                if (outputCount != null && outputCount >= this.maxCount || (centroid = this.createCentroid(groupID, sampleItem)) == null) continue;
                context.write((Object)new GeoWaveOutputKey(this.sampleDataTypeName, this.indexNames), centroid.getWrappedItem());
                Integer n2 = outputCount;
                Integer n3 = outputCount = Integer.valueOf(outputCount + 1);
                this.outputCounts.put(groupID, outputCount);
            }
        }

        private AnalyticItemWrapper<T> createCentroid(String groupID, AnalyticItemWrapper<T> item) {
            Point point = this.centroidExtractor.getCentroid(item.getWrappedItem());
            AnalyticItemWrapper nextCentroid = this.itemWrapperFactory.createNextItem(item.getWrappedItem(), groupID, point.getCoordinate(), item.getExtraDimensions(), item.getDimensionValues());
            nextCentroid.setBatchID(this.batchID);
            nextCentroid.setGroupID(groupID);
            nextCentroid.setZoomLevel(this.zoomLevel);
            return nextCentroid;
        }

        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            super.setup(context);
            ScopedJobConfiguration config = new ScopedJobConfiguration(context.getConfiguration(), KSamplerMapReduce.class, LOGGER);
            this.maxCount = config.getInt((Enum)SampleParameters.Sample.SAMPLE_SIZE, 1);
            this.zoomLevel = config.getInt((Enum)CentroidParameters.Centroid.ZOOM_LEVEL, 1);
            this.sampleDataTypeName = config.getString((Enum)SampleParameters.Sample.DATA_TYPE_NAME, "sample");
            this.batchID = config.getString((Enum)GlobalParameters.Global.BATCH_ID, UUID.randomUUID().toString());
            String indexName = config.getString((Enum)SampleParameters.Sample.INDEX_NAME, SpatialDimensionalityTypeProvider.createIndexFromOptions((SpatialOptions)new SpatialOptions()).getName());
            this.indexNames = new String[]{indexName};
            try {
                this.centroidExtractor = (CentroidExtractor)config.getInstance((Enum)CentroidParameters.Centroid.EXTRACTOR_CLASS, CentroidExtractor.class, SimpleFeatureCentroidExtractor.class);
            }
            catch (Exception e1) {
                throw new IOException(e1);
            }
            try {
                this.itemWrapperFactory = (AnalyticItemWrapperFactory)config.getInstance((Enum)CentroidParameters.Centroid.WRAPPER_FACTORY_CLASS, AnalyticItemWrapperFactory.class, SimpleFeatureItemWrapperFactory.class);
                this.itemWrapperFactory.initialize((JobContext)context, KSamplerMapReduce.class, LOGGER);
            }
            catch (Exception e1) {
                throw new IOException(e1);
            }
        }
    }

    public static class SampleMap<T>
    extends GeoWaveWritableInputMapper<GeoWaveInputKey, ObjectWritable> {
        protected GeoWaveInputKey outputKey = new GeoWaveInputKey();
        private final KeyManager keyManager = new KeyManager();
        private SamplingRankFunction<T> samplingFunction;
        private ObjectWritable currentValue;
        private AnalyticItemWrapperFactory<Object> itemWrapperFactory;
        private int sampleSize = 1;
        private NestedGroupCentroidAssignment<Object> nestedGroupCentroidAssigner;

        protected void mapWritableValue(GeoWaveInputKey key, ObjectWritable value, Mapper.Context context) throws IOException, InterruptedException {
            this.currentValue = value;
            super.mapWritableValue(key, value, context);
        }

        protected void mapNativeValue(GeoWaveInputKey key, Object value, Mapper.Context context) throws IOException, InterruptedException {
            double rank = this.samplingFunction.rank(this.sampleSize, value);
            if (rank > 1.0E-10) {
                AnalyticItemWrapper wrapper = this.itemWrapperFactory.create(value);
                this.outputKey.setDataId(new ByteArray(this.keyManager.putData(this.nestedGroupCentroidAssigner.getGroupForLevel(wrapper), 1.0 - rank, key.getDataId().getBytes())));
                this.outputKey.setInternalAdapterId(key.getInternalAdapterId());
                this.outputKey.setGeoWaveKey(key.getGeoWaveKey());
                context.write((Object)this.outputKey, (Object)this.currentValue);
            }
        }

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            ScopedJobConfiguration config = new ScopedJobConfiguration(context.getConfiguration(), KSamplerMapReduce.class, LOGGER);
            this.sampleSize = config.getInt((Enum)SampleParameters.Sample.SAMPLE_SIZE, 1);
            try {
                this.nestedGroupCentroidAssigner = new NestedGroupCentroidAssignment((JobContext)context, KSamplerMapReduce.class, LOGGER);
            }
            catch (Exception e1) {
                throw new IOException(e1);
            }
            try {
                this.samplingFunction = (SamplingRankFunction)config.getInstance((Enum)SampleParameters.Sample.SAMPLE_RANK_FUNCTION, SamplingRankFunction.class, RandomSamplingRankFunction.class);
                this.samplingFunction.initialize((JobContext)context, KSamplerMapReduce.class, LOGGER);
            }
            catch (Exception e1) {
                throw new IOException(e1);
            }
            try {
                this.itemWrapperFactory = (AnalyticItemWrapperFactory)config.getInstance((Enum)CentroidParameters.Centroid.WRAPPER_FACTORY_CLASS, AnalyticItemWrapperFactory.class, SimpleFeatureItemWrapperFactory.class);
                this.itemWrapperFactory.initialize((JobContext)context, KSamplerMapReduce.class, LOGGER);
            }
            catch (Exception e1) {
                throw new IOException(e1);
            }
        }
    }
}

