/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.kmeans;

import java.io.IOException;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.locationtech.geowave.analytic.AnalyticItemWrapper;
import org.locationtech.geowave.analytic.AnalyticItemWrapperFactory;
import org.locationtech.geowave.analytic.ScopedJobConfiguration;
import org.locationtech.geowave.analytic.SimpleFeatureItemWrapperFactory;
import org.locationtech.geowave.analytic.clustering.CentroidManager;
import org.locationtech.geowave.analytic.clustering.CentroidManagerGeoWave;
import org.locationtech.geowave.analytic.clustering.CentroidPairing;
import org.locationtech.geowave.analytic.clustering.NestedGroupCentroidAssignment;
import org.locationtech.geowave.analytic.clustering.exception.MatchingCentroidNotFoundException;
import org.locationtech.geowave.analytic.kmeans.AssociationNotification;
import org.locationtech.geowave.analytic.mapreduce.CountofDoubleWritable;
import org.locationtech.geowave.analytic.mapreduce.GroupIDText;
import org.locationtech.geowave.analytic.param.CentroidParameters;
import org.locationtech.geowave.mapreduce.GeoWaveWritableInputMapper;
import org.locationtech.geowave.mapreduce.input.GeoWaveInputKey;
import org.locationtech.geowave.mapreduce.output.GeoWaveOutputKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateCentroidCostMapReduce {
    protected static final Logger LOGGER = LoggerFactory.getLogger(UpdateCentroidCostMapReduce.class);

    public static class UpdateCentroidCostReducer
    extends Reducer<GroupIDText, CountofDoubleWritable, GeoWaveOutputKey, Object> {
        private CentroidManager<Object> centroidManager;
        private String[] indexNames;

        protected void reduce(GroupIDText key, Iterable<CountofDoubleWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            AnalyticItemWrapper<Object> centroid;
            String id = key.getID();
            String groupID = key.getGroupID();
            double sum = 0.0;
            double count = 0.0;
            for (CountofDoubleWritable next : values) {
                sum += next.getValue();
                count += next.getCount();
            }
            try {
                centroid = this.getFeatureForCentroid(id, groupID);
            }
            catch (MatchingCentroidNotFoundException e) {
                LOGGER.error("Unable to get centroid " + id + " for group " + groupID, (Throwable)e);
                return;
            }
            centroid.setCost(sum);
            centroid.resetAssociatonCount();
            centroid.incrementAssociationCount((long)count);
            LOGGER.info("Update centroid " + centroid.toString());
            context.write((Object)new GeoWaveOutputKey(this.centroidManager.getDataTypeName(), this.indexNames), centroid.getWrappedItem());
        }

        private AnalyticItemWrapper<Object> getFeatureForCentroid(String id, String groupID) throws IOException, MatchingCentroidNotFoundException {
            return this.centroidManager.getCentroidById(id, groupID);
        }

        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            super.setup(context);
            try {
                this.centroidManager = new CentroidManagerGeoWave((JobContext)context, UpdateCentroidCostMapReduce.class, LOGGER);
                this.indexNames = new String[]{this.centroidManager.getIndexName()};
            }
            catch (Exception e) {
                LOGGER.warn("Unable to initialize centroid manager", (Throwable)e);
                throw new IOException("Unable to initialize centroid manager");
            }
        }
    }

    public static class UpdateCentroidCostCombiner
    extends Reducer<GroupIDText, CountofDoubleWritable, GroupIDText, CountofDoubleWritable> {
        final CountofDoubleWritable outputValue = new CountofDoubleWritable();

        public void reduce(GroupIDText key, Iterable<CountofDoubleWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            double expectation = 0.0;
            double ptCount = 0.0;
            for (CountofDoubleWritable value : values) {
                expectation += value.getValue();
                ptCount += value.getCount();
            }
            this.outputValue.set(expectation, ptCount);
            context.write((Object)key, (Object)this.outputValue);
        }
    }

    public static class UpdateCentroidCostMap
    extends GeoWaveWritableInputMapper<GroupIDText, CountofDoubleWritable> {
        private NestedGroupCentroidAssignment<Object> nestedGroupCentroidAssigner;
        private final CountofDoubleWritable dw = new CountofDoubleWritable();
        protected final GroupIDText outputWritable = new GroupIDText();
        protected AnalyticItemWrapperFactory<Object> itemWrapperFactory;
        private final AssociationNotification<Object> centroidAssociationFn = new AssociationNotification<Object>(){

            public void notify(CentroidPairing<Object> pairing) {
                outputWritable.set(pairing.getCentroid().getGroupID(), pairing.getCentroid().getID());
            }
        };

        protected void mapNativeValue(GeoWaveInputKey key, Object value, Mapper.Context context) throws IOException, InterruptedException {
            AnalyticItemWrapper wrappedItem = this.itemWrapperFactory.create(value);
            this.dw.set(this.nestedGroupCentroidAssigner.findCentroidForLevel(wrappedItem, this.centroidAssociationFn), 1.0);
            context.write((Object)this.outputWritable, (Object)this.dw);
        }

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            ScopedJobConfiguration config = new ScopedJobConfiguration(context.getConfiguration(), UpdateCentroidCostMapReduce.class, LOGGER);
            try {
                this.nestedGroupCentroidAssigner = new NestedGroupCentroidAssignment((JobContext)context, UpdateCentroidCostMapReduce.class, LOGGER);
            }
            catch (Exception e1) {
                throw new IOException(e1);
            }
            try {
                this.itemWrapperFactory = (AnalyticItemWrapperFactory)config.getInstance((Enum)CentroidParameters.Centroid.WRAPPER_FACTORY_CLASS, AnalyticItemWrapperFactory.class, SimpleFeatureItemWrapperFactory.class);
                this.itemWrapperFactory.initialize((JobContext)context, UpdateCentroidCostMapReduce.class, LOGGER);
            }
            catch (Exception e1) {
                throw new IOException(e1);
            }
        }
    }
}

