/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.kmeans.runner;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.locationtech.geowave.analytic.AnalyticItemWrapper;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.clustering.CentroidManager;
import org.locationtech.geowave.analytic.clustering.CentroidManagerGeoWave;
import org.locationtech.geowave.analytic.mapreduce.MapReduceJobRunner;

public class IterationCountCalculateRunner<T>
implements MapReduceJobRunner {
    private int iterationsCount = 1;

    public int getIterationsCount() {
        return this.iterationsCount;
    }

    public void setIterationsCount(int iterationsCount) {
        this.iterationsCount = iterationsCount;
    }

    @Override
    public int run(Configuration config, PropertyManagement runTimeProperties) throws Exception {
        this.iterationsCount = this.getIterations(runTimeProperties);
        return 0;
    }

    private int getIterations(PropertyManagement propertyManagement) throws IOException {
        CentroidManagerGeoWave centroidManager = new CentroidManagerGeoWave(propertyManagement);
        final AtomicInteger resultHolder = new AtomicInteger(0);
        centroidManager.processForAllGroups(new CentroidManager.CentroidProcessingFn<T>(){

            public int processGroup(String groupID, List<AnalyticItemWrapper<T>> centroids) {
                resultHolder.set(Math.max(resultHolder.get(), centroids.size() > 0 ? (int)Math.round(Math.log(IterationCountCalculateRunner.this.maxCost(centroids))) : 0));
                return 0;
            }
        });
        return Math.max(this.iterationsCount, resultHolder.get());
    }

    private double maxCost(List<AnalyticItemWrapper<T>> centroids) {
        double max = 0.0;
        for (AnalyticItemWrapper<T> centroid : centroids) {
            max = Math.max(max, centroid.getCost());
        }
        return max;
    }
}

