/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.kmeans.runner;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.clustering.DistortionGroupManagement;
import org.locationtech.geowave.analytic.clustering.NestedGroupCentroidAssignment;
import org.locationtech.geowave.analytic.mapreduce.CountofDoubleWritable;
import org.locationtech.geowave.analytic.mapreduce.GeoWaveAnalyticJobRunner;
import org.locationtech.geowave.analytic.mapreduce.kmeans.KMeansDistortionMapReduce;
import org.locationtech.geowave.analytic.param.CentroidParameters;
import org.locationtech.geowave.analytic.param.ClusteringParameters;
import org.locationtech.geowave.analytic.param.GlobalParameters;
import org.locationtech.geowave.analytic.param.JumpParameters;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.cli.store.DataStorePluginOptions;
import org.locationtech.geowave.mapreduce.input.GeoWaveInputFormat;
import org.locationtech.geowave.mapreduce.output.GeoWaveOutputFormat;
import org.locationtech.geowave.mapreduce.output.GeoWaveOutputKey;

public class KMeansDistortionJobRunner
extends GeoWaveAnalyticJobRunner {
    private int k = 1;
    private DataStorePluginOptions dataStoreOptions;

    public KMeansDistortionJobRunner() {
        this.setReducerCount(8);
    }

    public void setDataStoreOptions(DataStorePluginOptions dataStoreOptions) {
        this.dataStoreOptions = dataStoreOptions;
    }

    public void setCentroidsCount(int k) {
        this.k = k;
    }

    @Override
    public void configure(Job job) throws Exception {
        job.setMapperClass(KMeansDistortionMapReduce.KMeansDistortionMapper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(CountofDoubleWritable.class);
        job.setReducerClass(KMeansDistortionMapReduce.KMeansDistortionReduce.class);
        job.setCombinerClass(KMeansDistortionMapReduce.KMeansDistorationCombiner.class);
        job.setOutputKeyClass(GeoWaveOutputKey.class);
        job.setOutputValueClass(DistortionGroupManagement.DistortionEntry.class);
        job.setOutputFormatClass(GeoWaveOutputFormat.class);
        long milliSeconds = 900000L;
        Configuration conf = job.getConfiguration();
        conf.setLong("mapred.task.timeout", 900000L);
        JumpParameters.Jump.COUNT_OF_CENTROIDS.getHelper().setValue(conf, KMeansDistortionMapReduce.class, (Object)this.k);
        GeoWaveInputFormat.setStoreOptions((Configuration)conf, (DataStorePluginOptions)this.dataStoreOptions);
        GeoWaveOutputFormat.addDataAdapter((Configuration)conf, (DataTypeAdapter)new DistortionGroupManagement.DistortionDataAdapter());
    }

    @Override
    public Class<?> getScope() {
        return KMeansDistortionMapReduce.class;
    }

    @Override
    public int run(Configuration config, PropertyManagement runTimeProperties) throws Exception {
        this.setReducerCount(runTimeProperties.getPropertyAsInt((ParameterEnum)ClusteringParameters.Clustering.MAX_REDUCER_COUNT, super.getReducerCount()));
        runTimeProperties.setConfig(new ParameterEnum[]{CentroidParameters.Centroid.EXTRACTOR_CLASS, CentroidParameters.Centroid.WRAPPER_FACTORY_CLASS, GlobalParameters.Global.PARENT_BATCH_ID}, config, this.getScope());
        NestedGroupCentroidAssignment.setParameters((Configuration)config, this.getScope(), (PropertyManagement)runTimeProperties);
        return super.run(config, runTimeProperties);
    }

    @Override
    protected String getJobName() {
        return "K-Means Distortion";
    }
}

