/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.kmeans.runner;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.locationtech.geowave.analytic.AnalyticItemWrapper;
import org.locationtech.geowave.analytic.IndependentJobRunner;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.SimpleFeatureItemWrapperFactory;
import org.locationtech.geowave.analytic.clustering.CentroidManager;
import org.locationtech.geowave.analytic.clustering.CentroidManagerGeoWave;
import org.locationtech.geowave.analytic.clustering.NestedGroupCentroidAssignment;
import org.locationtech.geowave.analytic.distance.DistanceFn;
import org.locationtech.geowave.analytic.distance.FeatureCentroidDistanceFn;
import org.locationtech.geowave.analytic.extract.SimpleFeatureCentroidExtractor;
import org.locationtech.geowave.analytic.mapreduce.MapReduceJobController;
import org.locationtech.geowave.analytic.mapreduce.MapReduceJobRunner;
import org.locationtech.geowave.analytic.mapreduce.kmeans.runner.KMeansJobRunner;
import org.locationtech.geowave.analytic.param.CentroidParameters;
import org.locationtech.geowave.analytic.param.ClusteringParameters;
import org.locationtech.geowave.analytic.param.CommonParameters;
import org.locationtech.geowave.analytic.param.FormatConfiguration;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMeansIterationsJobRunner<T>
implements MapReduceJobRunner,
IndependentJobRunner {
    protected static final Logger LOGGER = LoggerFactory.getLogger(KMeansIterationsJobRunner.class);
    private final KMeansJobRunner jobRunner = new KMeansJobRunner();
    private double convergenceTol = 1.0E-4;

    protected CentroidManager<T> constructCentroidManager(Configuration config, PropertyManagement runTimeProperties) throws IOException {
        return new CentroidManagerGeoWave(runTimeProperties);
    }

    public void setInputFormatConfiguration(FormatConfiguration inputFormatConfiguration) {
        this.jobRunner.setInputFormatConfiguration(inputFormatConfiguration);
    }

    public void setReducerCount(int reducerCount) {
        this.jobRunner.setReducerCount(reducerCount);
    }

    @Override
    public int run(Configuration config, PropertyManagement runTimeProperties) throws Exception {
        this.convergenceTol = runTimeProperties.getPropertyAsDouble((ParameterEnum)ClusteringParameters.Clustering.CONVERGANCE_TOLERANCE, this.convergenceTol);
        DistanceFn distanceFunction = (DistanceFn)runTimeProperties.getClassInstance((ParameterEnum)CommonParameters.Common.DISTANCE_FUNCTION_CLASS, DistanceFn.class, FeatureCentroidDistanceFn.class);
        boolean converged = false;
        for (int maxIterationCount = runTimeProperties.getPropertyAsInt((ParameterEnum)ClusteringParameters.Clustering.MAX_ITERATIONS, 15).intValue(); !converged && maxIterationCount > 0; --maxIterationCount) {
            int status = this.runJob(config, runTimeProperties);
            if (status != 0) {
                return status;
            }
            CentroidManager<T> centroidManager = this.constructCentroidManager(config, runTimeProperties);
            converged = this.checkForConvergence(centroidManager, distanceFunction);
        }
        return 0;
    }

    protected int runJob(Configuration config, PropertyManagement runTimeProperties) throws Exception {
        runTimeProperties.storeIfEmpty((ParameterEnum)CentroidParameters.Centroid.EXTRACTOR_CLASS, SimpleFeatureCentroidExtractor.class);
        runTimeProperties.storeIfEmpty((ParameterEnum)CentroidParameters.Centroid.WRAPPER_FACTORY_CLASS, SimpleFeatureItemWrapperFactory.class);
        runTimeProperties.storeIfEmpty((ParameterEnum)CommonParameters.Common.DISTANCE_FUNCTION_CLASS, FeatureCentroidDistanceFn.class);
        return this.jobRunner.run(config, runTimeProperties);
    }

    private boolean checkForConvergence(final CentroidManager<T> centroidManager, final DistanceFn<T> distanceFunction) throws IOException {
        final AtomicInteger grpCount = new AtomicInteger(0);
        final AtomicInteger centroidCount = new AtomicInteger(0);
        final AtomicInteger failuresCount = new AtomicInteger(0);
        boolean status = centroidManager.processForAllGroups(new CentroidManager.CentroidProcessingFn<T>(){

            public int processGroup(String groupID, List<AnalyticItemWrapper<T>> centroids) {
                grpCount.incrementAndGet();
                centroidCount.addAndGet(centroids.size() / 2);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Parent Group: {} ", (Object)groupID);
                    for (AnalyticItemWrapper troid : centroids) {
                        LOGGER.warn("Child Group: {} ", (Object)troid.getID());
                    }
                }
                failuresCount.addAndGet(KMeansIterationsJobRunner.this.computeCostAndCleanUp(groupID, centroids, centroidManager, distanceFunction));
                return 0;
            }
        }) == 0;
        this.setReducerCount(grpCount.get() * centroidCount.get());
        return status && failuresCount.get() == 0;
    }

    protected int computeCostAndCleanUp(String groupID, List<AnalyticItemWrapper<T>> centroids, CentroidManager<T> centroidManager, DistanceFn<T> distanceFunction) {
        double distance = 0.0;
        ArrayList<String> deletionKeys = new ArrayList<String>();
        Collections.sort(centroids, new Comparator<AnalyticItemWrapper<T>>(){

            @Override
            public int compare(AnalyticItemWrapper<T> arg0, AnalyticItemWrapper<T> arg1) {
                int c = arg0.getName().compareTo(arg1.getName());
                if (c == 0) {
                    return arg0.getIterationID() - arg1.getIterationID();
                }
                return c;
            }
        });
        AnalyticItemWrapper<T> prior = null;
        for (AnalyticItemWrapper<T> centroid : centroids) {
            if (prior == null) {
                prior = centroid;
                continue;
            }
            if (!prior.getName().equals(centroid.getName())) {
                LOGGER.warn("Centroid is no longer viable " + prior.getID() + " from group " + prior.getGroupID());
                prior = centroid;
                continue;
            }
            distance += distanceFunction.measure(prior.getWrappedItem(), centroid.getWrappedItem());
            deletionKeys.add(prior.getID());
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Within group {} replace {} with {}", (Object[])new String[]{prior.getGroupID(), prior.getID(), centroid.getID()});
            }
            prior = null;
        }
        distance /= (double)centroids.size();
        try {
            centroidManager.delete(deletionKeys.toArray(new String[deletionKeys.size()]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return distance < this.convergenceTol ? 0 : 1;
    }

    public Collection<ParameterEnum<?>> getParameters() {
        HashSet params = new HashSet();
        params.addAll(Arrays.asList(CentroidParameters.Centroid.INDEX_NAME, CentroidParameters.Centroid.DATA_TYPE_ID, CentroidParameters.Centroid.DATA_NAMESPACE_URI, CentroidParameters.Centroid.EXTRACTOR_CLASS, CentroidParameters.Centroid.WRAPPER_FACTORY_CLASS, ClusteringParameters.Clustering.MAX_REDUCER_COUNT, ClusteringParameters.Clustering.MAX_ITERATIONS, ClusteringParameters.Clustering.CONVERGANCE_TOLERANCE, CommonParameters.Common.DISTANCE_FUNCTION_CLASS));
        params.addAll(CentroidManagerGeoWave.getParameters());
        params.addAll(NestedGroupCentroidAssignment.getParameters());
        params.addAll(this.jobRunner.getParameters());
        return params;
    }

    public int run(PropertyManagement runTimeProperties) throws Exception {
        return this.run(MapReduceJobController.getConfiguration(runTimeProperties), runTimeProperties);
    }
}

