/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.kmeans.runner;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapreduce.Job;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.clustering.NestedGroupCentroidAssignment;
import org.locationtech.geowave.analytic.mapreduce.GeoWaveAnalyticJobRunner;
import org.locationtech.geowave.analytic.mapreduce.GeoWaveOutputFormatConfiguration;
import org.locationtech.geowave.analytic.mapreduce.GroupIDText;
import org.locationtech.geowave.analytic.mapreduce.MapReduceJobRunner;
import org.locationtech.geowave.analytic.mapreduce.kmeans.KMeansMapReduce;
import org.locationtech.geowave.analytic.param.CentroidParameters;
import org.locationtech.geowave.analytic.param.ClusteringParameters;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.locationtech.geowave.mapreduce.output.GeoWaveOutputKey;
import org.opengis.feature.simple.SimpleFeature;

public class KMeansJobRunner
extends GeoWaveAnalyticJobRunner
implements MapReduceJobRunner {
    public KMeansJobRunner() {
        super.setOutputFormatConfiguration(new GeoWaveOutputFormatConfiguration());
    }

    @Override
    public void setReducerCount(int reducerCount) {
        super.setReducerCount(Math.min(2, reducerCount));
    }

    @Override
    public void configure(Job job) throws Exception {
        job.setMapperClass(KMeansMapReduce.KMeansMapper.class);
        job.setMapOutputKeyClass(GroupIDText.class);
        job.setMapOutputValueClass(BytesWritable.class);
        job.setReducerClass(KMeansMapReduce.KMeansReduce.class);
        job.setCombinerClass(KMeansMapReduce.KMeansCombiner.class);
        job.setReduceSpeculativeExecution(false);
        job.setOutputKeyClass(GeoWaveOutputKey.class);
        job.setOutputValueClass(SimpleFeature.class);
    }

    @Override
    public Class<?> getScope() {
        return KMeansMapReduce.class;
    }

    @Override
    public int run(Configuration configuration, PropertyManagement runTimeProperties) throws Exception {
        NestedGroupCentroidAssignment.setParameters((Configuration)configuration, this.getScope(), (PropertyManagement)runTimeProperties);
        super.setReducerCount(runTimeProperties.getPropertyAsInt((ParameterEnum)ClusteringParameters.Clustering.MAX_REDUCER_COUNT, Math.max(2, super.getReducerCount())));
        runTimeProperties.setConfig(new ParameterEnum[]{CentroidParameters.Centroid.EXTRACTOR_CLASS, CentroidParameters.Centroid.WRAPPER_FACTORY_CLASS}, configuration, this.getScope());
        return super.run(configuration, runTimeProperties);
    }

    @Override
    protected String getJobName() {
        return "K-Means";
    }
}

