/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.kmeans.runner;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.locationtech.geowave.analytic.AnalyticItemWrapperFactory;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.SimpleFeatureItemWrapperFactory;
import org.locationtech.geowave.analytic.clustering.ClusteringUtils;
import org.locationtech.geowave.analytic.clustering.DistortionGroupManagement;
import org.locationtech.geowave.analytic.distance.FeatureCentroidDistanceFn;
import org.locationtech.geowave.analytic.extract.SimpleFeatureCentroidExtractor;
import org.locationtech.geowave.analytic.extract.SimpleFeatureGeometryExtractor;
import org.locationtech.geowave.analytic.mapreduce.MapReduceJobController;
import org.locationtech.geowave.analytic.mapreduce.MapReduceJobRunner;
import org.locationtech.geowave.analytic.mapreduce.clustering.runner.ClusteringRunner;
import org.locationtech.geowave.analytic.mapreduce.kmeans.runner.KMeansDistortionJobRunner;
import org.locationtech.geowave.analytic.mapreduce.kmeans.runner.KMeansParallelJobRunner;
import org.locationtech.geowave.analytic.mapreduce.kmeans.runner.KMeansSingleSampleJobRunner;
import org.locationtech.geowave.analytic.param.CentroidParameters;
import org.locationtech.geowave.analytic.param.ClusteringParameters;
import org.locationtech.geowave.analytic.param.CommonParameters;
import org.locationtech.geowave.analytic.param.FormatConfiguration;
import org.locationtech.geowave.analytic.param.GlobalParameters;
import org.locationtech.geowave.analytic.param.JumpParameters;
import org.locationtech.geowave.analytic.param.MapReduceParameters;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.locationtech.geowave.analytic.param.SampleParameters;
import org.locationtech.geowave.analytic.param.StoreParameters;
import org.locationtech.geowave.analytic.store.PersistableStore;
import org.locationtech.geowave.core.index.numeric.NumericRange;
import org.locationtech.geowave.core.store.cli.store.DataStorePluginOptions;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMeansJumpJobRunner
extends MapReduceJobController
implements ClusteringRunner {
    static final Logger LOGGER = LoggerFactory.getLogger(KMeansJumpJobRunner.class);
    final KMeansDistortionJobRunner jumpRunner = new KMeansDistortionJobRunner();
    final KMeansParallelJobRunnerDelegate kmeansRunner = new KMeansParallelJobRunnerDelegate();
    private int currentZoomLevel = 1;

    public KMeansJumpJobRunner() {
        this.setZoomLevel(1);
        this.init(new MapReduceJobRunner[]{this.kmeansRunner, this.jumpRunner}, new MapReduceJobController.PostOperationTask[]{DoNothingTask, DoNothingTask});
    }

    @Override
    public void setZoomLevel(int zoomLevel) {
        this.currentZoomLevel = zoomLevel;
        this.kmeansRunner.setZoomLevel(zoomLevel);
    }

    @Override
    public void setInputFormatConfiguration(FormatConfiguration inputFormatConfiguration) {
        this.jumpRunner.setInputFormatConfiguration(inputFormatConfiguration);
        this.kmeansRunner.setInputFormatConfiguration(inputFormatConfiguration);
    }

    @Override
    public int run(Configuration configuration, PropertyManagement propertyManagement) throws Exception {
        propertyManagement.store((ParameterEnum)CentroidParameters.Centroid.ZOOM_LEVEL, (Object)this.currentZoomLevel);
        propertyManagement.storeIfEmpty((ParameterEnum)GlobalParameters.Global.BATCH_ID, (Serializable)((Object)UUID.randomUUID().toString()));
        propertyManagement.storeIfEmpty((ParameterEnum)CentroidParameters.Centroid.WRAPPER_FACTORY_CLASS, SimpleFeatureItemWrapperFactory.class);
        propertyManagement.storeIfEmpty((ParameterEnum)CommonParameters.Common.DISTANCE_FUNCTION_CLASS, FeatureCentroidDistanceFn.class);
        propertyManagement.storeIfEmpty((ParameterEnum)CentroidParameters.Centroid.EXTRACTOR_CLASS, SimpleFeatureCentroidExtractor.class);
        propertyManagement.storeIfEmpty((ParameterEnum)CommonParameters.Common.DIMENSION_EXTRACT_CLASS, SimpleFeatureGeometryExtractor.class);
        propertyManagement.copy((ParameterEnum)CentroidParameters.Centroid.DATA_TYPE_ID, (ParameterEnum)SampleParameters.Sample.DATA_TYPE_NAME);
        propertyManagement.copy((ParameterEnum)CentroidParameters.Centroid.INDEX_NAME, (ParameterEnum)SampleParameters.Sample.INDEX_NAME);
        ClusteringUtils.createAdapter((PropertyManagement)propertyManagement);
        ClusteringUtils.createIndex((PropertyManagement)propertyManagement);
        String currentBatchId = propertyManagement.getPropertyAsString((ParameterEnum)GlobalParameters.Global.BATCH_ID, UUID.randomUUID().toString());
        try {
            NumericRange rangeOfIterations = propertyManagement.getPropertyAsRange((ParameterEnum)JumpParameters.Jump.RANGE_OF_CENTROIDS, new NumericRange(2.0, 200.0));
            propertyManagement.store((ParameterEnum)GlobalParameters.Global.PARENT_BATCH_ID, (Object)currentBatchId);
            DataStorePluginOptions dataStoreOptions = ((PersistableStore)propertyManagement.getProperty((ParameterEnum)StoreParameters.StoreParam.INPUT_STORE)).getDataStoreOptions();
            DistortionGroupManagement distortionGroupManagement = new DistortionGroupManagement(dataStoreOptions);
            int k = (int)Math.max(2L, Math.round(rangeOfIterations.getMin()));
            while ((long)k < Math.round(rangeOfIterations.getMax())) {
                propertyManagement.store((ParameterEnum)SampleParameters.Sample.MIN_SAMPLE_SIZE, (Object)k);
                propertyManagement.store((ParameterEnum)SampleParameters.Sample.MAX_SAMPLE_SIZE, (Object)k);
                propertyManagement.store((ParameterEnum)SampleParameters.Sample.SAMPLE_SIZE, (Object)k);
                this.jumpRunner.setCentroidsCount(k);
                this.jumpRunner.setDataStoreOptions(dataStoreOptions);
                String iterationBatchId = currentBatchId + "_" + k;
                propertyManagement.store((ParameterEnum)GlobalParameters.Global.BATCH_ID, (Object)iterationBatchId);
                this.jumpRunner.setReducerCount(k);
                int status = super.run(configuration, propertyManagement);
                if (status != 0) {
                    return status;
                }
                ++k;
            }
            propertyManagement.store((ParameterEnum)GlobalParameters.Global.BATCH_ID, (Object)currentBatchId);
            Class analyticItemWrapperFC = propertyManagement.getPropertyAsClass((ParameterEnum)CentroidParameters.Centroid.WRAPPER_FACTORY_CLASS, AnalyticItemWrapperFactory.class);
            int result = distortionGroupManagement.retainBestGroups((AnalyticItemWrapperFactory)analyticItemWrapperFC.newInstance(), propertyManagement.getPropertyAsString((ParameterEnum)CentroidParameters.Centroid.DATA_TYPE_ID), propertyManagement.getPropertyAsString((ParameterEnum)CentroidParameters.Centroid.INDEX_NAME), currentBatchId, this.currentZoomLevel);
            return result;
        }
        catch (Exception ex) {
            LOGGER.error("Cannot create distortions", (Throwable)ex);
            return 1;
        }
    }

    @Override
    public Collection<ParameterEnum<?>> getParameters() {
        HashSet params = new HashSet();
        params.addAll(this.kmeansRunner.singleSamplekmeansJobRunner.getParameters());
        params.addAll(this.kmeansRunner.parallelJobRunner.getParameters());
        params.addAll(Arrays.asList(JumpParameters.Jump.RANGE_OF_CENTROIDS, JumpParameters.Jump.KPLUSPLUS_MIN, ClusteringParameters.Clustering.MAX_REDUCER_COUNT, CentroidParameters.Centroid.WRAPPER_FACTORY_CLASS, CentroidParameters.Centroid.INDEX_NAME, CentroidParameters.Centroid.DATA_TYPE_ID, CentroidParameters.Centroid.DATA_NAMESPACE_URI, CentroidParameters.Centroid.EXTRACTOR_CLASS, CommonParameters.Common.DISTANCE_FUNCTION_CLASS, CommonParameters.Common.DIMENSION_EXTRACT_CLASS, StoreParameters.StoreParam.INPUT_STORE, GlobalParameters.Global.BATCH_ID));
        params.addAll(MapReduceParameters.getParameters());
        params.remove(CentroidParameters.Centroid.ZOOM_LEVEL);
        params.remove(SampleParameters.Sample.DATA_TYPE_NAME);
        params.remove(SampleParameters.Sample.INDEX_NAME);
        return params;
    }

    private static class KMeansParallelJobRunnerDelegate
    implements MapReduceJobRunner {
        final KMeansSingleSampleJobRunner<SimpleFeature> singleSamplekmeansJobRunner = new KMeansSingleSampleJobRunner();
        final KMeansParallelJobRunner parallelJobRunner = new KMeansParallelJobRunner();

        private KMeansParallelJobRunnerDelegate() {
        }

        @Override
        public int run(Configuration config, PropertyManagement runTimeProperties) throws Exception {
            int minkplusplus;
            int k = runTimeProperties.getPropertyAsInt((ParameterEnum)SampleParameters.Sample.SAMPLE_SIZE, 1);
            if (k >= (minkplusplus = runTimeProperties.getPropertyAsInt((ParameterEnum)JumpParameters.Jump.KPLUSPLUS_MIN, 3).intValue())) {
                return this.parallelJobRunner.run(config, runTimeProperties);
            }
            return this.singleSamplekmeansJobRunner.run(config, runTimeProperties);
        }

        public void setZoomLevel(int zoomLevel) {
            this.parallelJobRunner.setZoomLevel(zoomLevel);
            this.singleSamplekmeansJobRunner.setZoomLevel(zoomLevel);
        }

        public void setInputFormatConfiguration(FormatConfiguration inputFormatConfiguration) {
            this.parallelJobRunner.setInputFormatConfiguration(inputFormatConfiguration);
            this.singleSamplekmeansJobRunner.setInputFormatConfiguration(inputFormatConfiguration);
        }
    }
}

