/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.kmeans.runner;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.SimpleFeatureItemWrapperFactory;
import org.locationtech.geowave.analytic.clustering.ClusteringUtils;
import org.locationtech.geowave.analytic.distance.FeatureCentroidDistanceFn;
import org.locationtech.geowave.analytic.extract.SimpleFeatureCentroidExtractor;
import org.locationtech.geowave.analytic.extract.SimpleFeatureGeometryExtractor;
import org.locationtech.geowave.analytic.mapreduce.MapReduceJobController;
import org.locationtech.geowave.analytic.mapreduce.MapReduceJobRunner;
import org.locationtech.geowave.analytic.mapreduce.clustering.runner.ClusteringRunner;
import org.locationtech.geowave.analytic.mapreduce.kmeans.runner.KMeansIterationsJobRunner;
import org.locationtech.geowave.analytic.mapreduce.kmeans.runner.SampleMultipleSetsJobRunner;
import org.locationtech.geowave.analytic.mapreduce.kmeans.runner.StripWeakCentroidsRunner;
import org.locationtech.geowave.analytic.param.CentroidParameters;
import org.locationtech.geowave.analytic.param.CommonParameters;
import org.locationtech.geowave.analytic.param.FormatConfiguration;
import org.locationtech.geowave.analytic.param.GlobalParameters;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.locationtech.geowave.analytic.param.SampleParameters;
import org.opengis.feature.simple.SimpleFeature;

public class KMeansParallelJobRunner
extends MapReduceJobController
implements ClusteringRunner {
    final SampleMultipleSetsJobRunner<SimpleFeature> sampleSetsRunner = new SampleMultipleSetsJobRunner();
    final StripWeakCentroidsRunner<SimpleFeature> stripWeakCentroidsRunner = new StripWeakCentroidsRunner();
    final KMeansIterationsJobRunner<SimpleFeature> kmeansJobRunner = new KMeansIterationsJobRunner();
    private int currentZoomLevel = 1;

    public KMeansParallelJobRunner() {
        this.setZoomLevel(1);
        this.init(new MapReduceJobRunner[]{this.sampleSetsRunner, this.stripWeakCentroidsRunner, this.kmeansJobRunner}, new MapReduceJobController.PostOperationTask[]{DoNothingTask, DoNothingTask, new MapReduceJobController.PostOperationTask(){

            @Override
            public void runTask(Configuration config, MapReduceJobRunner runner) {
                KMeansParallelJobRunner.this.kmeansJobRunner.setReducerCount(KMeansParallelJobRunner.this.stripWeakCentroidsRunner.getCurrentCentroidCount());
            }
        }, DoNothingTask});
    }

    @Override
    public void setZoomLevel(int zoomLevel) {
        this.currentZoomLevel = zoomLevel;
        this.sampleSetsRunner.setZoomLevel(zoomLevel);
    }

    @Override
    public void setInputFormatConfiguration(FormatConfiguration inputFormatConfiguration) {
        this.sampleSetsRunner.setInputFormatConfiguration(inputFormatConfiguration);
        this.kmeansJobRunner.setInputFormatConfiguration(inputFormatConfiguration);
    }

    @Override
    public int run(Configuration configuration, PropertyManagement propertyManagement) throws Exception {
        return this.runJob(configuration, propertyManagement);
    }

    private int runJob(Configuration config, PropertyManagement propertyManagement) throws Exception {
        propertyManagement.store((ParameterEnum)CentroidParameters.Centroid.ZOOM_LEVEL, (Object)this.currentZoomLevel);
        propertyManagement.storeIfEmpty((ParameterEnum)GlobalParameters.Global.BATCH_ID, (Serializable)((Object)UUID.randomUUID().toString()));
        propertyManagement.storeIfEmpty((ParameterEnum)CentroidParameters.Centroid.WRAPPER_FACTORY_CLASS, SimpleFeatureItemWrapperFactory.class);
        propertyManagement.storeIfEmpty((ParameterEnum)CommonParameters.Common.DISTANCE_FUNCTION_CLASS, FeatureCentroidDistanceFn.class);
        propertyManagement.storeIfEmpty((ParameterEnum)CentroidParameters.Centroid.EXTRACTOR_CLASS, SimpleFeatureCentroidExtractor.class);
        propertyManagement.storeIfEmpty((ParameterEnum)CommonParameters.Common.DIMENSION_EXTRACT_CLASS, SimpleFeatureGeometryExtractor.class);
        this.stripWeakCentroidsRunner.setRange(propertyManagement.getPropertyAsInt((ParameterEnum)SampleParameters.Sample.MIN_SAMPLE_SIZE, 2), propertyManagement.getPropertyAsInt((ParameterEnum)SampleParameters.Sample.MAX_SAMPLE_SIZE, 1000));
        ClusteringUtils.createAdapter((PropertyManagement)propertyManagement);
        ClusteringUtils.createIndex((PropertyManagement)propertyManagement);
        return super.run(config, propertyManagement);
    }

    @Override
    public Collection<ParameterEnum<?>> getParameters() {
        HashSet params = new HashSet();
        params.addAll(this.kmeansJobRunner.getParameters());
        params.addAll(this.sampleSetsRunner.getParameters());
        params.remove(CentroidParameters.Centroid.ZOOM_LEVEL);
        return params;
    }
}

