/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.kmeans.runner;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.SimpleFeatureItemWrapperFactory;
import org.locationtech.geowave.analytic.clustering.ClusteringUtils;
import org.locationtech.geowave.analytic.clustering.NestedGroupCentroidAssignment;
import org.locationtech.geowave.analytic.distance.FeatureCentroidDistanceFn;
import org.locationtech.geowave.analytic.extract.SimpleFeatureCentroidExtractor;
import org.locationtech.geowave.analytic.extract.SimpleFeatureGeometryExtractor;
import org.locationtech.geowave.analytic.mapreduce.MapReduceJobController;
import org.locationtech.geowave.analytic.mapreduce.MapReduceJobRunner;
import org.locationtech.geowave.analytic.mapreduce.clustering.runner.ClusteringRunner;
import org.locationtech.geowave.analytic.mapreduce.kmeans.runner.KMeansIterationsJobRunner;
import org.locationtech.geowave.analytic.mapreduce.kmeans.runner.KSamplerJobRunner;
import org.locationtech.geowave.analytic.param.CentroidParameters;
import org.locationtech.geowave.analytic.param.ClusteringParameters;
import org.locationtech.geowave.analytic.param.CommonParameters;
import org.locationtech.geowave.analytic.param.FormatConfiguration;
import org.locationtech.geowave.analytic.param.GlobalParameters;
import org.locationtech.geowave.analytic.param.MapReduceParameters;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.locationtech.geowave.analytic.param.SampleParameters;
import org.locationtech.geowave.analytic.param.StoreParameters;

public class KMeansSingleSampleJobRunner<T>
extends MapReduceJobController
implements ClusteringRunner {
    final KSamplerJobRunner sampleSetsRunner = new KSamplerJobRunner();
    final KMeansIterationsJobRunner<T> kmeansJobRunner = new KMeansIterationsJobRunner();
    private int currentZoomLevel = 1;

    public KMeansSingleSampleJobRunner() {
        this.setZoomLevel(1);
        this.init(new MapReduceJobRunner[]{this.sampleSetsRunner, this.kmeansJobRunner}, new MapReduceJobController.PostOperationTask[]{DoNothingTask, DoNothingTask});
    }

    @Override
    public void setZoomLevel(int zoomLevel) {
        this.currentZoomLevel = zoomLevel;
        this.sampleSetsRunner.setZoomLevel(zoomLevel);
    }

    @Override
    public void setInputFormatConfiguration(FormatConfiguration inputFormatConfiguration) {
        this.sampleSetsRunner.setInputFormatConfiguration(inputFormatConfiguration);
        this.kmeansJobRunner.setInputFormatConfiguration(inputFormatConfiguration);
    }

    @Override
    public int run(Configuration configuration, PropertyManagement propertyManagement) throws Exception {
        return this.runJob(configuration, propertyManagement);
    }

    private int runJob(Configuration config, PropertyManagement propertyManagement) throws Exception {
        propertyManagement.store((ParameterEnum)CentroidParameters.Centroid.ZOOM_LEVEL, (Object)this.currentZoomLevel);
        propertyManagement.storeIfEmpty((ParameterEnum)GlobalParameters.Global.BATCH_ID, (Serializable)((Object)UUID.randomUUID().toString()));
        propertyManagement.storeIfEmpty((ParameterEnum)CentroidParameters.Centroid.WRAPPER_FACTORY_CLASS, SimpleFeatureItemWrapperFactory.class);
        propertyManagement.storeIfEmpty((ParameterEnum)CommonParameters.Common.DISTANCE_FUNCTION_CLASS, FeatureCentroidDistanceFn.class);
        propertyManagement.storeIfEmpty((ParameterEnum)CentroidParameters.Centroid.EXTRACTOR_CLASS, SimpleFeatureCentroidExtractor.class);
        propertyManagement.storeIfEmpty((ParameterEnum)CommonParameters.Common.DIMENSION_EXTRACT_CLASS, SimpleFeatureGeometryExtractor.class);
        ClusteringUtils.createAdapter((PropertyManagement)propertyManagement);
        ClusteringUtils.createIndex((PropertyManagement)propertyManagement);
        return super.run(config, propertyManagement);
    }

    @Override
    public Collection<ParameterEnum<?>> getParameters() {
        HashSet params = new HashSet();
        params.addAll(this.kmeansJobRunner.getParameters());
        params.addAll(Arrays.asList(ClusteringParameters.Clustering.MAX_REDUCER_COUNT, SampleParameters.Sample.SAMPLE_SIZE, SampleParameters.Sample.SAMPLE_RANK_FUNCTION, CentroidParameters.Centroid.WRAPPER_FACTORY_CLASS, CentroidParameters.Centroid.INDEX_NAME, CentroidParameters.Centroid.DATA_TYPE_ID, CentroidParameters.Centroid.DATA_NAMESPACE_URI, CentroidParameters.Centroid.EXTRACTOR_CLASS, CommonParameters.Common.DISTANCE_FUNCTION_CLASS, CommonParameters.Common.DIMENSION_EXTRACT_CLASS, StoreParameters.StoreParam.INPUT_STORE, GlobalParameters.Global.BATCH_ID, ClusteringParameters.Clustering.MAX_REDUCER_COUNT));
        params.addAll(MapReduceParameters.getParameters());
        params.addAll(NestedGroupCentroidAssignment.getParameters());
        params.remove(CentroidParameters.Centroid.ZOOM_LEVEL);
        params.remove(SampleParameters.Sample.DATA_TYPE_NAME);
        params.remove(SampleParameters.Sample.INDEX_NAME);
        return params;
    }
}

