/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.kmeans.runner;

import java.io.Serializable;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.mapreduce.Job;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.clustering.NestedGroupCentroidAssignment;
import org.locationtech.geowave.analytic.mapreduce.GeoWaveAnalyticJobRunner;
import org.locationtech.geowave.analytic.mapreduce.GeoWaveOutputFormatConfiguration;
import org.locationtech.geowave.analytic.mapreduce.MapReduceJobRunner;
import org.locationtech.geowave.analytic.mapreduce.kmeans.KSamplerMapReduce;
import org.locationtech.geowave.analytic.param.CentroidParameters;
import org.locationtech.geowave.analytic.param.GlobalParameters;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.locationtech.geowave.analytic.param.SampleParameters;
import org.locationtech.geowave.analytic.sample.function.RandomSamplingRankFunction;
import org.locationtech.geowave.analytic.sample.function.SamplingRankFunction;
import org.locationtech.geowave.core.geotime.index.SpatialTemporalDimensionalityTypeProvider;
import org.locationtech.geowave.core.geotime.index.SpatialTemporalOptions;
import org.locationtech.geowave.core.store.adapter.InternalAdapterStore;
import org.locationtech.geowave.core.store.adapter.InternalDataAdapter;
import org.locationtech.geowave.core.store.adapter.PersistentAdapterStore;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.index.IndexStore;
import org.locationtech.geowave.mapreduce.input.GeoWaveInputKey;
import org.locationtech.geowave.mapreduce.output.GeoWaveOutputKey;

public class KSamplerJobRunner
extends GeoWaveAnalyticJobRunner
implements MapReduceJobRunner {
    protected int zoomLevel = 1;
    private Class<? extends SamplingRankFunction> samplingRankFunctionClass = RandomSamplingRankFunction.class;

    public KSamplerJobRunner() {
        super.setOutputFormatConfiguration(new GeoWaveOutputFormatConfiguration());
    }

    public void setSamplingRankFunctionClass(Class<? extends SamplingRankFunction> samplingRankFunctionClass) {
        this.samplingRankFunctionClass = samplingRankFunctionClass;
    }

    public void setZoomLevel(int zoomLevel) {
        this.zoomLevel = zoomLevel;
    }

    @Override
    public Class<?> getScope() {
        return KSamplerMapReduce.class;
    }

    @Override
    public void configure(Job job) throws Exception {
        job.setMapperClass(KSamplerMapReduce.SampleMap.class);
        job.setMapOutputKeyClass(GeoWaveInputKey.class);
        job.setMapOutputValueClass(ObjectWritable.class);
        job.setReducerClass(KSamplerMapReduce.SampleReducer.class);
        job.setPartitionerClass(KSamplerMapReduce.SampleKeyPartitioner.class);
        job.setReduceSpeculativeExecution(false);
        job.setOutputKeyClass(GeoWaveOutputKey.class);
        job.setOutputValueClass(Object.class);
    }

    private InternalDataAdapter<?> getAdapter(PropertyManagement runTimeProperties) throws Exception {
        PersistentAdapterStore adapterStore = super.getAdapterStore(runTimeProperties);
        InternalAdapterStore internalAdapterStore = this.getInternalAdapterStore(runTimeProperties);
        Short sampleInternalAdapterId = internalAdapterStore.getAdapterId(runTimeProperties.getPropertyAsString((ParameterEnum)SampleParameters.Sample.DATA_TYPE_NAME, "sample"));
        if (sampleInternalAdapterId == null) {
            return null;
        }
        return (InternalDataAdapter)adapterStore.getAdapter((Object)sampleInternalAdapterId);
    }

    private Index getIndex(PropertyManagement runTimeProperties) throws Exception {
        IndexStore indexStore = super.getIndexStore(runTimeProperties);
        return indexStore.getIndex(runTimeProperties.getPropertyAsString((ParameterEnum)SampleParameters.Sample.INDEX_NAME, "index"));
    }

    @Override
    public int run(Configuration config, PropertyManagement runTimeProperties) throws Exception {
        runTimeProperties.storeIfEmpty((ParameterEnum)GlobalParameters.Global.BATCH_ID, (Serializable)((Object)UUID.randomUUID().toString()));
        runTimeProperties.storeIfEmpty((ParameterEnum)SampleParameters.Sample.DATA_TYPE_NAME, (Serializable)((Object)"sample"));
        runTimeProperties.store((ParameterEnum)CentroidParameters.Centroid.ZOOM_LEVEL, (Object)this.zoomLevel);
        runTimeProperties.storeIfEmpty((ParameterEnum)SampleParameters.Sample.INDEX_NAME, (Serializable)((Object)SpatialTemporalDimensionalityTypeProvider.createIndexFromOptions((SpatialTemporalOptions)new SpatialTemporalOptions()).getName()));
        runTimeProperties.setConfig(new ParameterEnum[]{GlobalParameters.Global.BATCH_ID, SampleParameters.Sample.INDEX_NAME, SampleParameters.Sample.SAMPLE_SIZE, SampleParameters.Sample.DATA_TYPE_NAME, CentroidParameters.Centroid.EXTRACTOR_CLASS, CentroidParameters.Centroid.WRAPPER_FACTORY_CLASS, CentroidParameters.Centroid.ZOOM_LEVEL}, config, this.getScope());
        SampleParameters.Sample.SAMPLE_RANK_FUNCTION.getHelper().setValue(config, this.getScope(), this.samplingRankFunctionClass);
        NestedGroupCentroidAssignment.setParameters((Configuration)config, this.getScope(), (PropertyManagement)runTimeProperties);
        KSamplerJobRunner.addDataAdapter(config, this.getAdapter(runTimeProperties));
        KSamplerJobRunner.addIndex(config, this.getIndex(runTimeProperties));
        super.setReducerCount(this.zoomLevel);
        return super.run(config, runTimeProperties);
    }

    @Override
    protected String getJobName() {
        return "K-Sampler";
    }
}

