/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.kmeans.runner;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.SimpleFeatureItemWrapperFactory;
import org.locationtech.geowave.analytic.clustering.CentroidManagerGeoWave;
import org.locationtech.geowave.analytic.clustering.NestedGroupCentroidAssignment;
import org.locationtech.geowave.analytic.distance.FeatureCentroidDistanceFn;
import org.locationtech.geowave.analytic.extract.SimpleFeatureCentroidExtractor;
import org.locationtech.geowave.analytic.extract.SimpleFeatureGeometryExtractor;
import org.locationtech.geowave.analytic.mapreduce.MapReduceJobController;
import org.locationtech.geowave.analytic.mapreduce.MapReduceJobRunner;
import org.locationtech.geowave.analytic.mapreduce.kmeans.runner.IterationCountCalculateRunner;
import org.locationtech.geowave.analytic.mapreduce.kmeans.runner.KSamplerJobRunner;
import org.locationtech.geowave.analytic.mapreduce.kmeans.runner.RankSamplerJobRunner;
import org.locationtech.geowave.analytic.mapreduce.kmeans.runner.StripWeakCentroidsRunner;
import org.locationtech.geowave.analytic.mapreduce.kmeans.runner.UpdateCentroidCostJobRunner;
import org.locationtech.geowave.analytic.param.CentroidParameters;
import org.locationtech.geowave.analytic.param.ClusteringParameters;
import org.locationtech.geowave.analytic.param.CommonParameters;
import org.locationtech.geowave.analytic.param.FormatConfiguration;
import org.locationtech.geowave.analytic.param.GlobalParameters;
import org.locationtech.geowave.analytic.param.MapReduceParameters;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.locationtech.geowave.analytic.param.SampleParameters;
import org.locationtech.geowave.analytic.param.StoreParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleMultipleSetsJobRunner<T>
extends MapReduceJobController
implements MapReduceJobRunner {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SampleMultipleSetsJobRunner.class);
    private final KSamplerJobRunner initialSampleRunner = new KSamplerJobRunner();
    private final UpdateCentroidCostJobRunner updateCostRunner = new UpdateCentroidCostJobRunner();
    private final RankSamplerJobRunner jobGrowSampleRunner = new RankSamplerJobRunner();
    private final StripWeakCentroidsRunner<T> stripWeakCentroidsRunner = new StripWeakCentroidsRunner();
    private final IterationCountCalculateRunner<T> iterationCountCalculateRunner = new IterationCountCalculateRunner();
    private int iterations = 1;
    private int zoomLevel = 1;

    public SampleMultipleSetsJobRunner() {
        this.stage1Setup();
    }

    private void stage1Setup() {
        this.init(new MapReduceJobRunner[]{this.initialSampleRunner, this.updateCostRunner, this.iterationCountCalculateRunner}, new MapReduceJobController.PostOperationTask[]{DoNothingTask, DoNothingTask, DoNothingTask});
    }

    public int getCurrentCentroidCount() {
        return this.stripWeakCentroidsRunner.getCurrentCentroidCount();
    }

    private void stage2Setup(final PropertyManagement runTimeProperties) {
        this.setIterations(this.iterationCountCalculateRunner.getIterationsCount());
        this.init(new MapReduceJobRunner[]{this.jobGrowSampleRunner, this.updateCostRunner, this.stripWeakCentroidsRunner}, new MapReduceJobController.PostOperationTask[]{DoNothingTask, DoNothingTask, new MapReduceJobController.PostOperationTask(){

            @Override
            public void runTask(Configuration config, MapReduceJobRunner runner) {
                SampleMultipleSetsJobRunner.this.updateCostRunner.setReducerCount(Math.min(SampleMultipleSetsJobRunner.this.stripWeakCentroidsRunner.getCurrentCentroidCount(), runTimeProperties.getPropertyAsInt((ParameterEnum)ClusteringParameters.Clustering.MAX_REDUCER_COUNT, 32)));
            }
        }});
    }

    @Override
    public int run(Configuration config, PropertyManagement runTimeProperties) throws Exception {
        this.updateCostRunner.setReducerCount(1);
        this.stripWeakCentroidsRunner.setRange(runTimeProperties.getPropertyAsInt((ParameterEnum)SampleParameters.Sample.MIN_SAMPLE_SIZE, 2), runTimeProperties.getPropertyAsInt((ParameterEnum)SampleParameters.Sample.MAX_SAMPLE_SIZE, 1000));
        runTimeProperties.store((ParameterEnum)SampleParameters.Sample.SAMPLE_SIZE, (Object)runTimeProperties.getPropertyAsInt((ParameterEnum)SampleParameters.Sample.MAX_SAMPLE_SIZE, 1000));
        this.setIterations(runTimeProperties.getPropertyAsInt((ParameterEnum)SampleParameters.Sample.SAMPLE_ITERATIONS, 1));
        runTimeProperties.storeIfEmpty((ParameterEnum)CentroidParameters.Centroid.WRAPPER_FACTORY_CLASS, SimpleFeatureItemWrapperFactory.class);
        runTimeProperties.storeIfEmpty((ParameterEnum)CommonParameters.Common.DISTANCE_FUNCTION_CLASS, FeatureCentroidDistanceFn.class);
        runTimeProperties.storeIfEmpty((ParameterEnum)CentroidParameters.Centroid.EXTRACTOR_CLASS, SimpleFeatureCentroidExtractor.class);
        runTimeProperties.storeIfEmpty((ParameterEnum)CommonParameters.Common.DIMENSION_EXTRACT_CLASS, SimpleFeatureGeometryExtractor.class);
        runTimeProperties.copy((ParameterEnum)CentroidParameters.Centroid.DATA_TYPE_ID, (ParameterEnum)SampleParameters.Sample.DATA_TYPE_NAME);
        runTimeProperties.copy((ParameterEnum)CentroidParameters.Centroid.INDEX_NAME, (ParameterEnum)SampleParameters.Sample.INDEX_NAME);
        runTimeProperties.store((ParameterEnum)CentroidParameters.Centroid.ZOOM_LEVEL, (Object)this.zoomLevel);
        this.stage1Setup();
        int status1 = super.run(config, runTimeProperties);
        if (status1 != 0) {
            return status1;
        }
        this.stage2Setup(runTimeProperties);
        for (int i = 0; i < this.iterations; ++i) {
            int status2 = super.run(config, runTimeProperties);
            if (status2 == 0) continue;
            return status2;
        }
        return 0;
    }

    @Override
    public Collection<ParameterEnum<?>> getParameters() {
        HashSet params = new HashSet();
        params.addAll(Arrays.asList(SampleParameters.Sample.MAX_SAMPLE_SIZE, SampleParameters.Sample.SAMPLE_ITERATIONS, SampleParameters.Sample.MIN_SAMPLE_SIZE, CentroidParameters.Centroid.WRAPPER_FACTORY_CLASS, CentroidParameters.Centroid.INDEX_NAME, CentroidParameters.Centroid.DATA_TYPE_ID, CentroidParameters.Centroid.DATA_NAMESPACE_URI, CentroidParameters.Centroid.EXTRACTOR_CLASS, CommonParameters.Common.DISTANCE_FUNCTION_CLASS, CommonParameters.Common.DIMENSION_EXTRACT_CLASS, StoreParameters.StoreParam.INPUT_STORE, GlobalParameters.Global.BATCH_ID));
        params.addAll(MapReduceParameters.getParameters());
        params.addAll(NestedGroupCentroidAssignment.getParameters());
        params.addAll(CentroidManagerGeoWave.getParameters());
        params.addAll(this.initialSampleRunner.getParameters());
        return params;
    }

    public void setInputFormatConfiguration(FormatConfiguration inputFormatConfiguration) {
        this.initialSampleRunner.setInputFormatConfiguration(inputFormatConfiguration);
        this.updateCostRunner.setInputFormatConfiguration(inputFormatConfiguration);
        this.jobGrowSampleRunner.setInputFormatConfiguration(inputFormatConfiguration);
    }

    private void setIterations(int iterations) {
        this.iterations = Math.max(this.iterations, iterations);
    }

    public void setZoomLevel(int zoomLevel) {
        this.zoomLevel = zoomLevel;
        this.initialSampleRunner.setZoomLevel(zoomLevel);
        this.jobGrowSampleRunner.setZoomLevel(zoomLevel);
    }
}

